/*
 * Decompiled with CFR 0.152.
 */
package bibtex.expansions;

import bibtex.dom.BibtexEntry;
import bibtex.dom.BibtexFile;
import bibtex.dom.BibtexString;
import bibtex.expansions.AbstractExpander;
import bibtex.expansions.BibtexPersonListParser;
import bibtex.expansions.Expander;
import bibtex.expansions.ExpansionException;
import bibtex.expansions.PersonListParserException;
import java.util.Iterator;

public class PersonListExpander
extends AbstractExpander
implements Expander {
    private boolean expandAuthors;
    private boolean expandEditors;

    public PersonListExpander(boolean expandAuthors, boolean expandEditors) {
        this(expandAuthors, expandEditors, true);
    }

    public PersonListExpander(boolean expandAuthors, boolean expandEditors, boolean throwAllExpansionExceptions) {
        super(throwAllExpansionExceptions);
        this.expandAuthors = expandAuthors;
        this.expandEditors = expandEditors;
    }

    public void expand(BibtexFile file) throws ExpansionException {
        Iterator entryIt = file.getEntries().iterator();
        while (entryIt.hasNext()) {
            Object next = entryIt.next();
            if (!(next instanceof BibtexEntry)) continue;
            BibtexEntry entry = (BibtexEntry)next;
            if (this.expandAuthors && entry.getFieldValue("author") != null) {
                try {
                    entry.setField("author", BibtexPersonListParser.parse((BibtexString)entry.getFieldValue("author"), entry.getEntryKey()));
                }
                catch (PersonListParserException e) {
                    this.throwExpansionException(e);
                }
            }
            if (!this.expandEditors || entry.getFieldValue("editor") == null) continue;
            try {
                entry.setField("editor", BibtexPersonListParser.parse((BibtexString)entry.getFieldValue("editor"), entry.getEntryKey()));
            }
            catch (PersonListParserException e) {
                this.throwExpansionException(e);
            }
        }
        this.finishExpansion();
    }
}

