/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.resources;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.Session;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sciplore.resources.Person;
import org.sciplore.resources.Resource;

@Entity
@Table(name="contacts")
public class Contact
extends Resource {
    public static final short CONTACT_TYPE_PRIVATE = 1;
    public static final short CONTACT_TYPE_BUSINESS = 2;
    public static final short CONTACT_TYPE_EMAIL = 4;
    public static final short CONTACT_TYPE_HOMEPAGE = 8;
    public static final short CONTACT_TYPE_PRIVATE_EMAIL = 5;
    public static final short CONTACT_TYPE_PRIVATE_HOMEPAGE = 9;
    public static final short CONTACT_TYPE_BUSINESS_EMAIL = 6;
    public static final short CONTACT_TYPE_BUSINESS_HOMEPAGE = 10;
    private String description;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(nullable=false)
    private Integer id;
    @ManyToOne
    @JoinColumn(name="person_id", nullable=false)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Person person;
    @Column(nullable=false)
    private Short type;
    @Column(nullable=false)
    private String uri;
    @Column(nullable=false)
    private Short valid = 1;

    public Contact getContact(Contact c) {
        if (c.getId() != null) {
            return this.getContact(c.getId());
        }
        return this.getContact(c.getPerson(), c.getUri());
    }

    public Contact getContact(Integer id) {
        return (Contact)this.getSession().get(Contact.class, (Serializable)id);
    }

    public Contact getContact(String uri) {
        return (Contact)this.getSession().createCriteria(Contact.class).add((Criterion)Restrictions.eq((String)"uri", (Object)uri)).setMaxResults(1).uniqueResult();
    }

    public Contact getContact(Person p, String uri) {
        return (Contact)this.getSession().createCriteria(Contact.class).add((Criterion)Restrictions.eq((String)"person", (Object)p)).add((Criterion)Restrictions.eq((String)"uri", (Object)uri)).setMaxResults(1).uniqueResult();
    }

    public Contact() {
    }

    public Contact(Session s) {
        this.setSession(s);
    }

    public Contact(Session s, Person person, String uri, Short type) {
        this.setSession(s);
        this.person = person;
        this.uri = uri;
        this.type = type;
    }

    public Contact(Session s, String uri, Short type) {
        this.setSession(s);
        this.uri = uri;
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getId() {
        return this.id;
    }

    public Person getPerson() {
        return this.person;
    }

    public Short getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    public Short getValid() {
        return this.valid;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setValid(Short valid) {
        this.valid = valid;
    }
}

