/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.writer;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class LogWriter
extends FilterWriter {
    private Writer log;

    public LogWriter(Writer o, Writer log) {
        super(o);
        this.setLog(log);
    }

    public void close() throws IOException {
        super.close();
        if (this.getLog() != null) {
            this.getLog().close();
        }
    }

    public void flush() throws IOException {
        super.flush();
        if (this.getLog() != null) {
            this.getLog().flush();
        }
    }

    public Writer getLog() {
        return this.log;
    }

    private void setLog(Writer newLog) {
        this.log = newLog;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        super.write(cbuf, off, len);
        if (this.getLog() != null) {
            this.getLog().write(cbuf, off, len);
        }
    }

    public void write(int c) throws IOException {
        super.write(c);
        if (this.getLog() != null) {
            this.getLog().write(c);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        super.write(str, off, len);
        if (this.getLog() != null) {
            this.getLog().write(str, off, len);
        }
    }
}

