/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class PartitionedMap
implements Map {
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int ENTRIES = 2;
    private Map child;
    private Map parent;

    public static Map create(Map parent, Map child) {
        if (parent == null) {
            return child;
        }
        if (child == null) {
            return parent;
        }
        return new PartitionedMap(parent, child);
    }

    public PartitionedMap() {
        this(null, null);
    }

    public PartitionedMap(Map parent, Map child) {
        this.setChild(child == null ? new HashMap() : child);
        this.setParent(parent == null ? new HashMap() : parent);
    }

    public void clear() {
        this.getChild().clear();
    }

    public boolean containsKey(Object key) {
        return this.getChild().containsKey(key) || this.getParent() != null && this.getParent().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.getChild().containsValue(value) || this.getParent() != null && this.getParent().containsValue(value);
    }

    public Set entrySet() {
        AbstractSet set = new AbstractSet(){

            public void clear() {
                PartitionedMap.this.getChild().clear();
            }

            public boolean contains(Object o) {
                return PartitionedMap.this.getChild().entrySet().contains(o) || PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().entrySet().contains(o);
            }

            public Iterator iterator() {
                return new PartitionIterator(2);
            }

            public boolean remove(Object o) {
                return PartitionedMap.this.getChild().entrySet().remove(o) || PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().entrySet().remove(o);
            }

            public int size() {
                return PartitionedMap.this.getChild().size() + (PartitionedMap.this.getParent() == null ? 0 : PartitionedMap.this.getParent().size());
            }
        };
        return set;
    }

    public Object get(Object key) {
        Object result = this.getChild().get(key);
        return result == null ? (this.getParent() == null ? null : this.getParent().get(key)) : result;
    }

    protected Map getChild() {
        return this.child;
    }

    public Map getParent() {
        return this.parent;
    }

    public boolean isEmpty() {
        return this.getChild().isEmpty() && (this.getParent() == null || this.getParent().isEmpty());
    }

    public Set keySet() {
        AbstractSet set = new AbstractSet(){

            public void clear() {
                PartitionedMap.this.getChild().clear();
            }

            public boolean contains(Object o) {
                return PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().containsKey(o) || PartitionedMap.this.getChild().containsKey(o);
            }

            public Iterator iterator() {
                return new PartitionIterator(0);
            }

            public boolean remove(Object o) {
                return PartitionedMap.this.getChild().remove(o) != null || PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().remove(o) != null;
            }

            public int size() {
                return PartitionedMap.this.getChild().size() + (PartitionedMap.this.getParent() == null ? 0 : PartitionedMap.this.getParent().size());
            }
        };
        return set;
    }

    public Object put(Object key, Object value) {
        return this.getChild().put(key, value);
    }

    public void putAll(Map t) {
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        if (this.getParent() != null && this.getParent().containsKey(key)) {
            return this.getParent().remove(key);
        }
        return this.getChild().remove(key);
    }

    private void setChild(Map newSubMap) {
        this.child = newSubMap;
    }

    public void setParent(Map newParent) {
        this.parent = newParent;
    }

    public int size() {
        return (this.getParent() == null ? 0 : this.getParent().size()) + this.getChild().size();
    }

    public String toString() {
        return String.valueOf(this.getParent() == null ? "" : String.valueOf(this.getParent().toString()) + System.getProperty("line.separator")) + this.getChild().toString();
    }

    public Collection values() {
        AbstractCollection c = new AbstractCollection(){

            public void clear() {
                PartitionedMap.this.getChild().clear();
            }

            public boolean contains(Object o) {
                return PartitionedMap.this.getParent() != null && PartitionedMap.this.getParent().containsValue(o) || PartitionedMap.this.getChild().containsValue(o);
            }

            public Iterator iterator() {
                return new PartitionIterator(1);
            }

            public int size() {
                return PartitionedMap.this.getChild().size() + (PartitionedMap.this.getParent() == null ? 0 : PartitionedMap.this.getParent().size());
            }
        };
        return c;
    }

    private class PartitionIterator
    implements Iterator {
        Iterator parentIterator;
        Iterator subIterator;
        int type;

        PartitionIterator(int type) {
            this.parentIterator = PartitionedMap.this.getParent().entrySet().iterator();
            this.subIterator = PartitionedMap.this.getChild().entrySet().iterator();
            this.type = type;
        }

        public boolean hasNext() {
            return this.parentIterator.hasNext() || this.subIterator.hasNext();
        }

        public Object next() {
            Map.Entry e = null;
            e = this.parentIterator.hasNext() ? (Map.Entry)this.parentIterator.next() : (Map.Entry)this.subIterator.next();
            if (e != null) {
                return this.type == 0 ? e.getKey() : (this.type == 1 ? e.getValue() : e);
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("Partitioned Maps do not support this");
        }
    }
}

