/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXB;
import org.jetbrains.annotations.NonNls;
import org.sciplore.xml.XmlApplication;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.Preferences.UserDataState;
import splmm.SciPloreUtils;

@NonNls
public class SciPloreWebClient {
    private static Client CLIENT = Client.create();
    private static WebResource WEBRESOURCE;
    private static final String PASSWORD = "password";
    private static final String USER_NAME = "userName";
    private static final String ALLOW_IR = "allowIR";
    private static final String BACKUP = "backup";
    private static final String MIND_MAP = "mindMap";
    private static final String USER_TYPE = "userType";
    private static final String ANONYMOUS_USER_TYPE = "3";
    private static final String FILENAME = "filename";

    public static String postMindMap(String mindmap, String fileName) {
        if (SplmmPreferences.getUserName() == null || SplmmPreferences.getUserName().isEmpty() || SplmmPreferences.getUserName().equalsIgnoreCase(LocalizationSupport.message("anonymous"))) {
            return null;
        }
        try {
            byte[] data = SciPloreUtils.zip(mindmap);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.field(MIND_MAP, (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            formDataMultiPart.field(USER_NAME, SplmmPreferences.getUserName());
            formDataMultiPart.field(ALLOW_IR, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonMM()));
            formDataMultiPart.field(BACKUP, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowBackup()));
            formDataMultiPart.field(FILENAME, fileName);
            if (UserDataState.getCurrentState() == 1) {
                formDataMultiPart.field(PASSWORD, (Object)SplmmPreferences.getPassword(), MediaType.TEXT_PLAIN_TYPE);
            }
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user/" + SplmmPreferences.getUserName() + "/mindmaps").type(MediaType.MULTIPART_FORM_DATA_TYPE).post(ClientResponse.class, (Object)formDataMultiPart);
            String mindmapID = (String)response.getEntity(String.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
                return mindmapID;
            }
        }
        catch (ClientHandlerException e) {
            String msg = "Could not post Mindmap: filename: " + fileName + "; Username: " + SplmmPreferences.getUserName() + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void putMindMap(String mindmap, String mindmapID, String fileName) {
        if (SplmmPreferences.getUserName() == null || SplmmPreferences.getUserName().isEmpty() || SplmmPreferences.getUserName().equalsIgnoreCase(LocalizationSupport.message("anonymous"))) {
            return;
        }
        try {
            byte[] data = SciPloreUtils.zip(mindmap);
            FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
            formDataMultiPart.field(MIND_MAP, (Object)data, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            formDataMultiPart.field(USER_NAME, SplmmPreferences.getUserName());
            formDataMultiPart.field(ALLOW_IR, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowIRonMM()));
            formDataMultiPart.field(BACKUP, SciPloreUtils.parseBoolean(SplmmPreferences.getAllowBackup()));
            formDataMultiPart.field(FILENAME, fileName);
            if (UserDataState.getCurrentState() == 1) {
                formDataMultiPart.field(PASSWORD, (Object)SplmmPreferences.getPassword(), MediaType.TEXT_PLAIN_TYPE);
            }
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user/" + SplmmPreferences.getUserName() + "/mindmaps/" + mindmapID).type(MediaType.MULTIPART_FORM_DATA_TYPE).put(ClientResponse.class, (Object)formDataMultiPart);
            String string = (String)response.getEntity(String.class);
            if (response.getClientResponseStatus() != ClientResponse.Status.OK) return;
        }
        catch (ClientHandlerException e) {
            String msg = "Could not put Mindmap: filename: " + fileName + "; Username: " + SplmmPreferences.getUserName() + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
        }
    }

    public static ValidationState validateUserData(String username, String password) {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)USER_NAME, (Object)username);
        formParams.add((Object)PASSWORD, (Object)password);
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user").put(ClientResponse.class, (Object)formParams);
            switch (response.getClientResponseStatus()) {
                case BAD_REQUEST: {
                    JOptionPane.showMessageDialog(null, LocalizationSupport.message("user.name.is.not.allowed.to.be.empty"), LocalizationSupport.message("error"), 0);
                    return ValidationState.NOT_VALID;
                }
                case UNAUTHORIZED: {
                    JOptionPane.showMessageDialog(null, LocalizationSupport.message("user.name.or.password.wrong"), LocalizationSupport.message("error"), 0);
                    return ValidationState.NOT_VALID;
                }
                case OK: {
                    username = (String)response.getEntity(String.class);
                    SplmmPreferences.setCredentialsValidated(true);
                    return ValidationState.VALID;
                }
            }
            return ValidationState.EXCEPTION;
        }
        catch (ClientHandlerException e) {
            String msg = "Could not validate Userdata:  Username: " + username + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
            if (SciPloreWebClient.isInternetReachable()) {
                return ValidationState.SERVICE_DOWN;
            }
            return ValidationState.CONNECTION_PROBLEM;
        }
    }

    public static Boolean createAnonymousUser(String username) {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)USER_NAME, (Object)username);
        formParams.add((Object)USER_TYPE, (Object)ANONYMOUS_USER_TYPE);
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("user/" + username).post(ClientResponse.class, (Object)formParams);
            ClientResponse.Status status = response.getClientResponseStatus();
            if (status != null) {
                switch (status) {
                    case BAD_REQUEST: {
                        return false;
                    }
                    case OK: {
                        SplmmPreferences.setCredentialsValidated(true);
                        return true;
                    }
                }
                return true;
            }
            return false;
        }
        catch (ClientHandlerException e) {
            String msg = "Could not create Anonymous User: Username: " + username + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
            return true;
        }
    }

    public static XmlApplication checkVersion() {
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/versioncheck/" + SciPloreUtils.APP_ID + "/current").get(ClientResponse.class);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK && response.hasEntity()) {
                String entity = (String)response.getEntity(String.class);
                byte[] bytes = entity.getBytes();
                ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                if (is != null) {
                    XmlApplication app = (XmlApplication)JAXB.unmarshal((InputStream)is, XmlApplication.class);
                    System.out.println(app.getName() + " " + app.getVersion() + " " + app.getReleaseNote() + " " + app.getVersionStatusAsString() + "\n\n");
                    return app;
                }
                return null;
            }
        }
        catch (Exception e) {
            String msg = "Could not check Version: Application ID: " + SciPloreUtils.APP_ID + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
        }
        return null;
    }

    public static boolean sendEvent(short event, String eventData) {
        MultivaluedMapImpl formParams = new MultivaluedMapImpl();
        formParams.add((Object)"version", (Object)SciPloreUtils.APP_VERSION_SHORT);
        String username = SplmmPreferences.getUserName();
        if (username == null || username.isEmpty() || username.equalsIgnoreCase("anonymous")) {
            SplmmPreferences.createUUID();
        }
        formParams.add((Object)"username", (Object)SplmmPreferences.getUserName());
        formParams.add((Object)"eventdata", (Object)eventData);
        try {
            ClientResponse response = (ClientResponse)WEBRESOURCE.path("service/stats/usage/" + SciPloreUtils.APP_ID + "/" + event).post(ClientResponse.class, (Object)formParams);
            if (response.getClientResponseStatus() == ClientResponse.Status.OK) {
                return true;
            }
            String msg = "Could not send Event: Application ID: " + SciPloreUtils.APP_ID + "; Event ID: " + event + "; Username: " + SplmmPreferences.getUserName() + "; Event Data: " + eventData + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
            return false;
        }
        catch (ClientHandlerException e) {
            String msg = "Could not send Event: Application ID: " + SciPloreUtils.APP_ID + "; Event ID: " + event + "; Username: " + SplmmPreferences.getUserName() + "; Event Data: " + eventData + "; ";
            SciPloreUtils.log(SciPloreWebClient.class.getName(), msg, Level.WARNING);
            return false;
        }
    }

    private static boolean isInternetReachable() {
        try {
            URL url = new URL("http://www.google.com");
            HttpURLConnection urlConnect = (HttpURLConnection)url.openConnection();
            urlConnect.setConnectTimeout(1000);
            Object object = urlConnect.getContent();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static {
        CLIENT.setConnectTimeout(Integer.valueOf(100));
        CLIENT.setReadTimeout(Integer.valueOf(7000));
        WEBRESOURCE = CLIENT.resource("http://api.sciplore.org/rest/");
    }

    public static enum ValidationState {
        VALID,
        NOT_VALID,
        EXCEPTION,
        CONNECTION_PROBLEM,
        SERVICE_DOWN;

    }
}

