/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import freemind.controller.Controller;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.sciplore.xml.XmlApplication;
import splmm.Gui.IrNotfication;
import splmm.Gui.Preferences;
import splmm.Listeners.SplmmWindowsFocusListener;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreWebClient;
import splmm.Thread.EventSenderThread;
import splmm.Thread.PrefEventSenderThread;

public class SciPloreUtils {
    public static String SPLMM_REFKEY_NAME = "splmm_refkey";
    public static final String SPLMM_REFKEY_TITLE = "splmm_reftitle";
    public static String SPLMM_DIRMON_PATH = "splmm_dirmon_path";
    public static String SPLMM_DIRMON_AUTO = "splmm_dirmon_auto";
    public static String SPLMM_DIRMON_SUBDIRS = "splmm_dirmon_subdirs";
    public static String SPLMM_URL = "http://www.sciplore.org/software/sciplore_mindmapping/";
    public static String CONTACT_URL = "http://www.sciplore.org/contact_en.php?progID=1";
    public static String ABOUT_URL = "http://www.sciplore.org/about_en.php";
    public static String HELP_URL = "http://www.sciplore.org/software/sciplore_mindmapping/manual/en/";
    public static String PRIVACY_URL = "www.sciplore.org/privacy/splmm_en.php";
    public static String SAVE_TEXT = "<!-- To view this file, download free mind mapping software SciPlore MindMapping from http://www.sciplore.org/software/sciplore_mindmapping/ -->\n";
    public static String APP_VERSION = "beta13";
    public static String APP_VERSION_SHORT = "0.13";
    public static double APP_VERSION_Double = 1.3;
    public static double PREF_VERSION_Double = 1.0;
    public static String ABOUT_VERSION_TEXT = "SciPlore MindMapping -- Beta 13";
    public static int APP_ID = 1;
    public static final ArrayList<String> DEFAULT_FILE_TYPES = new ArrayList(){
        {
            this.add(".pdf");
            this.add(".doc");
            this.add(".docx");
            this.add(".xls");
            this.add(".xlsx");
            this.add(".odt");
            this.add(".txt");
            this.add(".rtf");
        }
    };
    public static final ArrayList<String> DEFAULT_SUBFOLDERS = new ArrayList(){
        {
            this.add(".svn");
        }
    };
    public static short EVENT_APP_STARTED = (short)101;
    public static short EVENT_APP_CLOSED = (short)102;
    public static short EVENT_APP_MIN = (short)103;
    public static short EVENT_APP_MAX = (short)104;
    public static short EVENT_FILE_OPENED = (short)201;
    public static short EVENT_FILE_CLOSED = (short)202;
    public static short EVENT_FILE_SAVED = (short)203;
    public static short EVENT_FILE_AUTO_SAVED = (short)204;
    public static short EVENT_FILE_NEW = (short)205;
    public static short EVENT_BIB_LINKED = (short)301;
    public static short EVENT_BACKUP = (short)302;
    public static short EVENT_IRMM = (short)303;
    public static short EVENT_IRLD = (short)304;
    public static short EVENT_AUTO_IMPORT = (short)305;
    public static short EVENT_APP_LANGUAGE = (short)306;
    public static short EVENT_BACKUP_NOTIFICATION = (short)307;
    public static short EVENT_IR_NOTIFICATION = (short)308;
    public static short EVENT_ALLOW_USAGE_MINING = (short)309;
    public static short EVENT_UPDATE_REFKEYS = (short)401;
    public static short EVENT_SHOW_PREFS = (short)402;
    public static short EVENT_VIEW_LOGS = (short)403;
    public static short EVENT_SHOW_HELP = (short)404;
    public static short EVENT_SHOW_CONTACTS = (short)405;
    public static short EVENT_IMPORT_BOOKMARKS = (short)406;
    public static short EVENT_ADD_REFKEYS = (short)407;
    public static short EVENT_EDIT_REFKEYS = (short)408;
    public static short EVENT_COPY_REFKEYS = (short)409;
    public static short EVENT_COPY_CITE_REFKEYS = (short)410;
    public static short EVENT_DELETE_REFKEYS = (short)411;
    public static short EVENT_ADD_MON_DIR = (short)412;
    public static short EVENT_REMOVE_MON_DIR = (short)413;
    public static short EVENT_EDIT_MON_DIR = (short)414;
    public static short EVENT_READ_MON_DIR = (short)415;
    public static short EVENT_CHANGE_USERNAME = (short)416;
    public static short EVENT_CHANGE_ACTIVE_MINDMAP = (short)417;
    public static short EVENT_ABORT_READ_MON_DIR = (short)418;
    public static short EVENT_OPEN_URL = (short)419;
    public static short EVENT_RANDOM_TAB = (short)450;
    public static short EVENT_RANDOM_UM = (short)451;
    public static short EVENT_RANDOM_IRMM = (short)452;
    public static short EVENT_RANDOM_IRLD = (short)453;
    public static short EVENT_RANDOM_BACKUP = (short)454;
    public static short EVENT_RANDOM_INFOTEXT = (short)455;
    public static short EVENT_RANDOM_INFOLABEL = (short)456;
    public static short EVENT_RANDOM_PRIVACYBUTTON = (short)457;
    public static short EVENT_SCREEN_RES = (short)501;
    public static short EVENT_OS = (short)502;
    public static short EVENT_OS_LANGUAGE = (short)503;
    public static FreeMindMain frame;

    public static void checkForUpdate(FreeMindMain frame) {
        SciPloreUtils.frame = frame;
        frame.getJFrame().addWindowFocusListener(new SplmmWindowsFocusListener());
        new EventSenderThread(EVENT_APP_STARTED, "");
        new PrefEventSenderThread();
        if (!SplmmPreferences.getUpdateInfo().booleanValue()) {
            return;
        }
        XmlApplication currentApp = SciPloreWebClient.checkVersion();
        if (currentApp == null) {
            return;
        }
        String currentVersion = currentApp.getVersion();
        if (!currentVersion.equals(APP_VERSION_SHORT) && !currentVersion.equalsIgnoreCase(SplmmPreferences.getInformedUpdateVersion()) && SplmmPreferences.getUpdateInfo().booleanValue()) {
            String notification = LocalizationSupport.message("splmm_update_notification");
            JLabel label = new JLabel(notification);
            label.setFont(new Font("sansserif", 0, 14));
            Object[] options = new Object[]{LocalizationSupport.message("splmm_update_ignore"), LocalizationSupport.message("splmm_visit_website")};
            int n = JOptionPane.showOptionDialog(frame.getJFrame(), label, "", 0, 1, null, options, options[1]);
            if (n == 1) {
                SplmmPreferences.setInformedUpdateVersion(currentVersion);
                SciPloreUtils.openURL(SPLMM_URL);
            }
            if (n == 0) {
                SplmmPreferences.setInformedUpdateVersion(currentVersion);
            }
        }
    }

    public static void openURL(String url) {
        try {
            String osName = System.getProperty("os.name");
            if (osName.substring(0, 3).equals("Win")) {
                String command = "rundll32 url.dll,FileProtocolHandler " + url;
                Runtime.getRuntime().exec(command);
            } else if (osName.startsWith("Mac OS")) {
                String command = "open -a //Applications//Safari.app " + url;
                Runtime.getRuntime().exec(command);
            } else {
                String command = "xdg-open " + url;
                Runtime.getRuntime().exec(command);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static String parseBoolean(Boolean bool) {
        if (bool.booleanValue()) {
            return "1";
        }
        return "0";
    }

    public static String getStackTraceAsString(Exception exception) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(" [ ");
        pw.print(exception.getClass().getName());
        pw.print(" ] ");
        pw.print(exception.getMessage());
        exception.printStackTrace(pw);
        return sw.toString();
    }

    public static void logException(String className, Exception exception, Level level) {
        if (frame != null) {
            Logger logger = frame.getLogger(className);
            String stringException = SciPloreUtils.getStackTraceAsString(exception);
            System.out.println(stringException);
            logger.log(level, className + ": " + stringException);
        } else {
            System.out.println("Could not log: " + SciPloreUtils.getStackTraceAsString(exception));
        }
    }

    public static void log(String className, String msg, Level level) {
        if (frame != null) {
            Logger logger = frame.getLogger(className);
            logger.log(level, className + ": " + msg);
        }
        System.out.println("Console log: " + msg);
    }

    public static String getMindMapID(File file) {
        try {
            int endIndex;
            String string;
            StringBuffer buffer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            while ((string = reader.readLine()) != null) {
                buffer.append(string);
            }
            int startIndex = buffer.indexOf("mapID=\"");
            if (startIndex != -1 && (endIndex = buffer.indexOf("\"", startIndex + 7)) != -1) {
                return buffer.substring(startIndex + 7, endIndex);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(SciPloreUtils.getStackTraceAsString(e));
        }
        catch (IOException e) {
            System.out.println(SciPloreUtils.getStackTraceAsString(e));
        }
        return null;
    }

    public static String getResource(String key) {
        return frame.getResourceString(key);
    }

    public static byte[] zip(String mindmap) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BufferedOutputStream bufos = null;
            bufos = new BufferedOutputStream(new GZIPOutputStream(bos));
            bufos.write(mindmap.getBytes());
            bufos.close();
            byte[] retval = bos.toByteArray();
            bos.close();
            return retval;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeToUnicodeStandard(String pData) {
        StringBuffer encodedData = new StringBuffer();
        StringBuffer sBuff = new StringBuffer(pData);
        for (int i = 0; i < sBuff.length(); ++i) {
            char ch = sBuff.charAt(i);
            char chVal = ch;
            if (chVal > '\u007f') {
                encodedData.append("&#x").append(Integer.toHexString(chVal)).append(";");
                continue;
            }
            encodedData.append(ch);
        }
        return encodedData.toString();
    }

    public static short parseBoolean(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    public static boolean parseInt(int i) {
        return i == 1;
    }

    public static void checkStartCounter() {
        SplmmPreferences.setStartCounter(SplmmPreferences.getStartCounter() + 1);
        if (SplmmPreferences.getStartCounter() == 1) {
            SciPloreUtils.SendFirstStartEvents(frame);
        }
        if (SplmmPreferences.getStartCounter() >= 10 && SplmmPreferences.getShowBackupNotification() && !SplmmPreferences.getAllowBackup().booleanValue()) {
            new EventSenderThread(EVENT_BACKUP_NOTIFICATION, "");
            String notification = LocalizationSupport.message("backup.notification");
            JLabel label = new JLabel(notification);
            label.setFont(new Font("sansserif", 0, 14));
            Object[] options = new Object[]{LocalizationSupport.message("backup.notification.cancel"), LocalizationSupport.message("backup.notification.ok")};
            int n = JOptionPane.showOptionDialog(frame.getJFrame(), label, "", 0, 1, null, options, options[1]);
            if (n == 1) {
                SplmmPreferences.setShowBackupNotification(false);
                SplmmPreferences.setAllowBackup(true);
                Preferences prefs = new Preferences(frame);
                prefs.selectTab(prefs.getServicePanel());
                prefs.showPrefs();
            }
            if (n == 0 || n == -1) {
                SplmmPreferences.setShowBackupNotification(false);
            }
        }
    }

    private static void SendFirstStartEvents(FreeMindMain frame) {
        String os;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (screenSize != null) {
            String res = screenSize.width + "x" + screenSize.height;
            SplmmPreferences.setScreenResolution(res);
            new EventSenderThread(EVENT_SCREEN_RES, screenSize.width + "x" + screenSize.height);
        }
        if ((os = System.getProperty("os.name")) != null) {
            new EventSenderThread(EVENT_OS, os);
        }
        Locale l = Locale.getDefault();
        new EventSenderThread(EVENT_OS_LANGUAGE, l.getLanguage());
        new EventSenderThread(EVENT_APP_LANGUAGE, frame.getProperty("language"));
    }

    public static void checkIrNotification() {
        if (SplmmPreferences.getAllowUsageMining().booleanValue() && SplmmPreferences.getAllowIRonMM().booleanValue() && SplmmPreferences.getAllowIRonLD().booleanValue()) {
            SplmmPreferences.setIrNotificationCounter(0);
        } else {
            SplmmPreferences.setIrNotificationCounter(SplmmPreferences.getIrNotificationCounter() + 1);
        }
        if (SplmmPreferences.getIrNotificationCounter() >= 20 && SplmmPreferences.getShowIrNotification()) {
            new IrNotfication().show(frame.getJFrame());
            SplmmPreferences.setShowIrNotification(false);
            new EventSenderThread(EVENT_IR_NOTIFICATION, "");
        }
    }

    public static void AutoMonitor(MindMapController controller) {
        List<MindMapNode> autoImportNodes = SciPloreUtils.getAutoImportNodes(controller.getRootNode(), true);
        for (MindMapNode node : autoImportNodes) {
            controller.smartUpdateMontoringDir.performAction(node);
        }
    }

    public static List<MindMapNode> getAutoImportNodes(MindMapNode node, boolean onlyActivatedNodes) {
        ArrayList<MindMapNode> result = new ArrayList<MindMapNode>();
        if (SciPloreUtils.isMonitoringNode(node)) {
            String value = node.getAttribute(SPLMM_DIRMON_AUTO);
            if (onlyActivatedNodes) {
                if (value.equalsIgnoreCase("1")) {
                    result.add(node);
                }
                if (value.equalsIgnoreCase("2") && SplmmPreferences.getAutoMonDir()) {
                    result.add(node);
                }
            } else {
                result.add(node);
            }
        }
        if (node.hasChildren()) {
            List children = node.getChildren();
            for (MindMapNode child : children) {
                result.addAll(SciPloreUtils.getAutoImportNodes(child, onlyActivatedNodes));
            }
        }
        return result;
    }

    public static boolean isMonitoringNode(MindMapNode selected) {
        if (selected.getAttributeTableLength() > 0) {
            List keys = selected.getAttributeKeyList();
            return keys.contains(SPLMM_DIRMON_PATH) && keys.contains(SPLMM_DIRMON_AUTO) && keys.contains(SPLMM_DIRMON_SUBDIRS);
        }
        return false;
    }

    public static int getRandom(int grenzwert) {
        return new Random().nextInt(grenzwert);
    }

    public static void showIncomingNodeView() {
        List<MindMapNode> importNodes = SciPloreUtils.getAutoImportNodes(frame.getController().getMap().getRootNode(), false);
        if (importNodes.size() > 0 && frame.getController().getSplmmToolbar() != null) {
            frame.getController().getSplmmToolbar().onShow();
        }
    }

    public static String getLink(MindMapNode node, Controller controller) {
        if (node.getLink() == null || node.getLink().isEmpty()) {
            return null;
        }
        String linkPath = node.getLink();
        if (!Tools.isAbsolutePath(linkPath)) {
            try {
                if (linkPath.startsWith("\\\\")) {
                    linkPath = linkPath.replace("\\\\", "file://");
                    linkPath = linkPath.replace('\\', '/').replaceAll(" ", "%20");
                    URL url = new URL(linkPath);
                    File file = new File(url.toURI());
                    return file.getPath();
                }
                URL url = new URL(controller.getMap().getURL(), linkPath);
                File file = new File(url.toURI());
                return file.getPath();
            }
            catch (MalformedURLException e) {
                return node.getLink();
            }
            catch (URISyntaxException e) {
                return node.getLink();
            }
            catch (IllegalArgumentException e) {
                return node.getLink();
            }
        }
        return linkPath;
    }

    public static String convertHtmlUnicodeToUtf(String in) {
        BufferedReader reader = new BufferedReader(new StringReader(in));
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        try {
            String out = reader.readLine();
            while (out != null) {
                int index = out.indexOf("&#x");
                while (index >= 0) {
                    int endIndex = out.indexOf(";", index);
                    if (endIndex - index <= 9 && endIndex - index + 3 >= 0) {
                        String codePoint = out.substring(index + 3, endIndex);
                        try {
                            char[] chars = Character.toChars(Integer.parseInt(codePoint, 16));
                            String target = out.substring(index, endIndex + 1);
                            out = out.replace(target, new String(chars));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        index = out.indexOf("&#x");
                        continue;
                    }
                    index = out.indexOf("&#x", index + 1);
                }
                writer.print(out);
                writer.println();
                out = reader.readLine();
            }
        }
        catch (IOException e1) {
            SciPloreUtils.logException(SciPloreUtils.class.getName(), e1, Level.WARNING);
        }
        String s = buffer.toString();
        return s;
    }

    public static String removeInvalidXMLCharacters(String s) {
        int codePoint;
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); i += Character.charCount(codePoint)) {
            codePoint = s.codePointAt(i);
            if (!(codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533) && (codePoint < 65536 || codePoint > 0x10FFFF)) continue;
            out.append(Character.toChars(codePoint));
        }
        return out.toString();
    }
}

