/*
 * Decompiled with CFR 0.152.
 */
package splmm;

import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutlineItem;
import de.intarsys.pdf.pd.PDOutlineNode;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import freemind.controller.Controller;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.attributes.Attribute;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.view.mindmapview.NodeView;
import java.awt.FontMetrics;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import splmm.BibTex;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;

public class BookmarkMindMapNode
extends MindMapNodeModel {
    private String name;

    public BookmarkMindMapNode(File file, String name, Controller c) {
        super(c.getFrame(), c.getMap());
        this.name = name;
        if (c.getProperty("links").equalsIgnoreCase("absolute")) {
            this.setLink(file.getAbsolutePath());
        } else {
            try {
                if (this.getMap().getFile() == null) {
                    JOptionPane.showMessageDialog(this.getFrame().getContentPane(), LocalizationSupport.message("the.mindmap.has.to.be.saved.first.before.you.can.add.relative.links.to.the.mindmap"), "FreeMind", 2);
                }
                URL link = Tools.fileToUrl(file);
                String relative = Tools.toRelativeURL(Tools.fileToUrl(this.getMap().getFile()), link);
                this.setLink(relative);
            }
            catch (MalformedURLException ex) {
                c.errorMessage(c.getModeController().getText("url_error"));
            }
        }
        this.setText(name);
    }

    public BookmarkMindMapNode(File file, String name, BibTex bibtex, Controller c) {
        super(c.getFrame(), c.getMap());
        this.name = name;
        this.createAttributeTableModel();
        Attribute pAttribute = new Attribute(SciPloreUtils.SPLMM_REFKEY_NAME, bibtex.getKey());
        this.getAttributes().addRowNoUndo(pAttribute);
        if (bibtex.getTitle() != null && bibtex.getTitle() != "") {
            pAttribute = new Attribute("splmm_reftitle", bibtex.getTitle());
            this.getAttributes().addRowNoUndo(pAttribute);
        }
        BookmarkMindMapNode.SetOptimalColumnWidth(this, bibtex.getKey(), SciPloreUtils.SPLMM_REFKEY_NAME);
        if (bibtex.getTitle() != null && bibtex.getTitle() != "") {
            BookmarkMindMapNode.SetOptimalColumnWidth(this, bibtex.getTitle(), "splmm_reftitle");
        }
        if (c.getProperty("links").equalsIgnoreCase("absolute")) {
            this.setLink(file.getAbsolutePath());
        } else {
            try {
                URL link = Tools.fileToUrl(file);
                String relative = Tools.toRelativeURL(Tools.fileToUrl(this.getMap().getFile()), link);
                this.setLink(relative);
            }
            catch (MalformedURLException ex) {
                c.errorMessage(c.getModeController().getText("url_error"));
            }
        }
        this.setText(name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public static MindMapNode getBookmarksFromFile(File file, Controller c, List<BibTex> bibTexList) {
        for (BibTex bib : bibTexList) {
            if (!bib.getPath().contains(file.getName())) continue;
            BookmarkMindMapNode node = BookmarkMindMapNode.getBookmarks(file, true, bib, c);
            if (node != null) {
                node.getSPLMMAttributes().setBookmarksUpdated(new Date());
            }
            return node;
        }
        return BookmarkMindMapNode.getBookmarks(file, false, null, c);
    }

    public static BookmarkMindMapNode getBookmarks(File file, boolean ref, BibTex bibtex, Controller c) {
        String path = file.getPath();
        BookmarkMindMapNode node = new BookmarkMindMapNode(file, file.getName(), c);
        FileLocator locator = new FileLocator(path);
        try {
            PDDocument document = PDDocument.createFromLocator((ILocator)locator);
            PDOutline outline = null;
            PDOutline object = document.getOutline();
            if (object instanceof PDOutline) {
                outline = object;
            }
            if (outline != null) {
                if (ref) {
                    node = new BookmarkMindMapNode(file, file.getName(), bibtex, c);
                    BookmarkMindMapNode.SetOptimalColumnWidth(node, bibtex.getKey(), SciPloreUtils.SPLMM_REFKEY_NAME);
                    if (bibtex.getTitle() != null && bibtex.getTitle() != "") {
                        BookmarkMindMapNode.SetOptimalColumnWidth(node, bibtex.getTitle(), "splmm_reftitle");
                    }
                } else {
                    node = new BookmarkMindMapNode(file, file.getName(), c);
                }
                node = BookmarkMindMapNode.helpGetBookmarks(file, (PDOutlineNode)outline, node, ref, bibtex, c);
            }
            if (outline == null) {
                if (ref) {
                    node = new BookmarkMindMapNode(file, file.getName(), bibtex, c);
                    node.getSPLMMAttributes().setBookmarksUpdated(new Date());
                } else {
                    node = new BookmarkMindMapNode(file, file.getName(), c);
                    node.getSPLMMAttributes().setBookmarksUpdated(new Date());
                }
            }
            document.close();
        }
        catch (COSLoadException e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            SciPloreUtils.logException(className, (Exception)((Object)e), Level.WARNING);
        }
        catch (IOException e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            SciPloreUtils.logException(className, e, Level.WARNING);
        }
        catch (COSRuntimeException e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            SciPloreUtils.logException(className, (Exception)((Object)e), Level.WARNING);
        }
        catch (ClassCastException e) {
        }
        catch (Exception e) {
            StackTraceElement[] sTrace = e.getStackTrace();
            String className = sTrace[0].getClassName();
            SciPloreUtils.logException(className, e, Level.WARNING);
        }
        return node;
    }

    private static BookmarkMindMapNode helpGetBookmarks(File file, PDOutlineNode parent, BookmarkMindMapNode node, Boolean ref, BibTex bibtex, Controller c) {
        List children = parent.getChildren();
        for (PDOutlineItem child : children) {
            BookmarkMindMapNode childNode;
            if (ref.booleanValue()) {
                childNode = new BookmarkMindMapNode(file, child.getTitle(), bibtex, c);
                BookmarkMindMapNode.SetOptimalColumnWidth(node, bibtex.getKey(), SciPloreUtils.SPLMM_REFKEY_NAME);
                if (bibtex.getTitle() != null && bibtex.getTitle() != "") {
                    BookmarkMindMapNode.SetOptimalColumnWidth(node, bibtex.getTitle(), "splmm_reftitle");
                }
            } else {
                childNode = new BookmarkMindMapNode(file, child.getTitle(), c);
            }
            childNode.getSPLMMAttributes().setBookmarksUpdated(new Date());
            childNode = BookmarkMindMapNode.helpGetBookmarks(file, (PDOutlineNode)child, childNode, ref, bibtex, c);
            node.insert(childNode, node.getChildCount());
        }
        node.getSPLMMAttributes().setBookmarksUpdated(new Date());
        return node;
    }

    public static List<BibTex> ReadBibtexFile() {
        List<BibTex> bibTexList = new ArrayList<BibTex>();
        if (SplmmPreferences.getJabRefPath() != null && !SplmmPreferences.getJabRefPath().equals("")) {
            File f = new File(SplmmPreferences.getJabRefPath());
            BibTex bib = new BibTex();
            bibTexList = bib.readBibtex(f);
        }
        return bibTexList;
    }

    public static void SetOptimalColumnWidth(MindMapNode node, String value, String key) {
        ModeController controller = node.getMap().getModeController();
        NodeView nodeView = controller.getNodeView(controller.getSelected());
        FontMetrics fontMetrics = nodeView.getFontMetrics(nodeView.getTextFont());
        int optCellWidthLeft = fontMetrics.stringWidth(key + "O");
        int optCellWidthRight = fontMetrics.stringWidth(value + "O");
        if (optCellWidthLeft > 350) {
            optCellWidthLeft = 350;
        }
        if (optCellWidthRight > 350) {
            optCellWidthRight = 350;
        }
        node.getAttributes().setColumnWidth(0, optCellWidthLeft);
        node.getAttributes().setColumnWidth(1, optCellWidthRight);
    }
}

