/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.MindMapNodesSelection;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.CutNodeAction;
import freemind.controller.actions.generated.instance.PasteNodeAction;
import freemind.controller.actions.generated.instance.TransferableContent;
import freemind.controller.actions.generated.instance.TransferableFile;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.HtmlTools;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import splmm.Actions.SmartImportBookmarksAction;
import splmm.BookmarkMindMapNode;
import splmm.Preferences.SplmmPreferences;

public class PasteAction
extends AbstractAction
implements ActorXml {
    private static Logger logger;
    private List newNodes;
    private String text;
    private final MindMapController pMindMapController;
    private static final Pattern HREF_PATTERN;
    static final Pattern nonLinkCharacter;
    private CompoundAction undoAction;
    private PasteNodeAction pasteAction;

    public PasteAction(MindMapController adapter) {
        super(adapter.getText("paste"), new ImageIcon(adapter.getResource("images/editpaste.png")));
        this.pMindMapController = adapter;
        if (logger == null) {
            logger = this.pMindMapController.getFrame().getLogger(this.getClass().getName());
        }
        this.text = adapter.getText("paste");
        this.setEnabled(false);
        this.pMindMapController.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Transferable t = this.pMindMapController.getClipboardContents();
        try {
            void var3_6;
            ArrayList arrayList = new ArrayList();
            if (t.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
                List list = (List)t.getTransferData(MindMapNodesSelection.fileListFlavor);
            } else {
                if (!t.isDataFlavorSupported(MindMapNodesSelection.uriListFlavor)) {
                    this.pMindMapController.paste(this.pMindMapController.getClipboardContents(), this.pMindMapController.getView().getSelected().getModel());
                    return;
                }
                boolean isUriList = true;
                String text = (String)t.getTransferData(MindMapNodesSelection.uriListFlavor);
                StringTokenizer st = new StringTokenizer(text, "\r\n");
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (s.startsWith("#")) continue;
                    try {
                        URI uri = new URI(s);
                        File file = new File(uri);
                    }
                    catch (URISyntaxException exc) {
                        isUriList = false;
                        break;
                    }
                    catch (NullPointerException exc) {
                        isUriList = false;
                        break;
                    }
                    catch (IllegalArgumentException exc) {
                        isUriList = false;
                        break;
                    }
                }
                if (!isUriList) {
                    String texts = (String)t.getTransferData(MindMapNodesSelection.uriListFlavor);
                    this.pMindMapController.paste(this.pMindMapController.getClipboardContents(), this.pMindMapController.getView().getSelected().getModel());
                    return;
                }
                List<File> list = MindMapNodesSelection.textURIListToFileList(text);
            }
            ArrayList nodes = new ArrayList();
            Iterator i$ = var3_6.iterator();
            while (i$.hasNext()) {
                File file = (File)i$.next();
                String dateiendung = file.getPath().substring(file.getPath().lastIndexOf("."));
                Boolean hasPDFendung = dateiendung.substring(1).equalsIgnoreCase("pdf");
                if (hasPDFendung.booleanValue() && SplmmPreferences.getAutoImport().booleanValue()) {
                    SmartImportBookmarksAction smartImportBookmarksAction = new SmartImportBookmarksAction(this.pMindMapController);
                    smartImportBookmarksAction.importBookmarks(file, this.pMindMapController.getSelected(), false);
                    continue;
                }
                BookmarkMindMapNode node = new BookmarkMindMapNode(file, file.getName(), this.pMindMapController.getController());
                if (node == null) continue;
                this.pMindMapController.paste(node, this.pMindMapController.getView().getSelected().getModel());
            }
            return;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void act(XmlAction action) {
        PasteNodeAction pasteAction = (PasteNodeAction)action;
        this._paste(this.getTransferable(pasteAction.getTransferableContent()), this.pMindMapController.getNodeFromID(pasteAction.getNode()), pasteAction.getAsSibling(), pasteAction.getIsLeft());
    }

    @Override
    public Class getDoActionClass() {
        return PasteNodeAction.class;
    }

    public PasteNodeAction getPasteNodeAction(Transferable t, NodeCoordinate coord) {
        PasteNodeAction pasteAction = new PasteNodeAction();
        pasteAction.setNode(this.pMindMapController.getNodeID(coord.target));
        pasteAction.setTransferableContent(this.getTransferableContent(t));
        pasteAction.setAsSibling(coord.asSibling);
        pasteAction.setIsLeft(coord.isLeft);
        return pasteAction;
    }

    public void paste(MindMapNode node, MindMapNode parent) {
        if (node != null) {
            this.insertNodeInto(node, parent);
            this.pMindMapController.nodeStructureChanged(parent);
        }
    }

    public boolean paste(Transferable t, MindMapNode target, boolean asSibling, boolean isLeft) {
        this.pasteAction = this.getPasteNodeAction(t, new NodeCoordinate(target, asSibling, isLeft));
        this.undoAction = new CompoundAction();
        this.pMindMapController.getActionFactory().startTransaction(this.text);
        boolean result = this.pMindMapController.getActionFactory().executeAction(new ActionPair((XmlAction)this.pasteAction, (XmlAction)this.undoAction));
        this.pMindMapController.getActionFactory().endTransaction(this.text);
        return result;
    }

    private void addMindMapNodesFlavor() {
        if (this.pasteAction == null) {
            return;
        }
        TransferableContent transferableContent = this.pasteAction.getTransferableContent();
        if (transferableContent.getTransferable() == null) {
            LinkedList<NodeAdapter> nodes = new LinkedList<NodeAdapter>();
            ListIterator listIterator = this.undoAction.getListChoiceList().listIterator(this.undoAction.sizeChoiceList());
            while (listIterator.hasPrevious()) {
                CutNodeAction cutAction = (CutNodeAction)listIterator.previous();
                NodeAdapter node = this.pMindMapController.getNodeFromID(cutAction.getNode());
                nodes.add(node);
            }
            try {
                String transferable = this.pMindMapController.createForNodesFlavor(nodes, true);
                transferableContent.setTransferable(transferable);
                transferableContent.setTransferableAsDrop(null);
                transferableContent.setTransferableAsHtml(null);
                transferableContent.setTransferableAsPlainText(null);
                transferableContent.setTransferableAsRTF(null);
            }
            catch (UnsupportedFlavorException e) {
                Resources.getInstance().logException(e);
            }
            catch (IOException e) {
                Resources.getInstance().logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _paste(Transferable t, MindMapNode target, boolean asSibling, boolean isLeft) {
        if (t == null) {
            return;
        }
        try {
            if (this.newNodes == null) {
                this.newNodes = new LinkedList();
            }
            this.newNodes.clear();
            DataFlavorHandler[] dataFlavorHandlerList = this.getFlavorHandlers();
            for (int i = 0; i < dataFlavorHandlerList.length; ++i) {
                DataFlavorHandler handler = dataFlavorHandlerList[i];
                DataFlavor flavor = handler.getDataFlavor();
                if (!t.isDataFlavorSupported(flavor)) continue;
                try {
                    handler.paste(t.getTransferData(flavor), target, asSibling, isLeft, t);
                    break;
                }
                catch (UnsupportedFlavorException e) {
                    // empty catch block
                }
            }
            ListIterator e = this.newNodes.listIterator();
            while (e.hasNext()) {
                MindMapNodeModel child = (MindMapNodeModel)e.next();
                this.pMindMapController.getAttributeController().performRegistrySubtreeAttributes(child);
            }
            this.addMindMapNodesFlavor();
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
        finally {
            this.undoAction = null;
            this.pasteAction = null;
            this.pMindMapController.getFrame().setWaitingCursor(false);
        }
    }

    private DataFlavorHandler[] getFlavorHandlers() {
        DataFlavorHandler[] dataFlavorHandlerList = new DataFlavorHandler[]{new FileListFlavorHandler(), new MindMapNodesFlavorHandler(), new DirectHtmlFlavorHandler(), new StringFlavorHandler()};
        return dataFlavorHandlerList;
    }

    public MindMapNodeModel pasteXMLWithoutRedisplay(String pasted, MindMapNode target, boolean asSibling, boolean changeSide, boolean isLeft, HashMap pIDToTarget) throws XMLParseException {
        logger.fine("Pasting " + pasted + " to " + target);
        try {
            MindMapNodeModel node = (MindMapNodeModel)this.pMindMapController.createNodeTreeFromXml(new StringReader(pasted), pIDToTarget);
            this.insertNodeInto(node, target, asSibling, isLeft, changeSide);
            this.pMindMapController.invokeHooksRecursively(node, this.pMindMapController.getModel());
            return node;
        }
        catch (IOException ee) {
            Resources.getInstance().logException(ee);
            return null;
        }
    }

    private void insertNodeInto(MindMapNodeModel node, MindMapNode target, boolean asSibling, boolean isLeft, boolean changeSide) {
        MindMapNode parent = asSibling ? target.getParentNode() : target;
        if (changeSide) {
            node.setParent(parent);
            node.setLeft(isLeft);
        }
        if (asSibling) {
            this.insertNodeInto(node, parent, parent.getChildPosition(target));
        } else {
            this.insertNodeInto(node, target);
        }
    }

    private MindMapNode pasteStringWithoutRedisplay(Transferable t, MindMapNode parent, boolean asSibling, boolean isLeft) throws UnsupportedFlavorException, IOException {
        String textFromClipboard = (String)t.getTransferData(DataFlavor.stringFlavor);
        Pattern mailPattern = Pattern.compile("([^@ <>\\*']+@[^@ <>\\*']+)");
        String[] textLines = textFromClipboard.split("\n");
        if (textLines.length > 1) {
            this.pMindMapController.getFrame().setWaitingCursor(true);
        }
        MindMapNode realParent = null;
        if (asSibling) {
            realParent = parent;
            parent = new MindMapNodeModel(this.pMindMapController.getFrame(), this.pMindMapController.getMap());
        }
        ArrayList<MindMapNode> parentNodes = new ArrayList<MindMapNode>();
        ArrayList<Integer> parentNodesDepths = new ArrayList<Integer>();
        parentNodes.add(parent);
        parentNodesDepths.add(new Integer(-1));
        String[] linkPrefixes = new String[]{"http://", "ftp://", "https://"};
        MindMapNode pastedNode = null;
        block0: for (int i = 0; i < textLines.length; ++i) {
            int j;
            Matcher mailMatcher;
            int depth;
            String text = textLines[i];
            if ((text = text.replaceAll("\t", "        ")).matches(" *")) continue;
            for (depth = 0; depth < text.length() && text.charAt(depth) == ' '; ++depth) {
            }
            String visibleText = text.trim();
            if (visibleText.matches("^http://(www\\.)?[^ ]*$")) {
                visibleText = visibleText.replaceAll("^http://(www\\.)?", "").replaceAll("(/|\\.[^\\./\\?]*)$", "").replaceAll("((\\.[^\\./]*\\?)|\\?)[^/]*$", " ? ...").replaceAll("_|%20", " ");
                String[] textParts = visibleText.split("/");
                visibleText = "";
                for (int textPartIdx = 0; textPartIdx < textParts.length; ++textPartIdx) {
                    if (textPartIdx > 0) {
                        visibleText = visibleText + " > ";
                    }
                    visibleText = visibleText + (textPartIdx == 0 ? textParts[textPartIdx] : Tools.firstLetterCapitalized(textParts[textPartIdx].replaceAll("^~*", "")));
                }
            }
            MindMapNode node = this.pMindMapController.newNode(visibleText, parent.getMap());
            if (textLines.length == 1) {
                pastedNode = node;
            }
            if ((mailMatcher = mailPattern.matcher(visibleText)).find()) {
                node.setLink("mailto:" + mailMatcher.group());
            }
            for (j = 0; j < linkPrefixes.length; ++j) {
                int linkEnd;
                int linkStart = text.indexOf(linkPrefixes[j]);
                if (linkStart == -1) continue;
                for (linkEnd = linkStart; linkEnd < text.length() && !nonLinkCharacter.matcher(text.substring(linkEnd, linkEnd + 1)).matches(); ++linkEnd) {
                }
                node.setLink(text.substring(linkStart, linkEnd));
            }
            for (j = parentNodes.size() - 1; j >= 0; --j) {
                if (depth <= (Integer)parentNodesDepths.get(j)) continue;
                for (int k = j + 1; k < parentNodes.size(); ++k) {
                    MindMapNode n = (MindMapNode)parentNodes.get(k);
                    if (n.getParentNode() == parent) {
                        this.addUndoAction(n);
                    }
                    parentNodes.remove(k);
                    parentNodesDepths.remove(k);
                }
                MindMapNode target = (MindMapNode)parentNodes.get(j);
                node.setLeft(isLeft);
                this.insertNodeInto(node, target);
                parentNodes.add(node);
                parentNodesDepths.add(new Integer(depth));
                continue block0;
            }
        }
        for (int k = 0; k < parentNodes.size(); ++k) {
            MindMapNode n = (MindMapNode)parentNodes.get(k);
            if (n.getParentNode() != parent) continue;
            this.addUndoAction(n);
        }
        return pastedNode;
    }

    private void insertNodeInto(MindMapNodeModel node, MindMapNode parent, int i) {
        this.pMindMapController.insertNodeInto(node, parent, i);
    }

    private void insertNodeInto(MindMapNode node, MindMapNode parent) {
        this.pMindMapController.insertNodeInto(node, parent);
    }

    private TransferableContent getTransferableContent(Transferable t) {
        try {
            String textFromClipboard;
            TransferableContent trans = new TransferableContent();
            if (t.isDataFlavorSupported(MindMapNodesSelection.mindMapNodesFlavor)) {
                textFromClipboard = (String)t.getTransferData(MindMapNodesSelection.mindMapNodesFlavor);
                trans.setTransferable(textFromClipboard);
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                textFromClipboard = (String)t.getTransferData(DataFlavor.stringFlavor);
                trans.setTransferableAsPlainText(textFromClipboard);
            }
            if (t.isDataFlavorSupported(MindMapNodesSelection.rtfFlavor)) {
                // empty if block
            }
            if (t.isDataFlavorSupported(MindMapNodesSelection.htmlFlavor)) {
                textFromClipboard = (String)t.getTransferData(MindMapNodesSelection.htmlFlavor);
                trans.setTransferableAsHtml(textFromClipboard);
            }
            if (t.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor)) {
                List fileList = (List)t.getTransferData(MindMapNodesSelection.fileListFlavor);
                for (File fileName : fileList) {
                    TransferableFile transferableFile = new TransferableFile();
                    transferableFile.setFileName(fileName.getAbsolutePath());
                    trans.addTransferableFile(transferableFile);
                }
            }
            return trans;
        }
        catch (UnsupportedFlavorException e) {
            Resources.getInstance().logException(e);
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
        return null;
    }

    private Transferable getTransferable(TransferableContent trans) {
        Vector<File> fileList = new Vector<File>();
        for (TransferableFile tFile : trans.getListTransferableFileList()) {
            fileList.add(new File(tFile.getFileName()));
        }
        MindMapNodesSelection copy = new MindMapNodesSelection(trans.getTransferable(), trans.getTransferableAsPlainText(), trans.getTransferableAsRTF(), trans.getTransferableAsHtml(), trans.getTransferableAsDrop(), fileList, null);
        return copy;
    }

    private void addUndoAction(MindMapNode node) {
        if (this.undoAction != null) {
            CutNodeAction cutNodeAction = this.pMindMapController.cut.getCutNodeAction(node);
            this.undoAction.addAtChoice(0, (Object)cutNodeAction);
        }
    }

    static {
        HREF_PATTERN = Pattern.compile("<html>\\s*<body>\\s*<a\\s+href=\"([^>]+)\">(.*)</a>\\s*</body>\\s*</html>");
        nonLinkCharacter = Pattern.compile("[ \n()'\",;]");
    }

    private class StringFlavorHandler
    implements DataFlavorHandler {
        private StringFlavorHandler() {
        }

        @Override
        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) throws UnsupportedFlavorException, IOException {
            PasteAction.this.pasteStringWithoutRedisplay(t, target, asSibling, isLeft);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return DataFlavor.stringFlavor;
        }
    }

    private class HtmlFlavorHandler
    implements DataFlavorHandler {
        private HtmlFlavorHandler() {
        }

        @Override
        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) throws UnsupportedFlavorException, IOException {
            String textFromClipboard = (String)TransferData;
            MindMapNode pastedNode = PasteAction.this.pasteStringWithoutRedisplay(t, target, asSibling, isLeft);
            textFromClipboard = textFromClipboard.replaceAll("<!--.*?-->", "");
            String[] links = textFromClipboard.split("<[aA][^>]*[hH][rR][eE][fF]=\"");
            MindMapNode linkParentNode = null;
            URL referenceURL = null;
            boolean baseUrlCanceled = false;
            for (int i = 1; i < links.length; ++i) {
                String link = links[i].substring(0, links[i].indexOf("\""));
                String textWithHtml = links[i].replaceAll("^[^>]*>", "").replaceAll("</[aA]>[\\s\\S]*", "");
                String text = HtmlTools.toXMLUnescapedText(textWithHtml.replaceAll("\\n", "").replaceAll("<[^>]*>", "").trim());
                if (text.equals("")) {
                    text = link;
                }
                URL linkURL = null;
                try {
                    linkURL = new URL(link);
                }
                catch (MalformedURLException ex) {
                    try {
                        if (referenceURL == null && !baseUrlCanceled) {
                            String referenceURLString = JOptionPane.showInputDialog(PasteAction.this.pMindMapController.getView().getSelected(), (Object)PasteAction.this.pMindMapController.getText("enter_base_url"));
                            if (referenceURLString == null) {
                                baseUrlCanceled = true;
                            } else {
                                referenceURL = new URL(referenceURLString);
                            }
                        }
                        linkURL = new URL(referenceURL, link);
                    }
                    catch (MalformedURLException ex2) {
                        // empty catch block
                    }
                }
                if (linkURL == null) continue;
                if (links.length == 2 & pastedNode != null) {
                    ((MindMapNodeModel)pastedNode).setLink(linkURL.toString());
                    break;
                }
                if (linkParentNode == null) {
                    linkParentNode = PasteAction.this.pMindMapController.newNode("Links", target.getMap());
                    linkParentNode.setLeft(target.isNewChildLeft());
                    PasteAction.this.insertNodeInto(linkParentNode, target);
                    ((NodeAdapter)linkParentNode).setBold(true);
                }
                MindMapNode linkNode = PasteAction.this.pMindMapController.newNode(text, target.getMap());
                linkNode.setLink(linkURL.toString());
                PasteAction.this.insertNodeInto(linkNode, linkParentNode);
            }
        }

        @Override
        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.htmlFlavor;
        }
    }

    private class DirectHtmlFlavorHandler
    implements DataFlavorHandler {
        private DirectHtmlFlavorHandler() {
        }

        @Override
        public void paste(Object transferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) throws UnsupportedFlavorException, IOException {
            String body;
            String textFromClipboard = (String)transferData;
            if (textFromClipboard.charAt(0) == '\ufffd') {
                throw new UnsupportedFlavorException(MindMapNodesSelection.htmlFlavor);
            }
            PasteAction.this.pMindMapController.getFrame().setWaitingCursor(true);
            textFromClipboard = textFromClipboard.replaceFirst("(?i)(?s)<head>.*</head>", "").replaceFirst("(?i)(?s)^.*<html[^>]*>", "<html>").replaceFirst("(?i)(?s)<body [^>]*>", "<body>").replaceAll("(?i)(?s)<script.*?>.*?</script>", "").replaceAll("(?i)(?s)</?tbody.*?>", "").replaceAll("(?i)(?s)<!--.*?-->", "").replaceAll("(?i)(?s)</?o[^>]*>", "");
            if (Tools.safeEquals(PasteAction.this.pMindMapController.getFrame().getProperty("cut_out_pictures_when_pasting_html"), "true")) {
                textFromClipboard = textFromClipboard.replaceAll("(?i)(?s)<img[^>]*>", "");
            }
            textFromClipboard = HtmlTools.unescapeHTMLUnicodeEntity(textFromClipboard);
            MindMapNode node = PasteAction.this.pMindMapController.newNode(textFromClipboard, PasteAction.this.pMindMapController.getMap());
            Matcher m = HREF_PATTERN.matcher(textFromClipboard);
            if (m.matches() && !(body = m.group(2)).matches(".*<\\s*a.*")) {
                String href = m.group(1);
                node.setLink(href);
            }
            PasteAction.this.insertNodeInto(node, target);
            PasteAction.this.addUndoAction(node);
            PasteAction.this.pMindMapController.getFrame().setWaitingCursor(false);
        }

        @Override
        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.htmlFlavor;
        }
    }

    private class MindMapNodesFlavorHandler
    implements DataFlavorHandler {
        private MindMapNodesFlavorHandler() {
        }

        @Override
        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) {
            HashMap IDToTarget = new HashMap();
            String textFromClipboard = (String)TransferData;
            if (textFromClipboard != null) {
                String[] textLines = textFromClipboard.split("<nodeseparator>");
                if (textLines.length > 1) {
                    PasteAction.this.pMindMapController.getFrame().setWaitingCursor(true);
                }
                for (int i = 0; i < textLines.length; ++i) {
                    MindMapNodeModel newModel = PasteAction.this.pasteXMLWithoutRedisplay(textLines[i], target, asSibling, true, isLeft, IDToTarget);
                    ListIterator childrenUnfolded = newModel.childrenUnfolded();
                    while (childrenUnfolded.hasNext()) {
                        PasteAction.this.pMindMapController.fireRecursiveNodeCreateEvent((MindMapNode)childrenUnfolded.next());
                    }
                    newModel.setLeft(isLeft);
                    PasteAction.this.addUndoAction(newModel);
                }
            }
        }

        @Override
        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.mindMapNodesFlavor;
        }
    }

    private class FileListFlavorHandler
    implements DataFlavorHandler {
        private FileListFlavorHandler() {
        }

        @Override
        public void paste(Object TransferData, MindMapNode target, boolean asSibling, boolean isLeft, Transferable t) {
            List fileList = (List)TransferData;
            ListIterator it = fileList.listIterator();
            while (it.hasNext()) {
                File file = (File)it.next();
                MindMapNode node = PasteAction.this.pMindMapController.newNode(file.getName(), target.getMap());
                node.setLeft(isLeft);
                node.setLink(file.getAbsolutePath());
                PasteAction.this.insertNodeInto((MindMapNodeModel)node, target, asSibling, isLeft, false);
                PasteAction.this.addUndoAction(node);
            }
        }

        @Override
        public DataFlavor getDataFlavor() {
            return MindMapNodesSelection.fileListFlavor;
        }
    }

    private static interface DataFlavorHandler {
        public void paste(Object var1, MindMapNode var2, boolean var3, boolean var4, Transferable var5) throws UnsupportedFlavorException, IOException;

        public DataFlavor getDataFlavor();
    }

    public static class NodeCoordinate {
        public MindMapNode target;
        public boolean asSibling;
        public boolean isLeft;

        public NodeCoordinate(MindMapNode target, boolean asSibling, boolean isLeft) {
            this.target = target;
            this.asSibling = asSibling;
            this.isLeft = isLeft;
        }

        public MindMapNode getNode() {
            if (this.asSibling) {
                MindMapNode parentNode = this.target.getParentNode();
                return (MindMapNode)parentNode.getChildAt(parentNode.getChildPosition(this.target) - 1);
            }
            logger.finest("getChildCount = " + this.target.getChildCount() + ", target = " + this.target);
            return (MindMapNode)this.target.getChildAt(this.target.getChildCount() - 1);
        }

        public NodeCoordinate(MindMapNode node, boolean isLeft) {
            this.isLeft = isLeft;
            MindMapNode parentNode = node.getParentNode();
            int childPosition = parentNode.getChildPosition(node);
            if (childPosition == parentNode.getChildCount() - 1) {
                this.target = parentNode;
                this.asSibling = false;
            } else {
                this.target = (MindMapNode)parentNode.getChildAt(childPosition + 1);
                this.asSibling = true;
            }
        }
    }
}

