/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.main.Resources;
import freemind.main.XHTMLWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class HtmlTools {
    private static Logger logger;
    private static HtmlTools sInstance;
    private static final Pattern HTML_PATTERN;
    private static final Pattern FIND_TAGS_PATTERN;
    private static final Pattern SLASHED_TAGS_PATTERN;
    private static final Pattern TAGS_PATTERN;

    private HtmlTools() {
        logger = Resources.getInstance().getLogger(HtmlTools.class.getName());
    }

    public static HtmlTools getInstance() {
        return sInstance;
    }

    public String toXhtml(String htmlText) {
        if (!HtmlTools.isHtmlNode(htmlText)) {
            return null;
        }
        logger.fine("Enter toXhtml with " + htmlText);
        StringReader reader = new StringReader(htmlText);
        StringWriter writer = new StringWriter();
        try {
            XHTMLWriter.html2xhtml(reader, writer);
            String resultXml = writer.toString();
            if (!this.isWellformedXml(resultXml)) {
                return HtmlTools.toXMLEscapedText(htmlText);
            }
            logger.fine("Leave toXhtml with " + resultXml);
            return resultXml;
        }
        catch (IOException e) {
            Resources.getInstance().logException(e);
        }
        catch (BadLocationException e) {
            Resources.getInstance().logException(e);
        }
        htmlText = htmlText.replaceAll("<", "&gt;");
        htmlText = htmlText.replaceAll(">", "&lt;");
        logger.fine("Leave toXhtml with fallback " + htmlText);
        return htmlText;
    }

    public String toHtml(String xhtmlText) {
        return SLASHED_TAGS_PATTERN.matcher(xhtmlText).replaceAll("<$1>");
    }

    public String getReplaceResult(Pattern pattern, String replacement, String text) {
        ArrayList<IndexPair> splittedStringList = new ArrayList<IndexPair>();
        String stringWithoutTags = null;
        StringBuffer sb = new StringBuffer();
        Matcher matcher = FIND_TAGS_PATTERN.matcher(text);
        int lastMatchEnd = 0;
        while (matcher.find()) {
            IndexPair indexPair;
            String textWithoutTag = matcher.group(1);
            int replStart = sb.length();
            matcher.appendReplacement(sb, "$1");
            if (textWithoutTag.length() > 0) {
                indexPair = new IndexPair(lastMatchEnd, matcher.end(1), replStart, sb.length(), false);
                lastMatchEnd = matcher.end(1);
                splittedStringList.add(indexPair);
            }
            replStart = sb.length();
            indexPair = new IndexPair(lastMatchEnd, matcher.end(2), replStart, sb.length(), true);
            lastMatchEnd = matcher.end(2);
            splittedStringList.add(indexPair);
        }
        int replStart = sb.length();
        matcher.appendTail(sb);
        if (sb.length() != replStart) {
            IndexPair indexPair = new IndexPair(lastMatchEnd, text.length(), replStart, sb.length(), false);
            splittedStringList.add(indexPair);
        }
        stringWithoutTags = sb.toString();
        StringBuffer sbResult = new StringBuffer();
        for (IndexPair pair : splittedStringList) {
            if (pair.mIsTag) {
                sbResult.append(text, pair.originalStart, pair.originalEnd);
                continue;
            }
            Matcher matcher2 = pattern.matcher(text.substring(pair.originalStart, pair.originalEnd));
            int mStart = 0;
            int mEnd = 0;
            int mEndOld = 0;
            int mStartOld = 0;
            while (matcher2.find()) {
                mStart = matcher2.start();
                mEnd = matcher2.end();
                sbResult.append(text, pair.originalStart + mEndOld, pair.originalStart + mStart);
                sbResult.append(replacement);
                mEndOld = mEnd;
                mStartOld = mStart;
            }
            sbResult.append(text, pair.originalStart + mEndOld, pair.originalEnd);
        }
        return sbResult.toString();
    }

    private void append(StringBuffer pResult, String pInput, ArrayList pListOfIndices, int pReducedStart, int pReducedEnd) {
        if (pReducedStart == pReducedEnd) {
            int minj = this.getMinimalOriginalPosition(pReducedStart, pListOfIndices);
            int maxj = this.getMaximalOriginalPosition(pReducedStart, pListOfIndices);
            pResult.append(pInput.substring(minj, maxj));
            return;
        }
        for (int i = pReducedStart; i < pReducedEnd; ++i) {
            int minj = this.getMinimalOriginalPosition(i, pListOfIndices);
            int maxj = this.getMaximalOriginalPosition(i, pListOfIndices);
            pResult.append(pInput.substring(minj, maxj));
        }
    }

    public int getMinimalOriginalPosition(int pI, ArrayList pListOfIndices) {
        for (IndexPair pair : pListOfIndices) {
            if (pI < pair.replacedStart || pI > pair.replacedEnd) continue;
            return pair.originalStart + pI - pair.replacedStart;
        }
        throw new IllegalArgumentException("Position " + pI + " not found.");
    }

    public int getMaximalOriginalPosition(int pI, ArrayList pListOfIndices) {
        for (int i = pListOfIndices.size() - 1; i >= 0; --i) {
            IndexPair pair = (IndexPair)pListOfIndices.get(i);
            if (pI < pair.replacedStart) continue;
            if (!pair.mIsTag) {
                return pair.originalStart + pI - pair.replacedStart;
            }
            return pair.originalEnd;
        }
        throw new IllegalArgumentException("Position " + pI + " not found.");
    }

    public static boolean isHtmlNode(String text) {
        char ch;
        for (int i = 0; i < text.length() && (ch = text.charAt(i)) != '<'; ++i) {
            if (Character.isWhitespace(ch) && i != text.length()) continue;
            return false;
        }
        return HTML_PATTERN.matcher(text.toLowerCase(Locale.ENGLISH)).matches();
    }

    public static String unicodeToHTMLUnicodeEntity(String text) {
        StringBuffer result = new StringBuffer((int)((double)text.length() * 1.2));
        for (int i = 0; i < text.length(); ++i) {
            char myChar = text.charAt(i);
            char intValue = text.charAt(i);
            if (intValue < ' ' || intValue > '~') {
                result.append("&#x").append(Integer.toString(intValue, 16)).append(';');
                continue;
            }
            result.append(myChar);
        }
        return result.toString();
    }

    public static String unescapeHTMLUnicodeEntity(String text) {
        text = HtmlTools.replaceIllegalXmlCharacters(text);
        StringBuffer result = new StringBuffer(text.length());
        StringBuffer entity = new StringBuffer();
        boolean readingEntity = false;
        for (int i = 0; i < text.length(); ++i) {
            char myChar = text.charAt(i);
            if (readingEntity) {
                if (myChar == ';') {
                    block10: {
                        if (entity.charAt(0) == '#') {
                            try {
                                if (entity.charAt(1) == 'x') {
                                    result.append((char)Integer.parseInt(entity.substring(2), 16));
                                    break block10;
                                }
                                result.append((char)Integer.parseInt(entity.substring(1), 10));
                            }
                            catch (NumberFormatException e) {
                                result.append('&').append(entity).append(';');
                            }
                        } else {
                            result.append('&').append(entity).append(';');
                        }
                    }
                    entity.setLength(0);
                    readingEntity = false;
                    continue;
                }
                entity.append(myChar);
                continue;
            }
            if (myChar == '&') {
                readingEntity = true;
                continue;
            }
            result.append(myChar);
        }
        if (entity.length() > 0) {
            result.append('&').append(entity);
        }
        return result.toString();
    }

    public static String removeHtmlTagsFromString(String text) {
        if (HtmlTools.isHtmlNode(text)) {
            return HtmlTools.removeAllTagsFromString(text);
        }
        return text;
    }

    public static String removeAllTagsFromString(String text) {
        return TAGS_PATTERN.matcher(text).replaceAll("");
    }

    public static String htmlToPlain(String text) {
        return HtmlTools.htmlToPlain(text, true);
    }

    public static String htmlToPlain(String text, boolean strictHTMLOnly) {
        if (strictHTMLOnly && !HtmlTools.isHtmlNode(text)) {
            return text;
        }
        String intermediate = text.replaceAll("(?ims)[\n\t]", "").replaceAll("(?ims) +", " ").replaceAll("(?ims)<br.*?>", "\n").replaceAll("(?ims)<p.*?>", "\n\n").replaceAll("(?ims)<div.*?>", "\n").replaceAll("(?ims)<tr.*?>", "\n").replaceAll("(?ims)<dt.*?>", "\n").replaceAll("(?ims)<dd.*?>", "\n   ").replaceAll("(?ims)<td.*?>", " ").replaceAll("(?ims)<[uo]l.*?>", "\n").replaceAll("(?ims)<li.*?>", "\n   * ").replaceAll("(?ims) *</[^>]*>", "").replaceAll("(?ims)<[^/][^>]*> *", "").replaceAll("^\n+", "").trim();
        intermediate = HtmlTools.unescapeHTMLUnicodeEntity(intermediate);
        intermediate = intermediate.replaceAll("(?ims)&lt;", "<").replaceAll("(?ims)&gt;", ">").replaceAll("(?ims)&quot;", "\"").replaceAll("(?ims)&nbsp;", " ");
        return intermediate.replaceAll("(?ims)&amp;", "&");
    }

    public static String plainToHTML(String text) {
        String textTabsExpanded = text.replaceAll("\t", "         ");
        StringBuffer result = new StringBuffer(textTabsExpanded.length());
        int lengthMinus1 = textTabsExpanded.length() - 1;
        result.append("<html><body><p>");
        block7: for (int i = 0; i < textTabsExpanded.length(); ++i) {
            char myChar = textTabsExpanded.charAt(i);
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    continue block7;
                }
                case '<': {
                    result.append("&lt;");
                    continue block7;
                }
                case '>': {
                    result.append("&gt;");
                    continue block7;
                }
                case ' ': {
                    if (i > 0 && i < lengthMinus1 && textTabsExpanded.charAt(i - 1) > ' ' && textTabsExpanded.charAt(i + 1) > ' ') {
                        result.append(' ');
                        continue block7;
                    }
                    result.append("&nbsp;");
                    continue block7;
                }
                case '\n': {
                    result.append("<br>");
                    continue block7;
                }
                default: {
                    result.append(myChar);
                }
            }
        }
        return result.toString();
    }

    public static String toXMLUnescapedText(String text) {
        return text.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&quot;", "\"").replaceAll("&amp;", "&");
    }

    public static String toXMLEscapedTextExpandingWhitespace(String text) {
        text = text.replaceAll("\t", "         ");
        int len = text.length();
        StringBuffer result = new StringBuffer(len);
        block6: for (int i = 0; i < len; ++i) {
            char myChar = text.charAt(i);
            switch (myChar) {
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case ' ': {
                    if (i > 0 && i < len - 1 && text.charAt(i - 1) > ' ' && text.charAt(i + 1) > ' ') {
                        result.append(' ');
                        continue block6;
                    }
                    result.append("&nbsp;");
                    continue block6;
                }
                default: {
                    result.append(myChar);
                }
            }
        }
        return result.toString();
    }

    public static String toXMLEscapedText(String text) {
        return text.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }

    public boolean isWellformedXml(String xml) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.newSAXParser().parse(new InputSource(new StringReader(xml)), new DefaultHandler());
            return true;
        }
        catch (SAXParseException e) {
            logger.log(Level.SEVERE, "XmlParseError on line " + e.getLineNumber() + " of " + xml, e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "XmlParseError", e);
        }
        return false;
    }

    public static String replaceIllegalXmlCharacters(String fileContents) {
        fileContents = fileContents.replaceAll("&#x0*1?[0-9A-Fa-f];", "");
        fileContents = fileContents.replaceAll("&#0*[1-2]?[0-9];", "");
        fileContents = fileContents.replaceAll("&#0*3[0-1];", "");
        return fileContents;
    }

    public static String extractHtmlBody(String output) {
        int start;
        if (output.startsWith("<html")) {
            output = output.substring(6);
        }
        start = (start = output.indexOf("<body")) == -1 ? output.indexOf(62) + 1 : output.indexOf(62, start + 5) + 1;
        int end = output.indexOf("</body>");
        if (end == -1) {
            end = output.indexOf("</html>");
        }
        if (end == -1) {
            end = output.length();
        }
        output = output.substring(start, end);
        return output;
    }

    static {
        sInstance = new HtmlTools();
        HTML_PATTERN = Pattern.compile("(?s)^\\s*<\\s*html.*?>.*");
        FIND_TAGS_PATTERN = Pattern.compile("([^<]*)(<[^>]+>)");
        SLASHED_TAGS_PATTERN = Pattern.compile("<((br|area|base|basefont|bgsound|button|col|colgroup|embed|hr|img|input|isindex|keygen|link|meta|object|plaintext|spacer|wbr)(\\s[^>]*)?)/>");
        TAGS_PATTERN = Pattern.compile("(?s)<[^><]*>");
    }

    public static class IndexPair {
        public int originalStart;
        public int originalEnd;
        public int replacedStart;
        public int replacedEnd;
        public boolean mIsTag;
        public boolean mIsAlreadyAppended = false;

        public IndexPair(int pOriginalStart, int pOriginalEnd, int pReplacedStart, int pReplacedEnd, boolean pIsTag) {
            this.originalStart = pOriginalStart;
            this.originalEnd = pOriginalEnd;
            this.replacedStart = pReplacedStart;
            this.replacedEnd = pReplacedEnd;
            this.mIsTag = pIsTag;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[IndexPair:");
            buffer.append(" originalStart: ");
            buffer.append(this.originalStart);
            buffer.append(" originalEnd: ");
            buffer.append(this.originalEnd);
            buffer.append(" replacedStart: ");
            buffer.append(this.replacedStart);
            buffer.append(" replacedEnd: ");
            buffer.append(this.replacedEnd);
            buffer.append(" is a tag: ");
            buffer.append(this.mIsTag);
            buffer.append("]");
            return buffer.toString();
        }
    }
}

