/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.time;

import accessories.plugins.time.JTripleCalendar;
import accessories.plugins.time.TimeManagementOrganizer;
import freemind.controller.MapModuleManager;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.common.plugins.ReminderHookBase;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.hooks.MindMapHookAdapter;
import freemind.view.MapModule;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TimeManagement
extends MindMapHookAdapter
implements PropertyChangeListener,
ActionListener,
MapModuleManager.MapModuleChangeObserver {
    public static final String REMINDER_HOOK_NAME = "plugins/TimeManagementReminder.xml";
    private static Date lastDate = null;
    private JTripleCalendar calendar;
    private JDialog dialog;
    private JPanel timePanel;
    private JTextField hourField;
    private JTextField minuteField;
    private MindMapController mController;
    private static TimeManagement sCurrentlyOpenTimeManagement = null;

    @Override
    public void startupMapHook() {
        super.startupMapHook();
        if (sCurrentlyOpenTimeManagement != null) {
            TimeManagement.sCurrentlyOpenTimeManagement.dialog.getContentPane().setVisible(true);
            return;
        }
        sCurrentlyOpenTimeManagement = this;
        this.mController = this.getMindMapController();
        this.mController.getController().getMapModuleManager().addListener(this);
        this.dialog = new JDialog((Frame)this.mController.getFrame().getJFrame(), false);
        this.dialog.setTitle(this.getResourceString("plugins/TimeManagement.xml_WindowTitle"));
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                TimeManagement.this.disposeDialog();
            }
        });
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeManagement.this.disposeDialog();
            }
        };
        Tools.addEscapeActionToDialog(this.dialog, action);
        this.calendar = new JTripleCalendar();
        Container contentPane = this.dialog.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gb1 = new GridBagConstraints();
        gb1.gridx = 0;
        gb1.gridwidth = 4;
        gb1.fill = 1;
        gb1.gridy = 0;
        this.calendar.getDayChooser().addPropertyChangeListener(this);
        contentPane.add((Component)this.calendar, gb1);
        GridBagConstraints gb2 = new GridBagConstraints();
        gb2.gridx = 0;
        gb2.gridy = 1;
        gb2.gridwidth = 4;
        gb2.fill = 2;
        contentPane.add((Component)this.getTimePanel(), gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 0;
        gb2.gridy = 2;
        gb2.fill = 2;
        JButton appendButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_appendButton"));
        appendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                for (MindMapNode element : TimeManagement.this.mController.getSelecteds()) {
                    DateFormat df = DateFormat.getDateInstance(3);
                    String dateAsString = df.format(TimeManagement.this.getCalendarDate());
                    TimeManagement.this.mController.setNodeText(element, element.getText() + " " + dateAsString);
                }
            }
        });
        contentPane.add((Component)appendButton, gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 1;
        gb2.gridy = 2;
        gb2.fill = 2;
        JButton reminderButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_reminderButton"));
        reminderButton.setToolTipText(this.getResourceString("plugins/TimeManagement.xml_reminderButton_tooltip"));
        reminderButton.addActionListener(this);
        contentPane.add((Component)reminderButton, gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 2;
        gb2.gridy = 2;
        gb2.fill = 2;
        reminderButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_removeReminderButton"));
        reminderButton.setToolTipText(this.getResourceString("plugins/TimeManagement.xml_removeReminderButton_tooltip"));
        reminderButton.addActionListener(new RemoveReminders());
        contentPane.add((Component)reminderButton, gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 3;
        gb2.gridy = 2;
        gb2.fill = 2;
        JButton todayButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_todayButton"));
        todayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeManagement.this.calendar.setCalendar(Calendar.getInstance());
            }
        });
        contentPane.add((Component)todayButton, gb2);
        gb2 = new GridBagConstraints();
        gb2.gridx = 4;
        gb2.gridy = 2;
        gb2.fill = 2;
        JButton cancelButton = new JButton(this.getResourceString("plugins/TimeManagement.xml_closeButton"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TimeManagement.this.disposeDialog();
            }
        });
        contentPane.add((Component)cancelButton, gb2);
        if (lastDate != null) {
            this.logger.info("Setting date to " + lastDate);
            this.calendar.setDate(lastDate);
        }
        this.dialog.pack();
        this.calendar.getDayChooser().setFocus();
        this.dialog.setVisible(true);
    }

    private JPanel getTimePanel() {
        if (this.timePanel == null) {
            this.timePanel = new JPanel();
            this.timePanel.setLayout(new GridBagLayout());
            GridBagConstraints gb2 = new GridBagConstraints();
            gb2.gridx = 0;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.timePanel.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_hour")), gb2);
            gb2 = new GridBagConstraints();
            gb2.gridx = 1;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.hourField = new JTextField(2);
            this.hourField.setText(new Integer(this.calendar.getCalendar().get(11)).toString());
            this.timePanel.add((Component)this.hourField, gb2);
            gb2 = new GridBagConstraints();
            gb2.gridx = 2;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.timePanel.add((Component)new JLabel(this.getResourceString("plugins/TimeManagement.xml_minute")), gb2);
            gb2 = new GridBagConstraints();
            gb2.gridx = 3;
            gb2.gridy = 0;
            gb2.fill = 2;
            this.minuteField = new JTextField(2);
            String minuteString = new Integer(this.calendar.getCalendar().get(12)).toString();
            if (minuteString.length() < 2) {
                minuteString = "0" + minuteString;
            }
            this.minuteField.setText(minuteString);
            this.timePanel.add((Component)this.minuteField, gb2);
        }
        return this.timePanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("day")) {
            // empty if block
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Date date = this.getCalendarDate();
        for (MindMapNode node : this.mController.getSelecteds()) {
            ReminderHookBase alreadyPresentHook = TimeManagementOrganizer.getHook(node);
            if (alreadyPresentHook != null) {
                Object[] messageArguments = new Object[]{new Date(alreadyPresentHook.getRemindUserAt()), date};
                MessageFormat formatter = new MessageFormat(this.getResourceString("plugins/TimeManagement.xml_reminderNode_onlyOneDate"));
                String message = formatter.format(messageArguments);
                this.logger.info(messageArguments.length + ", " + message);
                int result = JOptionPane.showConfirmDialog(this.mController.getFrame().getJFrame(), message, "FreeMind", 0);
                if (result == 1) {
                    return;
                }
                this.addHook(node);
            }
            this.addHook(node);
            ReminderHookBase rh = TimeManagementOrganizer.getHook(node);
            if (rh == null) {
                throw new IllegalArgumentException("hook not found although it is present!!");
            }
            rh.setRemindUserAt(date.getTime());
            node.invokeHook(rh);
            this.mController.nodeChanged(node);
        }
    }

    private void addHook(MindMapNode node) {
        List<MindMapNode> selected = Arrays.asList(node);
        this.mController.addHook(node, selected, REMINDER_HOOK_NAME);
    }

    private void disposeDialog() {
        this.dialog.setVisible(false);
        this.dialog.dispose();
        lastDate = this.getCalendarDate();
        sCurrentlyOpenTimeManagement = null;
    }

    private Date getCalendarDate() {
        Calendar cal = this.calendar.getCalendar();
        try {
            int value = 0;
            value = Integer.parseInt(this.hourField.getText());
            cal.set(11, value);
            value = Integer.parseInt(this.minuteField.getText());
            cal.set(12, value);
            cal.set(13, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cal.getTime();
    }

    @Override
    public void afterMapClose(MapModule oldMapModule, Mode oldMode) {
    }

    @Override
    public void afterMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
    }

    @Override
    public void beforeMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        this.mController.getController().getMapModuleManager().removeListener(this);
        this.disposeDialog();
    }

    @Override
    public boolean isMapModuleChangeAllowed(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        return true;
    }

    @Override
    public void numberOfOpenMapInformation(int number) {
    }

    private final class RemoveReminders
    implements ActionListener {
        private RemoveReminders() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (MindMapNode node : TimeManagement.this.mController.getSelecteds()) {
                ReminderHookBase alreadyPresentHook = TimeManagementOrganizer.getHook(node);
                if (alreadyPresentHook == null) continue;
                TimeManagement.this.addHook(node);
            }
        }
    }
}

