/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSConverter;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorViewport;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COSTools {
    @Deprecated
    public static COSObject createObject(Object javaObject) {
        return COSConverter.toCos(javaObject);
    }

    public static List<Revision> getRevisions(COSDocument doc) throws IOException, COSLoadException {
        ArrayList<Revision> result = new ArrayList<Revision>();
        STDocument stDoc = doc.stGetDoc();
        STXRefSection xRef = stDoc.getXRefSection();
        if (stDoc.getRandomAccess() == null) {
            return result;
        }
        ArrayList<STXRefSection> offsetSortedXRefs = new ArrayList<STXRefSection>();
        while (xRef != null) {
            offsetSortedXRefs.add(xRef);
            xRef = xRef.getPrevious();
        }
        Collections.sort(offsetSortedXRefs, new Comparator<STXRefSection>(){

            @Override
            public int compare(STXRefSection o1, STXRefSection o2) {
                if (o1.getOffset() < o2.getOffset()) {
                    return 1;
                }
                if (o1.getOffset() > o2.getOffset()) {
                    return -1;
                }
                return 0;
            }
        });
        long lastEnd = -1L;
        for (STXRefSection section : offsetSortedXRefs) {
            long end;
            COSDictionary cosDict = section.cosGetDict();
            if (cosDict.get(COSTrailer.DK_Root).isNull()) continue;
            long limit = lastEnd;
            if (limit == -1L) {
                limit = stDoc.getRandomAccess().getLength();
            }
            if ((end = COSTools.searchNextEOF(stDoc.getRandomAccess(), section.getOffset(), limit)) == -1L) continue;
            Revision revision = new Revision();
            revision.setXRefSection(section);
            revision.setLength(end);
            result.add(revision);
            lastEnd = end;
        }
        Collections.reverse(result);
        return result;
    }

    public static List<Revision> getSubsequentRevisions(COSDocument doc, STXRefSection base) throws IOException, COSLoadException {
        List<Revision> revisions = COSTools.getRevisions(doc);
        ArrayList<Revision> result = new ArrayList<Revision>();
        boolean include = false;
        for (Revision revision : revisions) {
            if (include) {
                result.add(revision);
                continue;
            }
            if (revision.getXRefSection() != base) continue;
            include = true;
        }
        return result;
    }

    public static List<ILocator> getVersions(COSDocument doc) throws IOException, COSLoadException {
        List<Revision> revisions = COSTools.getRevisions(doc);
        ArrayList<ILocator> result = new ArrayList<ILocator>();
        for (Revision revision : revisions) {
            result.add(revision.createLocator());
        }
        return result;
    }

    protected static boolean readUptoNewLine(IRandomAccess input) throws IOException {
        int i;
        do {
            if ((i = input.read()) != -1) continue;
            return false;
        } while (!PDFParser.isEOL(i));
        if (i == PDFParser.CHAR_CR && (i = input.read()) != PDFParser.CHAR_LF) {
            input.seekBy(-1L);
        }
        return true;
    }

    protected static long searchNextEOF(IRandomAccess input, long start, long end) throws IOException, COSLoadException {
        input.seek(start);
        int comparisonIndex = 0;
        int i = input.read();
        while (i != -1 && input.getOffset() < end) {
            if (i == PDFParser.TOKEN_EOF[comparisonIndex]) {
                if (++comparisonIndex == PDFParser.TOKEN_EOF.length) {
                    COSTools.readUptoNewLine(input);
                    return input.getOffset();
                }
            } else {
                comparisonIndex = 0;
            }
            i = input.read();
        }
        return -1L;
    }

    public static COSDictionary toDictionary(COSObject object) {
        COSDictionary dict = null;
        if (object instanceof COSDictionary) {
            dict = (COSDictionary)object;
        } else if (object instanceof COSStream) {
            dict = ((COSStream)object).getDict();
        }
        return dict;
    }

    private COSTools() {
    }

    public static class Revision {
        private STXRefSection xRefSection;
        private long length;

        public ILocator createLocator() {
            LocatorViewport locator = new LocatorViewport(this.getXRefSection().getDoc().getLocator());
            locator.setName(String.valueOf(this.getXRefSection().getDoc().getLocator().getLocalName()) + "_v" + this.getXRefSection().getIncrementalCount() + ".pdf");
            locator.setStart(0L);
            locator.setEnd(this.getLength());
            locator.setReadOnly();
            return locator;
        }

        public long getLength() {
            return this.length;
        }

        public STXRefSection getXRefSection() {
            return this.xRefSection;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public void setXRefSection(STXRefSection refSection) {
            this.xRefSection = refSection;
        }
    }
}

