/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class COSDictionary
extends COSCompositeObject {
    private final Map objects;

    public static COSDictionary create() {
        return new COSDictionary();
    }

    public static COSDictionary create(int size) {
        return new COSDictionary(size);
    }

    protected COSDictionary() {
        this.objects = new HashMap();
    }

    protected COSDictionary(int size) {
        this.objects = new HashMap(size);
    }

    protected COSDictionary(Map objects) {
        this.objects = objects;
    }

    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        return visitor.visitFromDictionary(this);
    }

    public void addAll(COSDictionary dict) {
        this.willChange(this);
        Iterator i = dict.basicEntryIterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            COSName key = (COSName)entry.getKey();
            COSDocumentElement element = (COSDocumentElement)entry.getValue();
            this.basicPutPropagate(key, element.copyShallowNested());
        }
        if (this.objectListeners != null) {
            this.triggerChanged(null, null, null);
        }
    }

    public void addIfAbsent(COSDictionary dict) {
        boolean changed = false;
        Iterator i = dict.basicEntryIterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            COSName key = (COSName)entry.getKey();
            COSDocumentElement element = (COSDocumentElement)entry.getValue();
            if (this.containsKey(key)) continue;
            if (!changed) {
                changed = true;
                this.willChange(this);
            }
            COSObject newObject = element.copyShallowNested().dereference();
            this.basicPutPropagate(key, newObject);
        }
        if (changed && this.objectListeners != null) {
            this.triggerChanged(null, null, null);
        }
    }

    public COSDictionary asDictionary() {
        return this;
    }

    protected void basicClearPropagate() {
        for (COSDocumentElement element : this.objects.values()) {
            COSObject dereferenced = element.dereference();
            this.willChange(dereferenced);
            ICOSContainer newContainer = element.removeContainer(this);
            dereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        }
        this.objects.clear();
    }

    public Iterator basicEntryIterator() {
        return this.objects.entrySet().iterator();
    }

    public COSDocumentElement basicGet(COSName key) {
        return (COSDocumentElement)this.objects.get(key);
    }

    public Iterator basicIterator() {
        return this.objects.values().iterator();
    }

    protected COSDocumentElement basicPutPropagate(COSName key, COSDocumentElement element) {
        COSObject dereferenced = element.dereference();
        COSDocumentElement containable = element.containable();
        this.willChange(dereferenced);
        ICOSContainer newContainer = containable.addContainer(this);
        COSDocumentElement oldContainable = this.objects.put(key, containable);
        dereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        if (oldContainable != null && oldContainable != containable) {
            COSObject oldDereferenced = oldContainable.dereference();
            this.willChange(oldDereferenced);
            newContainer = oldContainable.removeContainer(this);
            oldDereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        }
        return oldContainable;
    }

    public COSDocumentElement basicPutSilent(COSName key, COSDocumentElement element) {
        COSDocumentElement containable = element.containable();
        containable.addContainer(this);
        COSDocumentElement oldContainable = this.objects.put(key, containable);
        if (oldContainable != null && oldContainable != containable) {
            oldContainable.removeContainer(this);
        }
        return oldContainable;
    }

    protected COSDocumentElement basicRemovePropagate(COSName key) {
        COSDocumentElement element = (COSDocumentElement)this.objects.remove(key);
        if (element == null) {
            return null;
        }
        COSObject dereferenced = element.dereference();
        this.willChange(dereferenced);
        ICOSContainer newContainer = element.removeContainer(this);
        dereferenced.triggerChanged(COSObject.SLOT_CONTAINER, null, newContainer);
        return element;
    }

    public COSDocumentElement basicRemoveSilent(COSName key) {
        COSDocumentElement element = (COSDocumentElement)this.objects.remove(key);
        if (element == null) {
            return null;
        }
        element.removeContainer(this);
        return element;
    }

    protected String basicToString() {
        return this.objects.toString();
    }

    public void clear() {
        this.willChange(this);
        this.basicClearPropagate();
        if (this.objectListeners != null) {
            this.triggerChanged(null, null, null);
        }
    }

    public boolean containsKey(COSName key) {
        return this.objects.containsKey(key);
    }

    public boolean containsValue(COSObject obj) {
        Iterator i = this.entryIterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            COSObject current = (COSObject)entry.getValue();
            if (!current.equals(obj)) continue;
            return true;
        }
        return false;
    }

    protected COSObject copyBasic() {
        return COSDictionary.create(this.size());
    }

    public COSObject copyDeep(Map copied) {
        COSDictionary result = (COSDictionary)super.copyDeep(copied);
        for (Map.Entry entry : this.objects.entrySet()) {
            COSName key = (COSName)entry.getKey();
            COSDocumentElement element = (COSDocumentElement)entry.getValue();
            COSObject copy = element.copyDeep(copied);
            result.basicPutSilent(key, copy);
        }
        return result;
    }

    public COSObject copyShallow() {
        COSDictionary result = (COSDictionary)super.copyShallow();
        Iterator i = this.basicEntryIterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            COSName key = (COSName)entry.getKey();
            COSDocumentElement element = (COSDocumentElement)entry.getValue();
            result.basicPutSilent(key, element.copyShallowNested());
        }
        return result;
    }

    protected COSObject copySubGraph(Map copied) {
        COSDictionary result = (COSDictionary)super.copySubGraph(copied);
        return result;
    }

    public Iterator entryIterator() {
        return new Iterator(){
            private Iterator it;
            {
                this.it = COSDictionary.this.getObjects().entrySet().iterator();
            }

            public boolean hasNext() {
                return this.it.hasNext();
            }

            public Object next() {
                Map.Entry entry = (Map.Entry)this.it.next();
                return new Entry((COSName)entry.getKey(), (COSDocumentElement)entry.getValue());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object o) {
        return this.equals(o, new HashSet());
    }

    protected boolean equals(Object o, Set visited) {
        if (this.isIndirect()) {
            if (visited.contains(this.getIndirectObject())) {
                return true;
            }
            visited.add(this.getIndirectObject());
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof COSDictionary)) {
            return false;
        }
        COSDictionary other = (COSDictionary)o;
        if (this.size() != other.size()) {
            return false;
        }
        for (COSName key : this.keySet()) {
            COSObject eThis = this.get(key);
            COSObject oThis = ((COSDocumentElement)eThis).dereference();
            COSObject eOther = other.get(key);
            COSObject oOther = ((COSDocumentElement)eOther).dereference();
            if (oThis == null && oOther != null) {
                return false;
            }
            if (oThis.equals(oOther, visited)) continue;
            return false;
        }
        return true;
    }

    public COSObject get(COSName key) {
        COSDocumentElement element = this.basicGet(key);
        return element == null ? COSNull.NULL : element.dereference();
    }

    protected Map getObjects() {
        return this.objects;
    }

    public Iterator iterator() {
        return new Iterator(){
            private Iterator i;
            {
                this.i = COSDictionary.this.getObjects().values().iterator();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                return ((COSDocumentElement)this.i.next()).dereference();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public COSObject keyOf(COSObject obj) {
        Iterator i = this.entryIterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            COSObject current = (COSObject)entry.getValue();
            if (!current.equals(obj)) continue;
            return (COSName)entry.getKey();
        }
        return COSNull.NULL;
    }

    public Set keySet() {
        return this.objects.keySet();
    }

    public COSObject put(COSName key, COSObject object) {
        if (object == null) {
            return this.remove(key);
        }
        this.willChange(this);
        COSDocumentElement oldElement = this.basicPutPropagate(key, object);
        COSObject oldObject = null;
        oldObject = oldElement == null ? COSNull.NULL : oldElement.dereference();
        if (this.objectListeners != null) {
            this.triggerChanged(key, oldObject, object);
        }
        return oldObject;
    }

    public COSIndirectObject referenceIndirect(COSObject object) {
        COSIndirectObject ref = super.referenceIndirect(object);
        for (Map.Entry entry : this.objects.entrySet()) {
            if (entry.getValue() != object) continue;
            entry.setValue(ref);
            break;
        }
        return ref;
    }

    public COSObject remove(COSName key) {
        COSObject oldObject;
        this.willChange(this);
        COSDocumentElement element = this.basicRemovePropagate(key);
        if (element == null) {
            oldObject = COSNull.NULL;
        } else {
            oldObject = element.dereference();
            if (this.objectListeners != null) {
                this.triggerChanged(key, oldObject, COSNull.NULL);
            }
        }
        return oldObject;
    }

    public void restoreState(Object object) {
        super.restoreState(object);
        this.objects.clear();
        this.objects.putAll(((COSDictionary)object).objects);
        this.triggerChanged(null, null, null);
    }

    public Object saveState() {
        COSDictionary result = new COSDictionary(new HashMap(this.objects));
        result.container = this.container.saveStateContainer();
        return result;
    }

    public int size() {
        return this.objects.size();
    }

    public List values() {
        ArrayList result = new ArrayList();
        Iterator it = this.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static class Entry
    implements Map.Entry {
        private COSName key;
        private COSDocumentElement value;

        public Entry(COSName key, COSDocumentElement value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value.dereference();
        }

        public Object setValue(Object newValue) {
            this.value = (COSDocumentElement)newValue;
            return this.value;
        }
    }
}

