/*
 * Decompiled with CFR 0.152.
 */
package bibtex.expansions;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

class BibtexPersonListParserTests {
    public static Test[] tests;

    static {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader("/home/machine/henkel/projects/26_javabib/personparsing/RESULTS.txt"));
            ArrayList<Test> testsAsList = new ArrayList<Test>();
            int count = 0;
            while ((line = in.readLine()) != null) {
                System.out.print(".");
                ++count;
                if ((count %= 80) == 0) {
                    System.out.println();
                }
                String[] components = line.split("\\|");
                int i = 0;
                while (i < components.length) {
                    components[i] = components[i].replace('~', ' ');
                    if (components[i].equals("")) {
                        components[i] = null;
                    }
                    ++i;
                }
                if (components.length != 6) {
                    System.err.println("\nError parsing " + line);
                    continue;
                }
                testsAsList.add(new Test(components[0], components[2], components[3], components[4], components[1]));
            }
            tests = new Test[testsAsList.size()];
            testsAsList.toArray(tests);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    BibtexPersonListParserTests() {
    }

    public static class Test {
        private final String string;
        private final String preLast;
        private final String last;
        private final String lineage;
        private final String first;

        public Test(String string, String preLast, String last, String lineage, String first) {
            this.string = string;
            this.preLast = preLast;
            this.last = last;
            this.lineage = lineage;
            this.first = first;
        }

        public String getFirst() {
            return this.first;
        }

        public String getLast() {
            return this.last;
        }

        public String getLineage() {
            return this.lineage;
        }

        public String getPreLast() {
            return this.preLast;
        }

        public String getString() {
            return this.string;
        }
    }
}

