/*
 * Decompiled with CFR 0.152.
 */
package plugins.script;

import freemind.main.Resources;
import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;
import java.util.HashSet;
import java.util.logging.Logger;

public class ScriptingSecurityManager
extends SecurityManager {
    private final boolean mWithoutFileRestriction;
    private final boolean mWithoutNetworkRestriction;
    private final boolean mWithoutExecRestriction;
    private static final int PERM_Accept = 0;
    private static final int PERM_Connect = 1;
    private static final int PERM_Listen = 2;
    private static final int PERM_Multicast = 3;
    private static final int PERM_SetFactory = 4;
    private static final int PERM_Exec = 5;
    private static final int PERM_Link = 6;
    private static final int PERM_Delete = 7;
    private static final int PERM_Read = 8;
    private static final int PERM_Write = 9;
    private static final int PERM_GROUP_FILE = 0;
    private static final int PERM_GROUP_NETWORK = 1;
    private static final int PERM_GROUP_EXEC = 2;
    private static Logger logger = null;

    public ScriptingSecurityManager(boolean pWithoutFileRestriction, boolean pWithoutNetworkRestriction, boolean pWithoutExecRestriction) {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.mWithoutFileRestriction = pWithoutFileRestriction;
        this.mWithoutNetworkRestriction = pWithoutNetworkRestriction;
        this.mWithoutExecRestriction = pWithoutExecRestriction;
    }

    @Override
    public void checkAccept(String pHost, int pPort) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 0);
    }

    @Override
    public void checkConnect(String pHost, int pPort, Object pContext) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 1);
    }

    @Override
    public void checkConnect(String pHost, int pPort) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 1);
    }

    @Override
    public void checkListen(int pPort) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 2);
    }

    @Override
    public void checkMulticast(InetAddress pMaddr, byte pTtl) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 3);
    }

    @Override
    public void checkMulticast(InetAddress pMaddr) {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 3);
    }

    @Override
    public void checkSetFactory() {
        if (this.mWithoutNetworkRestriction) {
            return;
        }
        throw this.getException(1, 4);
    }

    @Override
    public void checkExec(String pCmd) {
        if (this.mWithoutExecRestriction) {
            return;
        }
        throw this.getException(2, 5);
    }

    @Override
    public void checkLink(String pLib) {
        HashSet<String> set = new HashSet<String>();
        set.add("awt");
        set.add("net");
        set.add("jpeg");
        set.add("fontmanager");
        if (this.mWithoutExecRestriction || set.contains(pLib)) {
            return;
        }
        throw this.getException(2, 6);
    }

    @Override
    public void checkDelete(String pFile) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 7);
    }

    @Override
    public void checkRead(FileDescriptor pFd) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 8);
    }

    @Override
    public void checkRead(String pFile, Object pContext) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 8);
    }

    @Override
    public void checkRead(String pFile) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 8);
    }

    @Override
    public void checkWrite(FileDescriptor pFd) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 9);
    }

    @Override
    public void checkWrite(String pFile) {
        if (this.mWithoutFileRestriction) {
            return;
        }
        throw this.getException(0, 9);
    }

    private SecurityException getException(int pPermissionGroup, int pPermission) {
        return new SecurityException(Resources.getInstance().format("plugins/ScriptEditor.FORBIDDEN_ACTION", (Object[])new Integer[]{new Integer(pPermissionGroup), new Integer(pPermission)}));
    }

    @Override
    public void checkAccess(Thread pT) {
    }

    @Override
    public void checkAccess(ThreadGroup pG) {
    }

    public void checkAwtEventQueueAccess() {
    }

    @Override
    public void checkCreateClassLoader() {
    }

    @Override
    public void checkExit(int pStatus) {
    }

    public void checkMemberAccess(Class arg0, int arg1) {
    }

    @Override
    public void checkPackageAccess(String pPkg) {
    }

    @Override
    public void checkPackageDefinition(String pPkg) {
    }

    @Override
    public void checkPermission(Permission pPerm, Object pContext) {
        logger.info("Check Permission with Context: " + pPerm.getClass());
    }

    @Override
    public void checkPermission(Permission pPerm) {
        logger.info("Check Permission: " + pPerm.getClass());
    }

    @Override
    public void checkPrintJobAccess() {
    }

    @Override
    public void checkPropertiesAccess() {
    }

    @Override
    public void checkPropertyAccess(String pKey) {
    }

    @Override
    public void checkSecurityAccess(String pTarget) {
    }

    public void checkSystemClipboardAccess() {
    }

    public boolean checkTopLevelWindow(Object pWindow) {
        return true;
    }
}

