/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.COSLoadWarning;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STStreamXRefSection;
import de.intarsys.pdf.st.STTrailerXRefSection;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.XRefStreamParser;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.Arrays;

public class XRefTrailerParser
extends AbstractXRefParser {
    public XRefTrailerParser(STDocument sTDocument, COSDocumentParser cOSDocumentParser) {
        super(sTDocument, cOSDocumentParser);
    }

    protected void loadPrevious(IRandomAccess iRandomAccess, STXRefSection sTXRefSection) throws IOException, COSLoadException {
        int n;
        Object object;
        int n2 = sTXRefSection.getXRefStmOffset();
        if (n2 != -1) {
            XRefStreamParser xRefStreamParser = new XRefStreamParser(this.getDoc(), this.getParser());
            iRandomAccess.seek((long)n2);
            try {
                object = (STStreamXRefSection)((AbstractXRefParser)xRefStreamParser).parse(iRandomAccess);
                ((STTrailerXRefSection)sTXRefSection).setXRefStream((STStreamXRefSection)object);
            }
            catch (Exception exception) {}
        }
        if ((n = sTXRefSection.getPreviousOffset()) != -1) {
            object = new XRefTrailerParser(this.getDoc(), this.getParser());
            iRandomAccess.seek((long)n);
            STXRefSection sTXRefSection2 = ((AbstractXRefParser)object).parse(iRandomAccess);
            sTXRefSection.setPrevious(sTXRefSection2);
        }
    }

    public STXRefSection parse(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        STXRefSection sTXRefSection = this.parseXRef(iRandomAccess);
        this.loadPrevious(iRandomAccess, sTXRefSection);
        return sTXRefSection;
    }

    private STXRefEntry parseEntry(int n, byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 10) {
            n2 = n2 * 10 + (byArray[n3] - 48);
            ++n3;
        }
        n3 = 0;
        int n4 = 11;
        while (n4 < 16) {
            n3 = n3 * 10 + (byArray[n4] - 48);
            ++n4;
        }
        int n5 = n4 = byArray[17] == 110 ? 1 : 0;
        if (n4 != 0) {
            return new STXRefEntryOccupied(n, n3, n2);
        }
        return new STXRefEntryFree(n, n3, n2);
    }

    protected STXRefSection parseXRef(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        STTrailerXRefSection sTTrailerXRefSection = new STTrailerXRefSection(this.getDoc(), iRandomAccess.getOffset());
        this.parseXRefSection(iRandomAccess, sTTrailerXRefSection);
        sTTrailerXRefSection.cosSetDict(this.getDoc().getParser().parseTrailer(iRandomAccess));
        return sTTrailerXRefSection;
    }

    protected void parseXRefSection(IRandomAccess iRandomAccess, STTrailerXRefSection sTTrailerXRefSection) throws IOException, COSLoadException {
        this.getDoc().getParser().readSpaces(iRandomAccess);
        byte[] byArray = new byte[4];
        iRandomAccess.read(byArray);
        if (Arrays.equals(byArray, PDFParser.TOKEN_xref)) {
            byArray = new byte[PDFParser.TOKEN_trailer.length];
            long l = -1L;
            long l2 = iRandomAccess.getOffset();
            while (l != l2) {
                l = l2;
                this.parseXRefSubsection(iRandomAccess, sTTrailerXRefSection);
                this.getDoc().getParser().readSpaces(iRandomAccess);
                int n = iRandomAccess.read();
                iRandomAccess.seekBy(-1L);
                if (n != -1 && PDFParser.isDigit(n)) {
                    l2 = iRandomAccess.getOffset();
                    continue;
                }
                break;
            }
        } else {
            COSLoadError cOSLoadError = new COSLoadError("no 'xref' key found at character index " + iRandomAccess.getOffset());
            this.handleError(cOSLoadError);
        }
    }

    protected void parseXRefSubsection(IRandomAccess iRandomAccess, STTrailerXRefSection sTTrailerXRefSection) throws IOException, COSLoadException {
        COSLoadWarning cOSLoadWarning;
        int n = this.getDoc().getParser().readInteger(iRandomAccess, false);
        int n2 = iRandomAccess.read();
        if (n2 == -1) {
            return;
        }
        if (n2 != 32) {
            cOSLoadWarning = new COSLoadWarning("614a");
            cOSLoadWarning.setHint(new Long(iRandomAccess.getOffset()));
            this.getParser().handleWarning(cOSLoadWarning);
        }
        if ((n2 = iRandomAccess.read()) == -1) {
            return;
        }
        iRandomAccess.seekBy(-1L);
        if (!PDFParser.isDigit(n2)) {
            cOSLoadWarning = new COSLoadWarning("614a");
            cOSLoadWarning.setHint(new Long(iRandomAccess.getOffset()));
            this.getParser().handleWarning(cOSLoadWarning);
        }
        int n3 = this.getDoc().getParser().readInteger(iRandomAccess, true);
        this.getDoc().getParser().readSpaces(iRandomAccess);
        byte[] byArray = new byte[20];
        int n4 = 0;
        while (n4 < n3) {
            n2 = iRandomAccess.read(byArray);
            if (n2 == -1) {
                return;
            }
            STXRefEntry sTXRefEntry = this.parseEntry(n + n4, byArray);
            sTTrailerXRefSection.addEntry(sTXRefEntry);
            ++n4;
        }
    }
}

