/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectProxy;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDBuildProperties;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDSignatureReference;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PDSignature
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_Sig = COSName.constant("Sig");
    public static final COSName DK_Filter = COSName.constant("Filter");
    public static final COSName DK_SubFilter = COSName.constant("SubFilter");
    public static final COSName DK_Contents = COSName.constant("Contents");
    public static final COSName DK_Cert = COSName.constant("Cert");
    public static final COSName DK_ByteRange = COSName.constant("ByteRange");
    public static final COSName DK_Reference = COSName.constant("Reference");
    public static final COSName DK_Changes = COSName.constant("Changes");
    public static final COSName DK_Name = COSName.constant("Name");
    public static final COSName DK_M = COSName.constant("M");
    public static final COSName DK_Location = COSName.constant("Location");
    public static final COSName DK_Reason = COSName.constant("Reason");
    public static final COSName DK_ContactInfo = COSName.constant("ContactInfo");
    public static final COSName DK_R = COSName.constant("R");
    public static final COSName DK_V = COSName.constant("V");
    public static final COSName DK_Prop_Build = COSName.constant("Prop_Build");
    public static final COSName DK_Prop_AuthTime = COSName.constant("Prop_Auth_Time");
    public static final COSName DK_Prop_AuthType = COSName.constant("Prop_AuthType");
    private PDAFSignatureField acroFormField;
    private List cachedReferences;

    protected PDSignature(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSArray cosGetByteRange() {
        return this.cosGetField(DK_ByteRange).asArray();
    }

    protected COSName cosGetExpectedType() {
        return CN_Type_Sig;
    }

    public PDAFSignatureField getAcroFormField() {
        return this.acroFormField;
    }

    public PDBuildProperties getBuildProperties() {
        return (PDBuildProperties)PDBuildProperties.META.createFromCos(this.cosGetField(DK_Prop_Build));
    }

    public List getCert() {
        ArrayList<byte[]> arrayList = null;
        COSObject cOSObject = this.cosGetField(DK_Cert);
        if (!cOSObject.isNull()) {
            arrayList = new ArrayList<byte[]>();
            if (cOSObject instanceof COSString) {
                arrayList.add(((COSString)cOSObject).byteValue());
                return arrayList;
            }
            if (cOSObject instanceof COSArray) {
                COSArray cOSArray = (COSArray)cOSObject;
                Iterator iterator = cOSArray.iterator();
                while (iterator.hasNext()) {
                    COSString cOSString = ((COSObject)iterator.next()).asString();
                    if (cOSString == null) continue;
                    arrayList.add(cOSString.byteValue());
                }
            }
        }
        return arrayList;
    }

    public String getContactInfo() {
        return this.getFieldString(DK_ContactInfo, null);
    }

    public byte[] getContentBytes() {
        COSString cOSString;
        byte[] byArray = null;
        COSDocumentElement cOSDocumentElement = this.cosGetDict().basicGet(DK_Contents);
        if (cOSDocumentElement instanceof COSString) {
            byArray = this.getDoc().isEncrypted() ? this.getContentBytesPlain() : ((COSString)cOSDocumentElement).byteValue();
        } else if (cOSDocumentElement instanceof COSObjectProxy && (cOSString = cOSDocumentElement.dereference().asString()) != null) {
            byArray = cOSString.byteValue();
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    protected byte[] getContentBytesPlain() {
        block8: {
            COSArray cOSArray = this.cosGetByteRange();
            if (cOSArray.size() != 4) {
                return null;
            }
            IRandomAccess iRandomAccess = null;
            try {
                int n = cOSArray.get(1).asInteger().intValue();
                iRandomAccess = this.getDoc().getLocator().getRandomAccess();
                iRandomAccess.seek((long)n);
                COSDocumentParser cOSDocumentParser = new COSDocumentParser(null);
                Object object = cOSDocumentParser.parseElement(iRandomAccess);
                if (object instanceof COSString) {
                    byte[] byArray = ((COSString)object).byteValue();
                    StreamTools.close((IRandomAccess)iRandomAccess);
                    return byArray;
                }
            }
            catch (Exception exception) {
                break block8;
            }
            finally {
                StreamTools.close(iRandomAccess);
            }
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
        return null;
    }

    public CDSDate getDate() {
        return CDSDate.createFromCOS(this.cosGetField(DK_M).asString());
    }

    public COSName getFilter() {
        return this.cosGetField(DK_Filter).asName();
    }

    public String getLocation() {
        return this.getFieldString(DK_Location, null);
    }

    public String getName() {
        return this.getFieldString(DK_Name, null);
    }

    public String getReason() {
        return this.getFieldString(DK_Reason, null);
    }

    public List getSignatureReferences() {
        if (this.cachedReferences == null) {
            this.cachedReferences = this.getPDObjects(DK_Reference, PDSignatureReference.META, true);
        }
        return this.cachedReferences;
    }

    public COSName getSubFilter() {
        return this.cosGetField(DK_SubFilter).asName();
    }

    public void invalidateCaches() {
        this.cachedReferences = null;
        super.invalidateCaches();
    }

    public void setAcroFormField(PDAFSignatureField pDAFSignatureField) {
        this.acroFormField = pDAFSignatureField;
    }

    public void setBuildProperties(PDBuildProperties pDBuildProperties) {
        this.setFieldObject(DK_Prop_Build, pDBuildProperties);
    }

    public void setCert(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        COSString cOSString = COSString.createHex(byArray);
        this.cosSetField(DK_Cert, cOSString);
    }

    public void setCert(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (list.size() == 1) {
            this.setCert((byte[])list.get(0));
            return;
        }
        COSArray cOSArray = COSArray.create(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            COSString cOSString = COSString.createHex((byte[])iterator.next());
            cOSArray.add(cOSString);
        }
        this.cosSetField(DK_Cert, cOSArray);
    }

    public void setContactInfo(String string) {
        this.setFieldString(DK_ContactInfo, string);
    }

    public void setDate(CDSDate cDSDate) {
        this.setFieldObject(DK_M, cDSDate);
    }

    public void setFilter(COSName cOSName) {
        this.cosSetField(DK_Filter, cOSName);
    }

    public void setLocation(String string) {
        this.setFieldString(DK_Location, string);
    }

    public void setName(String string) {
        this.setFieldString(DK_Name, string);
    }

    public void setReason(String string) {
        this.setFieldString(DK_Reason, string);
    }

    public void setSignatureReferences(List list) {
        this.setPDObjects(DK_Reference, list);
        this.cachedReferences = list;
    }

    public void setSubFilter(COSName cOSName) {
        this.cosSetField(DK_SubFilter, cOSName);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDSignature(cOSObject);
        }
    }
}

