/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutlineItem;
import java.util.ArrayList;
import java.util.List;

public abstract class PDOutlineNode
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_First = COSName.constant("First");
    public static final COSName DK_Last = COSName.constant("Last");
    public static final COSName DK_Count = COSName.constant("Count");

    protected PDOutlineNode(COSObject cOSObject) {
        super(cOSObject);
    }

    public List getChildren() {
        ArrayList<PDOutlineItem> arrayList = new ArrayList<PDOutlineItem>();
        PDOutlineItem pDOutlineItem = this.getFirst();
        while (pDOutlineItem != null) {
            arrayList.add(pDOutlineItem);
            pDOutlineItem = pDOutlineItem.getNext();
        }
        return arrayList;
    }

    public int getCount() {
        return this.getFieldInt(DK_Count, 0);
    }

    protected void setCount(int n) {
        this.setFieldInt(DK_Count, n);
    }

    public PDOutlineItem getFirst() {
        return (PDOutlineItem)PDOutlineItem.META.createFromCos(this.cosGetField(DK_First));
    }

    protected void setFirst(PDOutlineItem pDOutlineItem) {
        this.setFieldObject(DK_First, pDOutlineItem);
    }

    protected void setLast(PDOutlineItem pDOutlineItem) {
        this.setFieldObject(DK_Last, pDOutlineItem);
    }

    public PDOutlineItem getLast() {
        return (PDOutlineItem)PDOutlineItem.META.createFromCos(this.cosGetField(DK_Last));
    }

    public boolean isOutline() {
        return false;
    }

    public void addItem(PDOutlineItem pDOutlineItem) {
        PDOutlineItem pDOutlineItem2;
        int n = this.getCount() + 1;
        this.setCount(n);
        PDOutlineItem pDOutlineItem3 = this.getFirst();
        if (pDOutlineItem3 == null) {
            this.setFirst(pDOutlineItem);
        }
        if ((pDOutlineItem2 = this.getLast()) != null) {
            pDOutlineItem2.setNext(pDOutlineItem);
            pDOutlineItem.setPrev(pDOutlineItem2);
        }
        this.setLast(pDOutlineItem);
        pDOutlineItem.setParent(this);
    }

    public boolean removeItem(PDOutlineItem pDOutlineItem) {
        if (pDOutlineItem.getParent() != this) {
            return false;
        }
        int n = this.getCount() - 1;
        this.setCount(n);
        if (pDOutlineItem.getPrev() != null) {
            pDOutlineItem.getPrev().setNext(pDOutlineItem.getNext());
        }
        if (pDOutlineItem.getNext() != null) {
            pDOutlineItem.getNext().setPrev(pDOutlineItem.getPrev());
        }
        if (n == 0) {
            this.setFirst(null);
            this.setLast(null);
        } else {
            if (this.getFirst() == pDOutlineItem) {
                this.setFirst(pDOutlineItem.getNext());
            }
            if (this.getLast() == pDOutlineItem) {
                this.setLast(pDOutlineItem.getPrev());
            }
        }
        pDOutlineItem.setParent(null);
        return true;
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        public Class getRootClass() {
            return PDOutlineNode.class;
        }

        protected COSBasedObject.MetaClass doDetermineClass(COSObject cOSObject) {
            if (cOSObject instanceof COSDictionary) {
                COSDictionary cOSDictionary = (COSDictionary)cOSObject;
                COSName cOSName = cOSDictionary.get(PDObject.DK_Type).asName();
                if (PDOutline.CN_Type_Outlines.equals(cOSName)) {
                    return PDOutline.META;
                }
                if (cOSDictionary.get(PDOutlineItem.DK_Parent).isNull() && cOSDictionary.get(PDOutlineItem.DK_Title).isNull()) {
                    return PDOutline.META;
                }
                return PDOutlineItem.META;
            }
            return super.doDetermineClass(cOSObject);
        }
    }
}

