/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDXObject;
import java.io.IOException;

public class PDImage
extends PDXObject {
    public static final String C_RENDERING_VALID1 = "RelativeColorimetric";
    public static final String C_RENDERING_VALID2 = "AbsoluteColorimetric";
    public static final String C_RENDERING_VALID3 = "Perceptual";
    public static final String C_RENDERING_VALID4 = "Saturation";
    public static final COSName CN_Subtype_Image = COSName.constant("Image");
    public static final COSName DK_Alternates = COSName.constant("Alternates");
    public static final COSName DK_BitsPerComponent = COSName.constant("BitsPerComponent");
    public static final COSName DK_BPC = COSName.constant("BPC");
    public static final COSName DK_ColorSpace = COSName.constant("ColorSpace");
    public static final COSName DK_CS = COSName.constant("CS");
    public static final COSName DK_D = COSName.constant("D");
    public static final COSName DK_Decode = COSName.constant("Decode");
    public static final COSName DK_DecodeParms = COSName.constant("DecodeParms");
    public static final COSName DK_DP = COSName.constant("DP");
    public static final COSName DK_H = COSName.constant("H");
    public static final COSName DK_Height = COSName.constant("Height");
    public static final COSName DK_I = COSName.constant("I");
    public static final COSName DK_ID = COSName.constant("ID");
    public static final COSName DK_IM = COSName.constant("IM");
    public static final COSName DK_ImageMask = COSName.constant("ImageMask");
    public static final COSName DK_Intent = COSName.constant("Intent");
    public static final COSName DK_Interpolate = COSName.constant("Interpolate");
    public static final COSName DK_Mask = COSName.constant("Mask");
    public static final COSName DK_Metadata = COSName.constant("Metadata");
    public static final COSName DK_Name = COSName.constant("Name");
    public static final COSName DK_OC = COSName.constant("OC");
    public static final COSName DK_OPI = COSName.constant("OPI");
    public static final COSName DK_SMask = COSName.constant("SMask");
    public static final COSName DK_SMaskInData = COSName.constant("SMaskInData");
    public static final COSName DK_StructParent = COSName.constant("StructParent");
    public static final COSName DK_W = COSName.constant("W");
    public static final COSName DK_Width = COSName.constant("Width");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private PDColorSpace cachedColorSpace = null;
    private int cachedHeight = -1;
    private int cachedIsImageMask = -1;
    private int cachedIsInterpolate = -1;
    private int cachedWidth = -1;
    private byte[] cachedBytes;

    protected PDImage(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSStream cosExtractJPEGStream() throws IOException {
        COSStream cOSStream = this.cosGetStream();
        while (!(cOSStream.getFirstFilter().stringValue().equals("DCTDecode") || cOSStream.getFirstFilter().stringValue().equals("DCT") || cOSStream.getFirstFilter().stringValue().equals("JPXDecode"))) {
            cOSStream = cOSStream.copyDecodeFirst();
        }
        return cOSStream;
    }

    public COSObject cosGetColorSpace() {
        COSObject cOSObject = this.cosGetField(DK_CS);
        if (!cOSObject.isNull()) {
            return cOSObject;
        }
        return this.cosGetField(DK_ColorSpace);
    }

    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Image;
    }

    public COSObject cosGetMask() {
        return this.cosGetField(DK_Mask);
    }

    public COSArray cosSetColorSpace(COSArray cOSArray) {
        return this.cosSetField(DK_ColorSpace, cOSArray).asArray();
    }

    public COSName cosSetColorSpace(COSName cOSName) {
        return this.cosSetField(DK_ColorSpace, cOSName).asName();
    }

    public byte[] getAdjustedBytes(int n) {
        if (this.cachedBytes != null) {
            return this.cachedBytes;
        }
        int n2 = this.getBitsPerComponent() * n;
        int n3 = (n2 + 7) / 8;
        int[] nArray = this.getDecode();
        if (nArray != null && nArray.length == 2 && nArray[0] == 1 && nArray[1] == 0) {
            this.cachedBytes = this.cosGetStream().getDecodedBytesWritable();
            int n4 = 0;
            while (n4 < this.cachedBytes.length) {
                this.cachedBytes[n4] = ~this.cachedBytes[n4];
                ++n4;
            }
        } else {
            this.cachedBytes = this.cosGetStream().getDecodedBytes();
        }
        int n5 = this.getHeight() * (((this.getWidth() * n2 + 7) / 8 + n3 - 1) / n3 * n3);
        if (this.cachedBytes.length != n5) {
            byte[] byArray = new byte[n5];
            System.arraycopy(this.cachedBytes, 0, byArray, 0, Math.min(this.cachedBytes.length, n5));
            this.cachedBytes = byArray;
        }
        return this.cachedBytes;
    }

    public int getBitsPerComponent() {
        COSInteger cOSInteger = this.cosGetField(DK_BPC).asInteger();
        if (cOSInteger != null) {
            return cOSInteger.intValue();
        }
        return this.getFieldInt(DK_BitsPerComponent, 1);
    }

    public byte[][] getColorKeyMask(int n) {
        COSArray cOSArray = this.cosGetMask().asArray();
        if (cOSArray == null) {
            return null;
        }
        byte[][] byArray = new byte[cOSArray.size() / n][n];
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = 0;
            while (n3 < n) {
                byArray[n2][n3] = (byte)((COSNumber)cOSArray.get(n2 * n + n3)).intValue();
                ++n3;
            }
            ++n2;
        }
        return byArray;
    }

    public PDColorSpace getColorSpace() {
        if (this.cachedColorSpace == null) {
            COSObject cOSObject = this.cosGetField(DK_CS);
            this.cachedColorSpace = !cOSObject.isNull() ? (PDColorSpace)PDColorSpace.META.createFromCos(cOSObject) : (PDColorSpace)PDColorSpace.META.createFromCos(this.cosGetField(DK_ColorSpace));
            if (this.cachedColorSpace == null && this.isImageMask()) {
                this.cachedColorSpace = PDCSDeviceGray.SINGLETON;
            }
        }
        return this.cachedColorSpace;
    }

    public int[] getDecode() {
        COSArray cOSArray = this.cosGetField(DK_Decode).asArray();
        if (cOSArray == null) {
            cOSArray = this.cosGetField(DK_D).asArray();
        }
        if (cOSArray == null) {
            return null;
        }
        int[] nArray = new int[cOSArray.size()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = cOSArray.get(n).asNumber().intValue();
            ++n;
        }
        return nArray;
    }

    public int getHeight() {
        if (this.cachedHeight == -1) {
            this.cachedHeight = this.getFieldInt(DK_Height, -1);
            if (this.cachedHeight == -1) {
                this.cachedHeight = this.getFieldInt(DK_H, 0);
            }
        }
        return this.cachedHeight;
    }

    public PDImage getMaskImage() {
        COSObject cOSObject = this.cosGetMask();
        if (cOSObject.isNull()) {
            return null;
        }
        try {
            return (PDImage)PDXObject.META.createFromCos(cOSObject);
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public PDXObject getSMask() {
        return (PDXObject)PDXObject.META.createFromCos(this.cosGetField(DK_SMask));
    }

    public int getWidth() {
        if (this.cachedWidth == -1) {
            this.cachedWidth = this.getFieldInt(DK_Width, -1);
            if (this.cachedWidth == -1) {
                this.cachedWidth = this.getFieldInt(DK_W, 0);
            }
        }
        return this.cachedWidth;
    }

    public boolean hasTransparency() {
        return !this.cosGetMask().isNull() || this.getSMask() != null;
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedColorSpace = null;
        this.cachedHeight = -1;
        this.cachedWidth = -1;
        this.cachedBytes = null;
        this.cachedIsInterpolate = -1;
        this.cachedIsImageMask = -1;
    }

    public boolean isImage() {
        return true;
    }

    public boolean isImageMask() {
        if (this.cachedIsImageMask == -1) {
            COSBoolean cOSBoolean = this.cosGetField(DK_ImageMask).asBoolean();
            if (cOSBoolean == null) {
                cOSBoolean = this.cosGetField(DK_IM).asBoolean();
            }
            this.cachedIsImageMask = cOSBoolean != null && cOSBoolean.booleanValue() ? 1 : 0;
        }
        return this.cachedIsImageMask == 1;
    }

    public boolean isInterpolate() {
        if (this.cachedIsInterpolate == -1) {
            this.cachedIsInterpolate = this.getFieldBoolean(DK_Interpolate, false) ? 1 : 0;
        }
        return this.cachedIsInterpolate == 1;
    }

    public void setBitsPerComponent(int n) {
        this.setFieldInt(DK_BitsPerComponent, n);
    }

    public void setColorSpace(PDColorSpace pDColorSpace) {
        this.cachedColorSpace = pDColorSpace;
    }

    public void setDecode(int[] nArray) {
        COSArray cOSArray = COSArray.create(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            cOSArray.add(COSInteger.create(nArray[n]));
            ++n;
        }
        this.cosSetField(DK_Decode, cOSArray);
    }

    public void setHeight(int n) {
        this.setFieldInt(DK_Height, n);
    }

    public void setImageMask(boolean bl) {
        this.setFieldBoolean(DK_ImageMask, bl);
    }

    public void setMask(PDXObject pDXObject) {
        this.setFieldObject(DK_Mask, pDXObject);
    }

    public void setSMask(PDXObject pDXObject) {
        this.setFieldObject(DK_SMask, pDXObject);
    }

    public void setWidth(int n) {
        this.setFieldInt(DK_Width, n);
    }

    public static class MetaClass
    extends PDXObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDImage(cOSObject);
        }
    }
}

