/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDInterpolationFunction;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPostScriptFunction;
import de.intarsys.pdf.pd.PDSampledFunction;
import de.intarsys.pdf.pd.PDStitchingFunction;

public abstract class PDFunction
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_FunctionType = COSName.constant("FunctionType");
    public static final COSName DK_Domain = COSName.constant("Domain");
    public static final COSName DK_Range = COSName.constant("Range");

    protected PDFunction(COSObject cOSObject) {
        super(cOSObject);
    }

    public abstract float[] evaluate(float[] var1);

    public float getDomainMax(int n) {
        return ((COSNumber)this.cosGetDomain().get(n * 2 + 1)).floatValue();
    }

    public float getDomainMin(int n) {
        return ((COSNumber)this.cosGetDomain().get(n * 2)).floatValue();
    }

    public int getInputSize() {
        return this.cosGetDomain().size() / 2;
    }

    public abstract int getOutputSize();

    public COSArray cosGetDomain() {
        return this.cosGetDict().get(DK_Domain).asArray();
    }

    public COSArray getRange() {
        return this.cosGetDict().get(DK_Range).asArray();
    }

    public float getRangeMax(int n) {
        return ((COSNumber)this.getRange().get(n * 2 + 1)).floatValue();
    }

    public float getRangeMin(int n) {
        return ((COSNumber)this.getRange().get(n * 2)).floatValue();
    }

    protected float clip(float f, float f2, float f3) {
        if (f < f2) {
            return f2;
        }
        if (f > f3) {
            return f3;
        }
        return f;
    }

    protected float[] dummyResult() {
        float[] fArray = new float[this.getOutputSize()];
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = 0.0f;
            ++n;
        }
        return fArray;
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        public Class getRootClass() {
            return PDFunction.class;
        }

        protected COSBasedObject.MetaClass doDetermineClass(COSObject cOSObject) {
            COSDictionary cOSDictionary = null;
            if (cOSObject instanceof COSStream) {
                cOSDictionary = ((COSStream)cOSObject).getDict();
            } else if (cOSObject instanceof COSDictionary) {
                cOSDictionary = (COSDictionary)cOSObject;
            }
            if (cOSDictionary == null) {
                throw new IllegalArgumentException("No Function dictionary available");
            }
            COSInteger cOSInteger = cOSDictionary.get(DK_FunctionType).asInteger();
            if (cOSInteger == null) {
                throw new IllegalArgumentException("Function dictionary has no type");
            }
            if (cOSInteger.intValue() == 0) {
                return PDSampledFunction.META;
            }
            if (cOSInteger.intValue() == 2) {
                return PDInterpolationFunction.META;
            }
            if (cOSInteger.intValue() == 3) {
                return PDStitchingFunction.META;
            }
            if (cOSInteger.intValue() == 4) {
                return PDPostScriptFunction.META;
            }
            throw new IllegalArgumentException("Function type " + cOSInteger + " not supported");
        }
    }
}

