/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDObject;

public class PDBorderStyle
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_W = COSName.constant("W");
    public static final COSName DK_S = COSName.constant("S");
    public static final COSName CN_S_S = COSName.constant("S");
    public static final COSName CN_S_D = COSName.constant("D");
    public static final COSName CN_S_B = COSName.constant("B");
    public static final COSName CN_S_I = COSName.constant("I");
    public static final COSName CN_S_U = COSName.constant("U");
    public static final COSName DK_D = COSName.constant("D");
    public static final COSName CN_Type_Border = COSName.constant("Border");

    protected PDBorderStyle(COSObject cOSObject) {
        super(cOSObject);
    }

    public void setDashArray(int[] nArray) {
        if (nArray == null || nArray.length == 1 && nArray[0] == 3) {
            this.cosRemoveField(DK_D);
            return;
        }
        COSArray cOSArray = COSArray.create(nArray.length);
        this.cosSetField(DK_D, cOSArray);
        int n = 0;
        while (n < nArray.length) {
            cOSArray.add(COSInteger.create(nArray[n]));
            ++n;
        }
    }

    public int[] getDashArray() {
        COSArray cOSArray = this.cosGetField(DK_D).asArray();
        if (cOSArray != null) {
            int[] nArray = new int[cOSArray.size()];
            int n = 0;
            while (n < cOSArray.size()) {
                COSInteger cOSInteger = cOSArray.get(n).asInteger();
                nArray[n] = cOSInteger != null ? cOSInteger.intValue() : 0;
                ++n;
            }
            return nArray;
        }
        return new int[]{3};
    }

    public void setStyle(COSName cOSName) {
        this.cosSetField(DK_S, cOSName);
    }

    public COSName getStyle() {
        COSName cOSName = this.cosGetField(DK_S).asName();
        if (cOSName != null) {
            return cOSName;
        }
        return CN_S_S;
    }

    protected COSName cosGetExpectedType() {
        return CN_Type_Border;
    }

    public void setWidth(float f) {
        if (f != 1.0f) {
            this.setFieldFixed(DK_W, f);
        } else {
            this.cosRemoveField(DK_W);
        }
    }

    public float getWidth() {
        return this.getFieldFixed(DK_W, 1.0f);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDBorderStyle(cOSObject);
        }
    }
}

