/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.pd.PDShading;

public class PDAxialShading
extends PDShading {
    private static final COSName DK_Coords = COSName.constant("Coords");
    private static final COSName DK_Domain = COSName.constant("Domain");
    private static final COSName DK_Extend = COSName.constant("Extend");
    private static final COSName DK_Function = COSName.constant("Function");
    public static final MetaClass META = new MetaClass((Class)MetaClass.class.getDeclaringClass());
    private float[] coords;
    private float[] domain;
    private boolean[] extend;
    private PDFunction function;

    protected PDAxialShading(COSObject cOSObject) {
        super(cOSObject);
        COSArray cOSArray = cOSObject.asDictionary().get(DK_Coords).asArray();
        this.coords = new float[4];
        int n = 0;
        while (n < 4) {
            this.coords[n] = ((COSNumber)cOSArray.get(n)).floatValue();
            ++n;
        }
        COSObject cOSObject2 = cOSObject.asDictionary().get(DK_Domain);
        if (cOSObject2.isNull()) {
            this.domain = new float[]{0.0f, 1.0f};
        } else {
            this.domain = new float[2];
            n = 0;
            while (n < 2) {
                this.domain[n] = ((COSNumber)cOSObject2.asArray().get(n)).floatValue();
                ++n;
            }
        }
        COSObject cOSObject3 = cOSObject.asDictionary().get(DK_Extend);
        if (cOSObject3.isNull()) {
            this.extend = new boolean[2];
        } else {
            this.extend = new boolean[2];
            n = 0;
            while (n < 2) {
                this.extend[n] = cOSObject3.asArray().get(n).asBoolean().booleanValue();
                ++n;
            }
        }
    }

    public float[] getCoords() {
        return this.coords;
    }

    public float[] getDomain() {
        return this.domain;
    }

    public PDFunction getFunction() {
        if (this.function == null) {
            this.function = (PDFunction)PDFunction.META.createFromCos(((COSDictionary)this.cosGetObject()).get(DK_Function));
        }
        return this.function;
    }

    public int getShadingType() {
        return 2;
    }

    public static class MetaClass
    extends PDShading.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }
    }
}

