/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RunLengthInputStream
extends FilterInputStream {
    private byte[] buffer = new byte[128];
    private int length = 0;
    private int pos = 0;

    public RunLengthInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int available() throws IOException {
        throw new IOException("method not supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.pos >= this.length) {
            int n = this.in.read();
            if (n == -1 || n == 128) {
                return -1;
            }
            this.pos = 0;
            if (n <= 127) {
                this.length = n + 1;
                int n2 = 0;
                while (n2 < this.length) {
                    int n3 = this.in.read(this.buffer, n2, this.length - n2);
                    if (n3 == -1) {
                        this.length = n2;
                        continue;
                    }
                    n2 += n3;
                }
            } else {
                this.length = 257 - n;
                int n4 = this.in.read();
                if (n4 == -1) {
                    this.length = 0;
                }
                int n5 = 0;
                while (n5 < this.length) {
                    this.buffer[n5++] = (byte)n4;
                }
            }
            return this.read();
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.read();
        if (n3 == -1) {
            return -1;
        }
        byArray[n] = (byte)n3;
        int n4 = 1;
        try {
            while (n4 < n2) {
                n3 = this.read();
                if (n3 != -1) {
                    if (byArray != null) {
                        byArray[n + n4] = (byte)n3;
                    }
                    ++n4;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return n4;
    }

    public synchronized void reset() throws IOException {
        throw new IOException("method not supported");
    }

    public long skip(long l) throws IOException {
        throw new IOException("method not supported");
    }
}

