/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSInterpreter;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSWarning;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;
import java.util.Iterator;
import java.util.Map;

public class CSDeviceBasedInterpreter
extends CSInterpreter {
    protected ICSDevice device;
    private int nesting = 0;
    private float fontSize = 0.0f;
    private float horizontalScalingFactor = 1.0f;
    private float advanceFactor = 0.0f;

    public CSDeviceBasedInterpreter(Map map, ICSDevice iCSDevice) {
        super(map);
        this.device = iCSDevice;
    }

    public ICSDevice getDevice() {
        return this.device;
    }

    protected PDColorSpace lookupColorSpace(COSName cOSName) {
        PDColorSpace pDColorSpace = PDColorSpace.getNamed(cOSName);
        if (pDColorSpace == null) {
            if (this.getResources() == null) {
                throw new IllegalStateException("resource dictionary missing");
            }
            return this.getResources().getColorSpaceResource(cOSName);
        }
        return pDColorSpace;
    }

    protected PDExtGState lookupExtGState(COSName cOSName) {
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().getExtGStateResource(cOSName);
    }

    protected PDPattern lookupPattern(COSName cOSName) {
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().getPatternResource(cOSName);
    }

    protected COSDictionary lookupProperties(COSName cOSName) {
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().cosGetResource(PDResources.CN_RT_Properties, cOSName).asDictionary();
    }

    protected PDShading lookupShading(COSName cOSName) {
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().getShadingResource(cOSName);
    }

    protected PDXObject lookupXObject(COSName cOSName) {
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        return this.getResources().getXObjectResource(cOSName);
    }

    public void process(CSContent cSContent, PDResources pDResources) throws CSException {
        try {
            if (this.nesting == 0) {
                this.device.open(this);
            }
            ++this.nesting;
            super.process(cSContent, pDResources);
        }
        finally {
            --this.nesting;
            if (this.nesting == 0) {
                this.device.close();
            }
        }
    }

    protected void render_b(CSOperation cSOperation) {
        try {
            this.device.pathCloseFillStrokeNonZero();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_B(CSOperation cSOperation) {
        try {
            this.device.pathFillStrokeNonZero();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_BDC(CSOperation cSOperation) throws CSException {
        COSDictionary cOSDictionary;
        COSName cOSName;
        COSName cOSName2 = ((COSName)cSOperation.getOperand(0)).asName();
        COSObject cOSObject = cSOperation.getOperand(1);
        if (cOSObject instanceof COSName) {
            cOSName = (COSName)cOSObject;
            cOSDictionary = this.lookupProperties(cOSName);
        } else {
            cOSName = null;
            cOSDictionary = (COSDictionary)cOSObject;
        }
        this.device.markedContentBeginProperties(cOSName2, cOSName, cOSDictionary);
    }

    protected void render_BMC(CSOperation cSOperation) throws CSException {
        COSName cOSName = ((COSName)cSOperation.getOperand(0)).asName();
        this.device.markedContentBegin(cOSName);
    }

    protected void render_bstar(CSOperation cSOperation) {
        try {
            this.device.pathCloseFillStrokeEvenOdd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_Bstar(CSOperation cSOperation) {
        try {
            this.device.pathFillStrokeEvenOdd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_BT(CSOperation cSOperation) {
        this.frame.graphicsObjectState = 1;
        this.device.textBegin();
    }

    protected void render_c(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        float f2 = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        float f3 = ((COSNumber)cSOperation.getOperand(2)).floatValue();
        float f4 = ((COSNumber)cSOperation.getOperand(3)).floatValue();
        float f5 = ((COSNumber)cSOperation.getOperand(4)).floatValue();
        float f6 = ((COSNumber)cSOperation.getOperand(5)).floatValue();
        this.device.penCurveToC(f, f2, f3, f4, f5, f6);
    }

    protected void render_cm(CSOperation cSOperation) {
        if (this.frame.graphicsObjectState != 0) {
            throw new CSWarning("'cm' not allowed");
        }
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        float f2 = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        float f3 = ((COSNumber)cSOperation.getOperand(2)).floatValue();
        float f4 = ((COSNumber)cSOperation.getOperand(3)).floatValue();
        float f5 = ((COSNumber)cSOperation.getOperand(4)).floatValue();
        float f6 = ((COSNumber)cSOperation.getOperand(5)).floatValue();
        this.device.transform(f, f2, f3, f4, f5, f6);
    }

    protected void render_cs(CSOperation cSOperation) {
        COSName cOSName = cSOperation.getOperand(0).asName();
        PDColorSpace pDColorSpace = this.selectColorSpace(cOSName);
        this.device.setNonStrokeColorSpace(cOSName, pDColorSpace);
    }

    protected void render_CS(CSOperation cSOperation) {
        COSName cOSName = cSOperation.getOperand(0).asName();
        PDColorSpace pDColorSpace = this.selectColorSpace(cOSName);
        this.device.setStrokeColorSpace(cOSName, pDColorSpace);
    }

    protected void render_d(CSOperation cSOperation) {
        COSArray cOSArray = (COSArray)cSOperation.getOperand(0);
        float[] fArray = new float[cOSArray.size()];
        int n = 0;
        Iterator iterator = cOSArray.iterator();
        while (iterator.hasNext()) {
            COSNumber cOSNumber = ((COSObject)iterator.next()).asNumber();
            if (cOSNumber == null) continue;
            fArray[n] = cOSNumber.floatValue();
            ++n;
        }
        float f = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        this.device.setLineDash(fArray, f);
    }

    protected void render_Do(CSOperation cSOperation) throws CSException {
        COSName cOSName = (COSName)cSOperation.getOperand(0);
        PDXObject pDXObject = this.lookupXObject(cOSName);
        this.device.doXObject(cOSName, pDXObject);
    }

    protected void render_DoubleQuote(CSOperation cSOperation) throws CSException {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        this.device.textSetWordSpacing(f);
        float f2 = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        this.device.textSetCharSpacing(f2);
        this.device.textLineNew();
        byte[] byArray = ((COSString)cSOperation.getOperand(2)).byteValue();
        this.device.textShow(byArray, 0, byArray.length);
    }

    protected void render_DP(CSOperation cSOperation) throws CSException {
        COSDictionary cOSDictionary;
        COSName cOSName;
        COSName cOSName2 = ((COSName)cSOperation.getOperand(0)).asName();
        COSObject cOSObject = cSOperation.getOperand(1);
        if (cOSObject instanceof COSName) {
            cOSName = (COSName)cOSObject;
            cOSDictionary = this.lookupProperties(cOSName);
        } else {
            cOSName = null;
            cOSDictionary = (COSDictionary)cOSObject;
        }
        this.device.markedContentPointProperties(cOSName2, cOSName, cOSDictionary);
    }

    protected void render_EI(CSOperation cSOperation) throws CSException {
        this.frame.graphicsObjectState = 4;
        try {
            PDImage pDImage = (PDImage)cSOperation.getCache();
            if (pDImage == null) {
                PDColorSpace pDColorSpace;
                COSStream cOSStream = cSOperation.getOperand(0).asStream();
                pDImage = (PDImage)PDImage.META.createFromCos(cOSStream);
                COSObject cOSObject = pDImage.cosGetColorSpace();
                if (cOSObject instanceof COSName && this.getResources() != null && (pDColorSpace = this.getResources().getColorSpaceResource((COSName)cOSObject)) != null) {
                    pDImage.setColorSpace(pDColorSpace);
                }
                cSOperation.setCache(pDImage);
            }
            this.device.inlineImage(pDImage);
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_EMC(CSOperation cSOperation) throws CSException {
        this.device.markedContentEnd();
    }

    protected void render_ET(CSOperation cSOperation) {
        try {
            this.device.textEnd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_f(CSOperation cSOperation) {
        try {
            this.device.pathFillNonZero();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_F(CSOperation cSOperation) {
        try {
            this.device.pathFillNonZero();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_fstar(CSOperation cSOperation) {
        try {
            this.device.pathFillEvenOdd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_g(CSOperation cSOperation) {
        if (this.frame.defaultGray != null) {
            this.device.setNonStrokeColorSpace(PDColorSpace.CN_CS_DefaultGray, this.frame.defaultGray);
            float[] fArray = new float[]{((COSNumber)cSOperation.getOperand(0)).floatValue()};
            this.device.setNonStrokeColorValues(fArray);
        } else {
            this.device.setNonStrokeColorGray(((COSNumber)cSOperation.getOperand(0)).floatValue());
        }
    }

    protected void render_G(CSOperation cSOperation) {
        if (this.frame.defaultGray != null) {
            this.device.setStrokeColorSpace(PDColorSpace.CN_CS_DefaultGray, this.frame.defaultGray);
            float[] fArray = new float[]{((COSNumber)cSOperation.getOperand(0)).floatValue()};
            this.device.setStrokeColorValues(fArray);
        } else {
            this.device.setStrokeColorGray(((COSNumber)cSOperation.getOperand(0)).floatValue());
        }
    }

    protected void render_gs(CSOperation cSOperation) {
        if (this.getResources() == null) {
            throw new IllegalStateException("resource dictionary missing");
        }
        COSName cOSName = cSOperation.getOperand(0).asName();
        PDExtGState pDExtGState = this.lookupExtGState(cOSName);
        this.device.setExtendedState(cOSName, pDExtGState);
    }

    protected void render_h(CSOperation cSOperation) {
        this.device.pathClose();
    }

    protected void render_i(CSOperation cSOperation) throws CSException {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        this.device.setFlatnessTolerance(f);
    }

    protected void render_j(CSOperation cSOperation) {
        int n = ((COSNumber)cSOperation.getOperand(0)).intValue();
        this.device.setLineJoin(n);
    }

    protected void render_J(CSOperation cSOperation) {
        int n = ((COSNumber)cSOperation.getOperand(0)).intValue();
        this.device.setLineCap(n);
    }

    protected void render_k(CSOperation cSOperation) {
        if (this.frame.defaultCMYK != null) {
            this.device.setNonStrokeColorSpace(PDColorSpace.CN_CS_DefaultCMYK, this.frame.defaultCMYK);
            float[] fArray = new float[]{((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue(), ((COSNumber)cSOperation.getOperand(2)).floatValue(), ((COSNumber)cSOperation.getOperand(3)).floatValue()};
            this.device.setNonStrokeColorValues(fArray);
        } else {
            this.device.setNonStrokeColorCMYK(((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue(), ((COSNumber)cSOperation.getOperand(2)).floatValue(), ((COSNumber)cSOperation.getOperand(3)).floatValue());
        }
    }

    protected void render_K(CSOperation cSOperation) {
        if (this.frame.defaultCMYK != null) {
            this.device.setStrokeColorSpace(PDColorSpace.CN_CS_DefaultCMYK, this.frame.defaultCMYK);
            float[] fArray = new float[]{((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue(), ((COSNumber)cSOperation.getOperand(2)).floatValue(), ((COSNumber)cSOperation.getOperand(3)).floatValue()};
            this.device.setStrokeColorValues(fArray);
        } else {
            this.device.setStrokeColorCMYK(((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue(), ((COSNumber)cSOperation.getOperand(2)).floatValue(), ((COSNumber)cSOperation.getOperand(3)).floatValue());
        }
    }

    protected void render_l(CSOperation cSOperation) {
        this.device.penLineTo(((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue());
    }

    protected void render_m(CSOperation cSOperation) {
        this.frame.graphicsObjectState = 6;
        this.device.penMoveTo(((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue());
    }

    protected void render_M(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        this.device.setMiterLimit(f);
    }

    protected void render_MP(CSOperation cSOperation) throws CSException {
        COSName cOSName = ((COSName)cSOperation.getOperand(0)).asName();
        this.device.markedContentPoint(cOSName);
    }

    protected void render_n(CSOperation cSOperation) {
        try {
            this.device.pathEnd();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_q(CSOperation cSOperation) throws CSException {
        if (this.frame.graphicsObjectState != 0) {
            throw new CSWarning("'q' not allowed");
        }
        this.device.saveState();
    }

    protected void render_Q(CSOperation cSOperation) throws CSException {
        if (this.frame.graphicsObjectState != 0) {
            throw new CSWarning("'Q' not allowed");
        }
        this.device.restoreState();
    }

    protected void render_Quote(CSOperation cSOperation) throws CSException {
        this.device.textLineNew();
        byte[] byArray = ((COSString)cSOperation.getOperand(0)).byteValue();
        this.device.textShow(byArray, 0, byArray.length);
    }

    protected void render_re(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        float f2 = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        float f3 = ((COSNumber)cSOperation.getOperand(2)).floatValue();
        float f4 = ((COSNumber)cSOperation.getOperand(3)).floatValue();
        this.device.penRectangle(f, f2, f3, f4);
    }

    protected void render_rg(CSOperation cSOperation) {
        if (this.frame.defaultRGB != null) {
            this.device.setNonStrokeColorSpace(PDColorSpace.CN_CS_DefaultRGB, this.frame.defaultRGB);
            float[] fArray = new float[]{((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue(), ((COSNumber)cSOperation.getOperand(2)).floatValue()};
            this.device.setNonStrokeColorValues(fArray);
        } else {
            this.device.setNonStrokeColorRGB(((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue(), ((COSNumber)cSOperation.getOperand(2)).floatValue());
        }
    }

    protected void render_RG(CSOperation cSOperation) {
        if (this.frame.defaultRGB != null) {
            this.device.setStrokeColorSpace(PDColorSpace.CN_CS_DefaultRGB, this.frame.defaultRGB);
            float[] fArray = new float[]{((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue(), ((COSNumber)cSOperation.getOperand(2)).floatValue()};
            this.device.setStrokeColorValues(fArray);
        } else {
            this.device.setStrokeColorRGB(((COSNumber)cSOperation.getOperand(0)).floatValue(), ((COSNumber)cSOperation.getOperand(1)).floatValue(), ((COSNumber)cSOperation.getOperand(2)).floatValue());
        }
    }

    protected void render_ri(CSOperation cSOperation) throws CSException {
        COSName cOSName = ((COSName)cSOperation.getOperand(0)).asName();
        this.device.setRenderingIntent(cOSName);
    }

    protected void render_s(CSOperation cSOperation) {
        try {
            this.device.pathCloseStroke();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_S(CSOperation cSOperation) {
        try {
            this.device.pathStroke();
        }
        finally {
            this.frame.graphicsObjectState = 0;
        }
    }

    protected void render_sc(CSOperation cSOperation) {
        int n = cSOperation.operandSize();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = ((COSNumber)cSOperation.getOperand(n2)).floatValue();
            ++n2;
        }
        this.device.setNonStrokeColorValues(fArray);
    }

    protected void render_SC(CSOperation cSOperation) {
        int n = cSOperation.operandSize();
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = ((COSNumber)cSOperation.getOperand(n2)).floatValue();
            ++n2;
        }
        this.device.setStrokeColorValues(fArray);
    }

    protected void render_scn(CSOperation cSOperation) {
        int n;
        int n2 = n = cSOperation.operandSize();
        COSName cOSName = null;
        if (n > 0 && cSOperation.getOperand(n - 1) instanceof COSName) {
            cOSName = (COSName)cSOperation.getOperand(n - 1);
            --n2;
        }
        float[] fArray = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3] = ((COSNumber)cSOperation.getOperand(n3)).floatValue();
            ++n3;
        }
        if (cOSName == null) {
            this.device.setNonStrokeColorValues(fArray);
        } else {
            PDPattern pDPattern = this.lookupPattern(cOSName);
            this.device.setNonStrokeColorValues(fArray, cOSName, pDPattern);
        }
    }

    protected void render_SCN(CSOperation cSOperation) {
        int n;
        int n2 = n = cSOperation.operandSize();
        COSName cOSName = null;
        if (n > 0 && cSOperation.getOperand(n - 1) instanceof COSName) {
            cOSName = (COSName)cSOperation.getOperand(n - 1);
            --n2;
        }
        float[] fArray = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            fArray[n3] = ((COSNumber)cSOperation.getOperand(n3)).floatValue();
            ++n3;
        }
        if (cOSName == null) {
            this.device.setStrokeColorValues(fArray);
        } else {
            PDPattern pDPattern = this.lookupPattern(cOSName);
            this.device.setStrokeColorValues(fArray, cOSName, pDPattern);
        }
    }

    protected void render_sh(CSOperation cSOperation) {
        COSName cOSName = cSOperation.getOperand(0).asName();
        PDShading pDShading = this.lookupShading(cOSName);
        this.device.doShading(cOSName, pDShading);
    }

    protected void render_Tc(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        this.device.textSetCharSpacing(f);
    }

    protected void render_Td(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        float f2 = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        this.device.textLineMove(f, f2);
    }

    protected void render_TD(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        float f2 = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        this.device.textSetLeading(f2);
        this.device.textLineMove(f, f2);
    }

    protected void render_Tf(CSOperation cSOperation) throws CSWarning {
        COSName cOSName = cSOperation.getOperand(0).asName();
        float f = cSOperation.getOperand(1).asNumber().floatValue();
        PDFont pDFont = PDFontTools.getFont(this.getDoc(), this.getResources(), cOSName);
        this.fontSize = f;
        this.advanceFactor = -1.0f * this.horizontalScalingFactor * this.fontSize / 1000.0f;
        this.device.textSetFont(cOSName, pDFont, f);
    }

    protected void render_Tj(CSOperation cSOperation) throws CSException {
        byte[] byArray = ((COSString)cSOperation.getOperand(0)).byteValue();
        this.device.textShow(byArray, 0, byArray.length);
    }

    protected void render_TJ(CSOperation cSOperation) throws CSException {
        COSDocumentElement[] cOSDocumentElementArray = cSOperation.getOperand(0).asArray().toArray();
        int n = cOSDocumentElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            COSObject cOSObject = (COSObject)cOSDocumentElementArray[n2];
            if (cOSObject instanceof COSNumber) {
                float f = ((COSNumber)cOSObject).floatValue();
                this.device.textMove(f * this.advanceFactor, 0.0f);
            } else if (cOSObject instanceof COSString) {
                byte[] byArray = ((COSString)cOSObject).byteValue();
                this.device.textShow(byArray, 0, byArray.length);
            }
            ++n2;
        }
    }

    protected void render_TL(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        this.device.textSetLeading(-f);
    }

    protected void render_Tm(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        float f2 = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        float f3 = ((COSNumber)cSOperation.getOperand(2)).floatValue();
        float f4 = ((COSNumber)cSOperation.getOperand(3)).floatValue();
        float f5 = ((COSNumber)cSOperation.getOperand(4)).floatValue();
        float f6 = ((COSNumber)cSOperation.getOperand(5)).floatValue();
        this.device.textSetTransform(f, f2, f3, f4, f5, f6);
    }

    protected void render_Tr(CSOperation cSOperation) {
        int n = ((COSNumber)cSOperation.getOperand(0)).intValue();
        this.device.textSetRenderingMode(n);
    }

    protected void render_Ts(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        this.device.textSetRise(f);
    }

    protected void render_Tstar(CSOperation cSOperation) {
        this.device.textLineNew();
    }

    protected void render_Tw(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        this.device.textSetWordSpacing(f);
    }

    protected void render_Tz(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        this.horizontalScalingFactor = f / 100.0f;
        this.advanceFactor = -1.0f * this.horizontalScalingFactor * this.fontSize / 1000.0f;
        this.device.textSetHorizontalScaling(f);
    }

    protected void render_v(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        float f2 = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        float f3 = ((COSNumber)cSOperation.getOperand(2)).floatValue();
        float f4 = ((COSNumber)cSOperation.getOperand(3)).floatValue();
        this.device.penCurveToV(f, f2, f3, f4);
    }

    protected void render_w(CSOperation cSOperation) {
        this.device.setLineWidth(((COSNumber)cSOperation.getOperand(0)).floatValue());
    }

    protected void render_W(CSOperation cSOperation) {
        this.frame.graphicsObjectState = 5;
        this.device.pathClipNonZero();
    }

    protected void render_Wstar(CSOperation cSOperation) {
        this.frame.graphicsObjectState = 5;
        this.device.pathClipEvenOdd();
    }

    protected void render_y(CSOperation cSOperation) {
        float f = ((COSNumber)cSOperation.getOperand(0)).floatValue();
        float f2 = ((COSNumber)cSOperation.getOperand(1)).floatValue();
        float f3 = ((COSNumber)cSOperation.getOperand(2)).floatValue();
        float f4 = ((COSNumber)cSOperation.getOperand(3)).floatValue();
        this.device.penCurveToY(f, f2, f3, f4);
    }

    protected PDColorSpace selectColorSpace(COSName cOSName) {
        PDColorSpace pDColorSpace = null;
        if (PDColorSpace.CN_CS_DeviceCMYK.equals(cOSName)) {
            pDColorSpace = this.frame.defaultCMYK;
        } else if (PDColorSpace.CN_CS_DeviceRGB.equals(cOSName)) {
            pDColorSpace = this.frame.defaultRGB;
        } else if (PDColorSpace.CN_CS_DeviceGray.equals(cOSName)) {
            pDColorSpace = this.frame.defaultGray;
        }
        if (pDColorSpace == null) {
            return this.lookupColorSpace(cOSName);
        }
        return pDColorSpace;
    }
}

