/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.geometry;

import de.intarsys.tools.geometry.TransformedShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

public class ApplySpaceChangeShape
extends TransformedShape {
    private final AffineTransform targetTransform;
    private final AffineTransform sourceTransform;

    public static TransformedShape create(Shape shape, AffineTransform affineTransform) {
        ApplySpaceChangeShape applySpaceChangeShape;
        if (shape instanceof ApplySpaceChangeShape && (applySpaceChangeShape = (ApplySpaceChangeShape)shape).getTargetTransform().equals(affineTransform)) {
            return ApplySpaceChangeShape.create(applySpaceChangeShape.getBaseShape(), applySpaceChangeShape.getSourceTransform(), affineTransform);
        }
        return ApplySpaceChangeShape.create(shape, (AffineTransform)affineTransform.clone(), affineTransform);
    }

    public static TransformedShape create(Shape shape, AffineTransform affineTransform, AffineTransform affineTransform2) {
        return new ApplySpaceChangeShape(shape, affineTransform, affineTransform2);
    }

    public static TransformedShape setTransform(Shape shape, AffineTransform affineTransform) {
        if (shape instanceof ApplySpaceChangeShape) {
            ApplySpaceChangeShape applySpaceChangeShape = (ApplySpaceChangeShape)shape;
            return new ApplySpaceChangeShape(applySpaceChangeShape.getBaseShape(), applySpaceChangeShape.getSourceTransform(), affineTransform);
        }
        return new ApplySpaceChangeShape(shape, IDENTITY, affineTransform);
    }

    protected ApplySpaceChangeShape(ApplySpaceChangeShape applySpaceChangeShape) {
        super(applySpaceChangeShape);
        this.sourceTransform = applySpaceChangeShape.sourceTransform;
        this.targetTransform = (AffineTransform)applySpaceChangeShape.targetTransform.clone();
    }

    protected ApplySpaceChangeShape(Shape shape, AffineTransform affineTransform, AffineTransform affineTransform2) {
        super(shape);
        this.sourceTransform = affineTransform;
        this.targetTransform = affineTransform2;
    }

    protected Shape apply() {
        AffineTransform affineTransform = this.getTransform();
        if (affineTransform == null) {
            return null;
        }
        return affineTransform.createTransformedShape(this.getBaseShape());
    }

    public Object clone() {
        return new ApplySpaceChangeShape(this);
    }

    public AffineTransform getSourceTransform() {
        return this.sourceTransform;
    }

    public AffineTransform getTargetTransform() {
        return this.targetTransform;
    }

    public AffineTransform getTransform() {
        try {
            AffineTransform affineTransform = this.targetTransform.createInverse();
            affineTransform.concatenate(this.sourceTransform);
            return affineTransform;
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
    }
}

