/*
 * Decompiled with CFR 0.152.
 */
package bibtex;

import bibtex.dom.BibtexFile;
import bibtex.expansions.AbstractExpander;
import bibtex.expansions.CrossReferenceExpander;
import bibtex.expansions.MacroReferenceExpander;
import bibtex.expansions.PersonListExpander;
import bibtex.parser.BibtexParser;
import java.io.FileReader;
import java.io.PrintWriter;

public final class Main {
    public static void usage() {
        System.err.println("\nUsage: bibtex.Main [-expandStringDefinitions]\n         [-expandAndDropMacroDefinitions] [-expandCrossReferences]\n         [-expandPersonLists] [-noOutput] <file.bib>\n\nNote: Selecting -expandCrossReferences implies that we will\n      expand the string definitions as well (for consistency).\n\nNote: Selecting -expandPersonLists implies that we will expand\n      the string definitions as well (for consistency).\nThe output will be given on stdout, errors and messages will be printed to stderr.\n\n");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        boolean noOutput;
        BibtexFile bibtexFile;
        block21: {
            Object var9_11;
            if (args.length < 1) {
                Main.usage();
                return;
            }
            bibtexFile = new BibtexFile();
            BibtexParser parser = new BibtexParser(false);
            boolean expandMacros = false;
            boolean dropMacros = false;
            boolean expandCrossrefs = false;
            boolean expandPersonLists = false;
            noOutput = false;
            int argsIndex = 0;
            while (argsIndex < args.length - 1) {
                String argument = args[argsIndex];
                if (argument.equals("-expandStringDefinitions")) {
                    expandMacros = true;
                } else if (argument.equals("-expandAndDropStringDefinitions")) {
                    dropMacros = true;
                    expandMacros = true;
                } else if (argument.equals("-expandCrossReferences")) {
                    expandMacros = true;
                    expandCrossrefs = true;
                } else if (argument.equals("-expandPersonLists")) {
                    expandMacros = true;
                    expandPersonLists = true;
                } else if (argument.equals("-noOutput")) {
                    noOutput = true;
                } else {
                    System.err.println("Illegal argument: " + argument);
                    Main.usage();
                }
                ++argsIndex;
            }
            try {
                try {
                    String filename = args[args.length - 1];
                    System.err.println("Parsing \"" + filename + "\" ... ");
                    parser.parse(bibtexFile, new FileReader(args[args.length - 1]));
                }
                catch (Exception e) {
                    System.err.println("Fatal exception: ");
                    e.printStackTrace();
                    var9_11 = null;
                    Main.printNonFatalExceptions(parser.getExceptions());
                    return;
                }
                var9_11 = null;
            }
            catch (Throwable throwable) {
                var9_11 = null;
                Main.printNonFatalExceptions(parser.getExceptions());
                throw throwable;
            }
            Main.printNonFatalExceptions(parser.getExceptions());
            {
                AbstractExpander expander;
                if (expandMacros) {
                    System.err.println("\n\nExpanding macros ...");
                    expander = new MacroReferenceExpander(true, true, dropMacros, false);
                    ((MacroReferenceExpander)expander).expand(bibtexFile);
                    Main.printNonFatalExceptions(expander.getExceptions());
                }
                if (expandCrossrefs) {
                    System.err.println("\n\nExpanding crossrefs ...");
                    expander = new CrossReferenceExpander(false);
                    ((CrossReferenceExpander)expander).expand(bibtexFile);
                    Main.printNonFatalExceptions(expander.getExceptions());
                }
                if (!expandPersonLists) break block21;
                System.err.println("\n\nExpanding person lists ...");
                expander = new PersonListExpander(true, true, false);
                ((PersonListExpander)expander).expand(bibtexFile);
                Main.printNonFatalExceptions(expander.getExceptions());
            }
        }
        if (noOutput) {
            return;
        }
        System.err.println("\n\nGenerating output ...");
        PrintWriter out = new PrintWriter(System.out);
        bibtexFile.printBibtex(out);
        out.flush();
    }

    private static void printNonFatalExceptions(Exception[] exceptions) {
        if (exceptions.length > 0) {
            System.err.println("Non-fatal exceptions: ");
            int i = 0;
            while (i < exceptions.length) {
                exceptions[i].printStackTrace();
                System.err.println("===================");
                ++i;
            }
        }
    }
}

