/*
 * Decompiled with CFR 0.152.
 */
package splmm.Preferences;

import splmm.Gui.Preferences;
import splmm.Preferences.SplmmPreferences;

public class UserDataState {
    public static final int UNDEFINED_USER_DATA = 0;
    public static final int SPLMM_USER_DATA_NEEDED = 1;
    public static final int UNIQUE_USER_DATA_NEEDED = 2;
    public static final int ANONYMOUS_USER_DATA_NEEDED = 3;
    private int currentState;
    private int newState;
    private Preferences preferences;

    public UserDataState(Preferences preferences) {
        this.preferences = preferences;
        this.currentState = this.createCurrentState();
        this.newState = this.createNewState();
    }

    private int createNewState() {
        if (this.preferences.getBackupCheckBox().isSelected()) {
            return 1;
        }
        if (this.preferences.getUsageMiningCheckBox().isSelected() || this.preferences.getIronldCheckBox().isSelected() || this.preferences.getIronmmCheckBox().isSelected()) {
            return 2;
        }
        return 3;
    }

    private int createCurrentState() {
        if (SplmmPreferences.getUserName() == null || SplmmPreferences.getUserName().isEmpty()) {
            return 0;
        }
        if (SplmmPreferences.getAllowBackup().booleanValue()) {
            return 1;
        }
        if (SplmmPreferences.getAllowUsageMining().booleanValue() || SplmmPreferences.getAllowIRonLD().booleanValue() || SplmmPreferences.getAllowIRonMM().booleanValue()) {
            return 2;
        }
        return 3;
    }

    private static int createStaticCurrentState() {
        if (SplmmPreferences.getUserName() == null || SplmmPreferences.getUserName().isEmpty()) {
            return 0;
        }
        if (SplmmPreferences.getAllowBackup().booleanValue()) {
            return 1;
        }
        if (SplmmPreferences.getAllowUsageMining().booleanValue() || SplmmPreferences.getAllowIRonLD().booleanValue() || SplmmPreferences.getAllowIRonMM().booleanValue()) {
            return 2;
        }
        return 3;
    }

    public Boolean isUserDataUpdateNeeded() {
        if (this.newState != this.currentState) {
            return true;
        }
        if (this.newState == 1 && this.isSplmmUserDataChanged()) {
            return true;
        }
        return false;
    }

    private boolean isSplmmUserDataChanged() {
        return String.valueOf(this.preferences.getBackupPasswordField().getPassword()).compareTo(SplmmPreferences.getPassword()) != 0 || this.preferences.getUserNameTextField().getText().compareTo(SplmmPreferences.getUserName()) != 0;
    }

    public int getNewState() {
        return this.newState;
    }

    public static int getCurrentState() {
        return UserDataState.createStaticCurrentState();
    }
}

