/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STStreamXRefSection;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.IOException;

public class XRefStreamWriter
extends AbstractXRefWriter {
    public static byte[] TYPE_FREE = new byte[1];
    public static byte[] TYPE_OCCUPIED = new byte[]{1};
    public static byte[] TYPE_COMPRESSED = new byte[]{2};
    private int[] wSize;

    public XRefStreamWriter(COSWriter cOSWriter) {
        super(cOSWriter);
    }

    private int byteSizeOf(int n) {
        int n2 = -16777216;
        int n3 = 4;
        while (n3 > 0) {
            if ((n & n2) != 0) {
                return n3;
            }
            n2 >>= 8;
            --n3;
        }
        return 0;
    }

    protected void finish(STXRefSection sTXRefSection) throws IOException {
        byte[] byArray = ((RandomAccessByteArray)this.getRandomAccess()).toByteArray();
        ((STStreamXRefSection)sTXRefSection).cosGetStream().setDecodedBytes(byArray);
        this.getCosWriter().writeIndirectObject(((STStreamXRefSection)sTXRefSection).cosGetStream().getIndirectObject());
        super.finish(sTXRefSection);
    }

    protected byte[] getTypeCompressed() {
        return TYPE_COMPRESSED;
    }

    protected byte[] getTypeFree() {
        return TYPE_FREE;
    }

    protected byte[] getTypeOccupied() {
        return TYPE_OCCUPIED;
    }

    protected void initialize(STXRefSection sTXRefSection) throws IOException {
        super.initialize(sTXRefSection);
        STStreamXRefSection sTStreamXRefSection = (STStreamXRefSection)sTXRefSection;
        this.setRandomAccess((IRandomAccess)new RandomAccessByteArray(null));
        this.initWSize(sTStreamXRefSection);
        sTStreamXRefSection.setIndex(COSArray.create());
        COSIndirectObject cOSIndirectObject = sTStreamXRefSection.cosGetStream().getIndirectObject();
        int n = cOSIndirectObject.getObjectNumber();
        int n2 = cOSIndirectObject.getGenerationNumber();
        if (n == -1) {
            int n3;
            n = n3 = sTStreamXRefSection.getSize();
            n2 = 0;
            sTStreamXRefSection.cosGetStream().getIndirectObject().setKey(n, n2);
            sTStreamXRefSection.setSize(n3 + 1);
        }
        sTXRefSection.addEntry(new STXRefEntryOccupied(n, n2, sTXRefSection.getOffset()));
    }

    private void initWSize(STXRefSection sTXRefSection) {
        SearchVisitor searchVisitor = new SearchVisitor();
        Object object = sTXRefSection.entryIterator();
        while (object.hasNext()) {
            STXRefEntry sTXRefEntry = (STXRefEntry)object.next();
            try {
                sTXRefEntry.accept(searchVisitor);
            }
            catch (XRefEntryVisitorException xRefEntryVisitorException) {}
        }
        this.wSize = new int[3];
        this.wSize[0] = 1;
        this.wSize[1] = this.byteSizeOf((int)searchVisitor.getHighestOffset());
        this.wSize[2] = this.byteSizeOf(searchVisitor.getHighestGeneration());
        object = COSArray.create(3);
        int n = 0;
        while (n < 3) {
            ((COSArray)object).add(COSInteger.create(this.wSize[n]));
            ++n;
        }
        ((STStreamXRefSection)sTXRefSection).setW((COSArray)object);
    }

    protected void visitFromSubsection(STXRefSubsection sTXRefSubsection) {
        COSArray cOSArray = ((STStreamXRefSection)sTXRefSubsection.getXRefSection()).getIndex();
        cOSArray.add(COSInteger.create(sTXRefSubsection.getStart()));
        cOSArray.add(COSInteger.create(sTXRefSubsection.getSize()));
    }

    private void write(int n, int n2) throws IOException {
        switch (n2) {
            case 4: {
                this.getRandomAccess().write((n & 0xFF000000) >> 24);
            }
            case 3: {
                this.getRandomAccess().write((n & 0xFF0000) >> 16);
            }
            case 2: {
                this.getRandomAccess().write((n & 0xFF00) >> 8);
            }
            case 1: {
                this.getRandomAccess().write(n & 0xFF);
            }
        }
    }

    protected void write(int n, int n2, byte[] byArray) throws IOException {
        this.getRandomAccess().write(byArray);
        this.write(n, this.wSize[1]);
        this.write(n2, this.wSize[2]);
    }

    class SearchVisitor
    implements IXRefEntryVisitor {
        private long highestOffset = 0L;
        private int highestGeneration = 0;

        SearchVisitor() {
        }

        private void checkGeneration(int n) {
            if (n > this.highestGeneration) {
                this.highestGeneration = n;
            }
        }

        private void checkOffset(long l) {
            if (l > this.highestOffset) {
                this.highestOffset = l;
            }
        }

        public int getHighestGeneration() {
            return this.highestGeneration;
        }

        public long getHighestOffset() {
            return this.highestOffset;
        }

        public void visitFromCompressed(STXRefEntryCompressed sTXRefEntryCompressed) {
            this.checkOffset(sTXRefEntryCompressed.getStreamObjectNumber());
            this.checkGeneration(sTXRefEntryCompressed.getIndex());
        }

        public void visitFromFree(STXRefEntryFree sTXRefEntryFree) {
            this.checkOffset(sTXRefEntryFree.getNextFreeObjectNumber());
            this.checkGeneration(sTXRefEntryFree.getGenerationNumber());
        }

        public void visitFromOccupied(STXRefEntryOccupied sTXRefEntryOccupied) {
            this.checkOffset(sTXRefEntryOccupied.getOffset());
            this.checkGeneration(sTXRefEntryOccupied.getGenerationNumber());
        }
    }
}

