/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.filter.ASCII85Filter;
import de.intarsys.pdf.filter.ASCIIHexFilter;
import de.intarsys.pdf.filter.CCITTFaxFilter;
import de.intarsys.pdf.filter.CryptFilter;
import de.intarsys.pdf.filter.DCTFilter;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.filter.FlateFilter;
import de.intarsys.pdf.filter.IFilter;
import de.intarsys.pdf.filter.IFilterFactory;
import de.intarsys.pdf.filter.JBIG2Filter;
import de.intarsys.pdf.filter.JPXFilter;
import de.intarsys.pdf.filter.LZWFilter;
import de.intarsys.pdf.filter.RunLengthFilter;
import java.io.IOException;

public class StandardFilterFactory
implements IFilterFactory {
    public IFilter createFilter(COSName cOSName, COSDictionary cOSDictionary) throws IOException {
        Filter filter = null;
        if (cOSName.equals(Filter.CN_Filter_FlateDecode)) {
            filter = new FlateFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_Fl)) {
            filter = new FlateFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_ASCIIHexDecode)) {
            filter = new ASCIIHexFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_AHx)) {
            filter = new ASCIIHexFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_ASCII85Decode)) {
            filter = new ASCII85Filter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_A85)) {
            filter = new ASCII85Filter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_LZWDecode)) {
            filter = new LZWFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_LZW)) {
            filter = new LZWFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_RunLengthDecode)) {
            filter = new RunLengthFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_RL)) {
            filter = new RunLengthFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_CCITTFaxDecode)) {
            filter = new CCITTFaxFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_CCF)) {
            filter = new CCITTFaxFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_JBIG2Decode)) {
            filter = new JBIG2Filter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_DCTDecode)) {
            filter = new DCTFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_DCT)) {
            filter = new DCTFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_JPXDecode)) {
            filter = new JPXFilter(cOSDictionary);
        } else if (cOSName.equals(Filter.CN_Filter_Crypt)) {
            filter = new CryptFilter(cOSDictionary);
        }
        if (filter == null) {
            throw new IOException("unknown filter:" + cOSName);
        }
        return filter;
    }
}

