/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content.common;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSWarning;
import de.intarsys.pdf.content.ICSExceptionHandler;
import de.intarsys.pdf.content.common.CSBoundingBoxCollector;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDResources;
import java.awt.geom.Rectangle2D;

public class CSContentTools {
    private static final ICSExceptionHandler ignoreExceptionHandler = new ICSExceptionHandler(){

        public void error(CSError cSError) throws CSException {
        }

        public void warning(CSWarning cSWarning) throws CSException {
        }
    };

    public static Rectangle2D getBoundingBoxClipped(PDPage pDPage, double d) {
        CSBoundingBoxCollector cSBoundingBoxCollector = new CSBoundingBoxCollector();
        CSDeviceBasedInterpreter cSDeviceBasedInterpreter = new CSDeviceBasedInterpreter(null, cSBoundingBoxCollector);
        cSDeviceBasedInterpreter.setExceptionHandler(ignoreExceptionHandler);
        CSContent cSContent = pDPage.getContentStream();
        cSDeviceBasedInterpreter.process(cSContent, pDPage.getResources());
        if (cSBoundingBoxCollector.getBoundingBox() != null) {
            return cSBoundingBoxCollector.getBoundingBox();
        }
        return pDPage.getCropBox().toNormalizedRectangle();
    }

    public static PDForm getFormClipped(PDPage pDPage, double d) {
        COSBasedObject cOSBasedObject;
        Object object;
        PDForm pDForm = (PDForm)PDForm.META.createNew();
        CSContent cSContent = pDPage.getContentStream();
        if (cSContent == null) {
            pDForm.setBytes(new byte[0]);
        } else {
            pDForm.setBytes(cSContent.toByteArray());
        }
        if (pDPage.getResources() != null) {
            object = pDPage.getResources().cosGetObject().copyDeep();
            cOSBasedObject = (PDResources)PDResources.META.createFromCos((COSObject)object);
            pDForm.setResources((PDResources)cOSBasedObject);
        }
        object = CSContentTools.getBoundingBoxClipped(pDPage, d);
        cOSBasedObject = new CDSRectangle((Rectangle2D)object);
        pDForm.setBoundingBox((CDSRectangle)cOSBasedObject);
        CDSMatrix cDSMatrix = new CDSMatrix();
        cDSMatrix.translate(-((CDSRectangle)cOSBasedObject).getLowerLeftX(), -((CDSRectangle)cOSBasedObject).getLowerLeftY());
        pDForm.setMatrix(cDSMatrix);
        return pDForm;
    }
}

