/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSLiteral;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.CSContentParser;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import java.io.IOException;

public class CSContent {
    private CSOperation[] operations = new CSOperation[100];
    private int size = 0;

    protected CSContent() {
    }

    public static CSContent createFromBytes(byte[] byArray) {
        try {
            CSContentParser cSContentParser = new CSContentParser();
            return cSContentParser.parseStream(byArray);
        }
        catch (IOException iOException) {
            throw new COSRuntimeException(iOException);
        }
        catch (COSLoadException cOSLoadException) {
            throw new COSRuntimeException(cOSLoadException);
        }
    }

    public static CSContent createFromCos(COSStream cOSStream) {
        return CSContent.createFromBytes(cOSStream.getDecodedBytes());
    }

    public static CSContent createFromCos(COSArray cOSArray) {
        RandomAccessByteArray randomAccessByteArray = new RandomAccessByteArray(null);
        try {
            Object object = cOSArray.iterator();
            while (object.hasNext()) {
                COSStream cOSStream = ((COSObject)object.next()).asStream();
                if (cOSStream == null) continue;
                randomAccessByteArray.write(cOSStream.getDecodedBytes());
                randomAccessByteArray.write(32);
            }
            object = new CSContentParser();
            randomAccessByteArray.seek(0L);
            return ((CSContentParser)object).parseStream((IRandomAccess)randomAccessByteArray);
        }
        catch (IOException iOException) {
            throw new COSRuntimeException(iOException);
        }
        catch (COSLoadException cOSLoadException) {
            throw new COSRuntimeException(cOSLoadException);
        }
    }

    public static CSContent createNew() {
        CSContent cSContent = new CSContent();
        return cSContent;
    }

    public CSOperation getLastOperation() {
        if (this.size == 0) {
            return null;
        }
        return this.operations[this.size - 1];
    }

    public void setMarkedContent(COSName cOSName, byte[] byArray) {
        CSOperation cSOperation;
        int n = 0;
        while (n < this.size) {
            cSOperation = this.operations[n];
            if (cSOperation.isOpBeginMarkedContent(cOSName)) {
                ++n;
                break;
            }
            ++n;
        }
        if (n < this.size) {
            this.addOperation(n, new CSLiteral(byArray));
            int n2 = 0;
            ++n;
            while (n < this.size) {
                CSOperation cSOperation2 = this.operations[n];
                if (cSOperation2.isOpBeginMarkedContent(null)) {
                    ++n2;
                }
                if (cSOperation2.isOpEndMarkedContent()) {
                    if (n2 == 0) break;
                    --n2;
                }
                this.removeOperation(n);
            }
        } else {
            cSOperation = new CSOperation(CSOperators.CSO_BMC);
            cSOperation.addOperand(CSOperation.OPERAND_Tx);
            this.addOperation(cSOperation);
            this.addOperation(new CSLiteral(byArray));
            cSOperation = new CSOperation(CSOperators.CSO_EMC);
            this.addOperation(cSOperation);
        }
    }

    public void addMarkedContent(COSName cOSName, byte[] byArray) {
        CSOperation cSOperation;
        int n = 0;
        while (n < this.size) {
            cSOperation = this.operations[n];
            if (cSOperation.isOpBeginMarkedContent(cOSName)) {
                ++n;
                break;
            }
            ++n;
        }
        if (n < this.size) {
            int n2 = 0;
            ++n;
            while (n < this.size) {
                CSOperation cSOperation2 = this.operations[n];
                if (cSOperation2.isOpBeginMarkedContent(null)) {
                    ++n2;
                }
                if (cSOperation2.isOpEndMarkedContent()) {
                    if (n2 == 0) {
                        this.addOperation(n, new CSLiteral(byArray));
                        break;
                    }
                    --n2;
                }
                ++n;
            }
        } else {
            cSOperation = new CSOperation(CSOperators.CSO_BMC);
            cSOperation.addOperand(CSOperation.OPERAND_Tx);
            this.addOperation(cSOperation);
            this.addOperation(new CSLiteral(byArray));
            cSOperation = new CSOperation(CSOperators.CSO_EMC);
            this.addOperation(cSOperation);
        }
    }

    public void addOperation(CSOperation cSOperation) {
        if (this.size >= this.operations.length) {
            CSOperation[] cSOperationArray = new CSOperation[this.size * 2];
            System.arraycopy(this.operations, 0, cSOperationArray, 0, this.size);
            this.operations = cSOperationArray;
        }
        this.operations[this.size++] = cSOperation;
    }

    public void addOperation(int n, CSOperation cSOperation) {
        if (this.size >= this.operations.length) {
            CSOperation[] cSOperationArray = new CSOperation[this.size * 2];
            System.arraycopy(this.operations, 0, cSOperationArray, 0, this.size);
            this.operations = cSOperationArray;
        }
        System.arraycopy(this.operations, n, this.operations, n + 1, this.size - n);
        ++this.size;
        this.operations[n] = cSOperation;
    }

    public void removeOperation(int n) {
        System.arraycopy(this.operations, n + 1, this.operations, n, this.size - n - 1);
        --this.size;
    }

    public CSOperation[] getOperations() {
        CSOperation[] cSOperationArray = new CSOperation[this.size];
        System.arraycopy(this.operations, 0, cSOperationArray, 0, this.size());
        return cSOperationArray;
    }

    public CSOperation getOperation(int n) {
        return this.operations[n];
    }

    public COSStream createStream() {
        COSStream cOSStream = COSStream.create(null);
        cOSStream.setDecodedBytes(this.toByteArray());
        return cOSStream;
    }

    public void removeLastOperation() {
        this.removeOperation(this.size - 1);
    }

    public int size() {
        return this.size;
    }

    public byte[] toByteArray() {
        RandomAccessByteArray randomAccessByteArray = new RandomAccessByteArray(null);
        COSWriter cOSWriter = new COSWriter((IRandomAccess)randomAccessByteArray, null);
        try {
            cOSWriter.writeContentStream(this);
        }
        catch (IOException iOException) {}
        return randomAccessByteArray.toByteArray();
    }

    public String toString() {
        return new String(this.toByteArray());
    }
}

