/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cds;

import de.intarsys.pdf.cds.CDSBase;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSNumber;
import java.awt.geom.Rectangle2D;

public class CDSRectangle
extends CDSBase {
    private static final float INCH_2_CM = 2.54f;
    private static final float A4_WIDTH = 21.0f;
    private static final float A4_HEIGHT = 29.7f;
    private static final float DPI = 72.0f;
    public static final float[] SIZE_A4 = new float[]{0.0f, 0.0f, 595.2756f, 841.88983f};
    private Rectangle2D cachedRectangle;
    private Rectangle2D cachedNormalizedRectangle;

    public static CDSRectangle createFromCOS(COSArray cOSArray) {
        if (cOSArray == null) {
            return null;
        }
        CDSRectangle cDSRectangle = (CDSRectangle)cOSArray.getAttribute(CDSRectangle.class);
        if (cDSRectangle == null) {
            cDSRectangle = new CDSRectangle(cOSArray);
            cOSArray.setAttribute(CDSRectangle.class, cDSRectangle);
        }
        return cDSRectangle;
    }

    public CDSRectangle() {
        super(COSArray.createWith(0.0f, 0.0f, 0.0f, 0.0f));
    }

    protected CDSRectangle(COSArray cOSArray) {
        super(cOSArray);
    }

    public CDSRectangle(float f, float f2, float f3, float f4) {
        super(COSArray.createWith(f, f2, f3, f4));
    }

    public CDSRectangle(float[] fArray) {
        this(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public CDSRectangle(Rectangle2D rectangle2D) {
        super(COSArray.createWith((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY()));
    }

    public boolean contains(double d, double d2) {
        float f;
        float f2;
        COSArray cOSArray = this.cosGetArray();
        float f3 = ((COSNumber)cOSArray.get(0)).floatValue();
        if (f3 < (f2 = ((COSNumber)cOSArray.get(2)).floatValue()) ? d < (double)f3 || d > (double)f2 : d > (double)f3 || d < (double)f2) {
            return false;
        }
        float f4 = ((COSNumber)cOSArray.get(1)).floatValue();
        if (f4 < (f = ((COSNumber)cOSArray.get(3)).floatValue())) {
            return d2 >= (double)f4 && d2 <= (double)f;
        }
        return d2 >= (double)f && d2 <= (double)f4;
    }

    public boolean contains(double d, double d2, double d3) {
        float f;
        float f2;
        COSArray cOSArray = this.cosGetArray();
        float f3 = ((COSNumber)cOSArray.get(0)).floatValue();
        if (f3 < (f2 = ((COSNumber)cOSArray.get(2)).floatValue()) ? d < (double)f3 - d3 || d > (double)f2 + d3 : d > (double)f3 + d3 || d < (double)f2 - d3) {
            return false;
        }
        float f4 = ((COSNumber)cOSArray.get(1)).floatValue();
        if (f4 < (f = ((COSNumber)cOSArray.get(3)).floatValue())) {
            return d2 >= (double)f4 - d3 && d2 <= (double)f + d3;
        }
        return d2 >= (double)f - d3 && d2 <= (double)f4 + d3;
    }

    public CDSRectangle copy() {
        return new CDSRectangle((COSArray)this.cosGetArray().copyShallow());
    }

    public float getHeight() {
        return Math.abs(this.getUpperRightY() - this.getLowerLeftY());
    }

    public float getLowerLeftX() {
        return ((COSNumber)this.cosGetArray().get(0)).floatValue();
    }

    public float getLowerLeftY() {
        return ((COSNumber)this.cosGetArray().get(1)).floatValue();
    }

    public float getUpperRightX() {
        return ((COSNumber)this.cosGetArray().get(2)).floatValue();
    }

    public float getUpperRightY() {
        return ((COSNumber)this.cosGetArray().get(3)).floatValue();
    }

    public float getWidth() {
        return Math.abs(this.getUpperRightX() - this.getLowerLeftX());
    }

    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedNormalizedRectangle = null;
        this.cachedRectangle = null;
    }

    public void move(float f, float f2) {
        this.setLowerLeftX(this.getLowerLeftX() + f);
        this.setLowerLeftY(this.getLowerLeftY() + f2);
        this.setUpperRightX(this.getUpperRightX() + f);
        this.setUpperRightY(this.getUpperRightY() + f2);
    }

    public CDSRectangle moveTo(float f, float f2) {
        float f3 = this.getUpperRightX() - this.getLowerLeftX();
        float f4 = this.getUpperRightY() - this.getLowerLeftY();
        this.setLowerLeftX(f);
        this.setLowerLeftY(f2);
        this.setUpperRightX(f3 + f);
        this.setUpperRightY(f4 + f2);
        return this;
    }

    public CDSRectangle normalize() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5 = this.getLowerLeftX();
        float f6 = this.getUpperRightX();
        if (f4 > f3) {
            this.setLowerLeftX(f6);
            this.setUpperRightX(f5);
        }
        f5 = this.getLowerLeftY();
        f6 = this.getUpperRightY();
        if (f2 > f) {
            this.setLowerLeftY(f6);
            this.setUpperRightY(f5);
        }
        return this;
    }

    public void resize(float f, float f2) {
        this.setUpperRightX(this.getUpperRightX() + f);
        this.setUpperRightY(this.getUpperRightY() + f2);
    }

    public void resizeTo(float f, float f2) {
        this.setUpperRightX(this.getLowerLeftX() + f);
        this.setUpperRightY(this.getLowerLeftY() + f2);
    }

    public void setCorners(float f, float f2, float f3, float f4) {
        this.cosGetArray().set(0, COSFixed.create(f));
        this.cosGetArray().set(1, COSFixed.create(f2));
        this.cosGetArray().set(2, COSFixed.create(f3));
        this.cosGetArray().set(3, COSFixed.create(f4));
    }

    public void setHeight(float f) {
        this.setUpperRightY(this.getLowerLeftY() + f);
    }

    public void setLowerLeftX(float f) {
        this.cosGetArray().set(0, COSFixed.create(f));
    }

    public void setLowerLeftY(float f) {
        this.cosGetArray().set(1, COSFixed.create(f));
    }

    public void setUpperRightX(float f) {
        this.cosGetArray().set(2, COSFixed.create(f));
    }

    public void setUpperRightY(float f) {
        this.cosGetArray().set(3, COSFixed.create(f));
    }

    public void setWidth(float f) {
        this.setUpperRightX(this.getLowerLeftX() + f);
    }

    public float[] toArray() {
        return new float[]{this.getLowerLeftX(), this.getLowerLeftY(), this.getUpperRightX(), this.getUpperRightY()};
    }

    public Rectangle2D toNormalizedRectangle() {
        if (this.cachedNormalizedRectangle == null) {
            float f;
            float f2 = this.getLowerLeftX();
            float f3 = this.getLowerLeftY();
            float f4 = this.getUpperRightX();
            float f5 = this.getUpperRightY();
            if (f2 > f4) {
                f = f2;
                f2 = f4;
                f4 = f;
            }
            if (f3 > f5) {
                f = f3;
                f3 = f5;
                f5 = f;
            }
            this.cachedNormalizedRectangle = new Rectangle2D.Float(f2, f3, f4 - f2, f5 - f3);
        }
        return (Rectangle2D)this.cachedNormalizedRectangle.clone();
    }

    public Rectangle2D toRectangle() {
        if (this.cachedRectangle == null) {
            float f = this.getLowerLeftX();
            float f2 = this.getLowerLeftY();
            float f3 = this.getUpperRightX();
            float f4 = this.getUpperRightY();
            this.cachedRectangle = new Rectangle2D.Float(f, f2, f3 - f, f4 - f2);
        }
        return (Rectangle2D)this.cachedRectangle.clone();
    }
}

