/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class EditNodeTextField
extends EditNodeBase {
    private KeyEvent firstEvent;
    private JTextField textfield;

    public EditNodeTextField(NodeView node, String text, KeyEvent firstEvent, ModeController controller, EditNodeBase.EditControl editControl) {
        super(node, text, controller, editControl);
        this.firstEvent = firstEvent;
    }

    public void show() {
        this.textfield = this.getText().length() < 8 ? new JTextField(this.getText(), 8) : new JTextField(this.getText());
        int cursorWidth = 1;
        int xOffset = 0;
        int yOffset = -1;
        int widthAddition = 0 + cursorWidth + 2;
        int heightAddition = 2;
        int MINIMAL_LEAF_WIDTH = 150;
        int MINIMAL_WIDTH = 50;
        NodeView nodeView = this.getNode();
        MindMapNode model = nodeView.getModel();
        int xSize = nodeView.getMainView().getTextWidth() + widthAddition;
        xOffset += nodeView.getMainView().getTextX();
        int xExtraWidth = 0;
        if (150 > xSize && (model.isFolded() || !model.hasChildren())) {
            xExtraWidth = 150 - xSize;
            xSize = 150;
            if (nodeView.isLeft()) {
                xExtraWidth = -xExtraWidth;
                this.textfield.setHorizontalAlignment(4);
            }
        } else if (50 > xSize) {
            xExtraWidth = 50 - xSize;
            xSize = 50;
            if (nodeView.isLeft()) {
                xExtraWidth = -xExtraWidth;
                this.textfield.setHorizontalAlignment(4);
            }
        }
        this.textfield.setSize(xSize, nodeView.getMainView().getHeight() + heightAddition);
        Font font = nodeView.getTextFont();
        MapView mapView = nodeView.getMap();
        float zoom = mapView.getZoom();
        if (zoom != 1.0f) {
            font = font.deriveFont((float)font.getSize() * zoom * 0.97f);
        }
        this.textfield.setFont(font);
        Color nodeTextColor = nodeView.getTextColor();
        this.textfield.setForeground(nodeTextColor);
        Color nodeTextBackground = nodeView.getTextBackground();
        this.textfield.setBackground(nodeTextBackground);
        this.textfield.setCaretColor(nodeTextColor);
        boolean EDIT = true;
        int CANCEL = 2;
        final Tools.IntHolder eventSource = new Tools.IntHolder();
        eventSource.setValue(1);
        class TextFieldListener
        implements KeyListener,
        FocusListener,
        MouseListener,
        ComponentListener {
            TextFieldListener() {
            }

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!EditNodeTextField.this.textfield.isVisible() || eventSource.getValue() == 2) {
                    return;
                }
                if (e == null) {
                    EditNodeTextField.this.hideMe();
                    EditNodeTextField.this.getEditControl().ok(EditNodeTextField.this.textfield.getText());
                    eventSource.setValue(2);
                } else {
                    EditNodeTextField.this.hideMe();
                    EditNodeTextField.this.getEditControl().ok(EditNodeTextField.this.textfield.getText());
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isAltDown() || e.isControlDown() || e.isMetaDown() || eventSource.getValue() == 2) {
                    return;
                }
                boolean commit = true;
                switch (e.getKeyCode()) {
                    case 27: {
                        commit = false;
                    }
                    case 10: {
                        e.consume();
                        eventSource.setValue(2);
                        EditNodeTextField.this.hideMe();
                        if (commit) {
                            EditNodeTextField.this.getEditControl().ok(EditNodeTextField.this.textfield.getText());
                            break;
                        }
                        EditNodeTextField.this.getEditControl().cancel();
                        break;
                    }
                    case 32: {
                        e.consume();
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            private void conditionallyShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    EditNodeBase.EditPopupMenu popupMenu = new EditNodeBase.EditPopupMenu(EditNodeTextField.this.textfield);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                }
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.focusLost(null);
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                this.focusLost(null);
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.focusLost(null);
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.focusLost(null);
            }
        }
        TextFieldListener textFieldListener = new TextFieldListener();
        this.textFieldListener = textFieldListener;
        this.textfield.addFocusListener(textFieldListener);
        this.textfield.addKeyListener(textFieldListener);
        this.textfield.addMouseListener(textFieldListener);
        this.getView().scrollNodeToVisible(nodeView, xExtraWidth);
        Point textFieldLocation = new Point();
        Tools.convertPointToAncestor((Component)nodeView.getMainView(), textFieldLocation, mapView);
        if (xExtraWidth < 0) {
            textFieldLocation.x += xExtraWidth;
        }
        textFieldLocation.x += xOffset;
        textFieldLocation.y += yOffset;
        this.textfield.setLocation(textFieldLocation);
        mapView.add((Component)this.textfield, 0);
        this.textfield.repaint();
        this.redispatchKeyEvents(this.textfield, this.firstEvent);
        this.getNode().addComponentListener(textFieldListener);
        this.textfield.requestFocus();
    }

    private void hideMe() {
        JComponent parent = (JComponent)this.textfield.getParent();
        Rectangle bounds = this.textfield.getBounds();
        this.textfield.removeFocusListener(this.textFieldListener);
        this.textfield.removeKeyListener((KeyListener)((Object)this.textFieldListener));
        this.textfield.removeMouseListener((MouseListener)((Object)this.textFieldListener));
        this.getNode().removeComponentListener((ComponentListener)((Object)this.textFieldListener));
        parent.remove(0);
        parent.revalidate();
        parent.repaint(bounds);
        this.textFieldListener = null;
    }
}

