/*
 * Decompiled with CFR 0.152.
 */
package splmm.Actions;

import freemind.main.FreeMindMain;
import freemind.modes.ControllerAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.attributes.Attribute;
import freemind.modes.mindmapmode.MindMapController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import splmm.BibTex;
import splmm.BookmarkMindMapNode;
import splmm.Localization.LocalizationSupport;
import splmm.Preferences.SplmmPreferences;
import splmm.SciPloreUtils;

public class UpdateAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    MindMapController controller;
    List<BibTex> list;
    int updatecounter = 0;
    FreeMindMain frame;

    public UpdateAction(MindMapController controller) {
        super(LocalizationSupport.message("splmm_menu_update"));
        this.controller = controller;
        this.frame = controller.getFrame();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updatecounter = 0;
        File file = new File("" + SplmmPreferences.getJabRefPath());
        if (file.exists()) {
            BibTex bib = new BibTex();
            this.list = bib.readBibtex(file);
            ControllerAdapter adapter = this.controller.getModeController();
            MindMapNode node = adapter.getRootNode();
            this.updatecounter = 0;
            this.help(node);
            if (this.updatecounter > 0) {
                JOptionPane.showMessageDialog(this.frame.getContentPane(), this.updatecounter + " " + LocalizationSupport.message("splmm_update_KeyFound"));
            } else {
                JOptionPane.showMessageDialog(this.frame.getContentPane(), LocalizationSupport.message("splmm_update_noKeyFound"));
            }
        } else {
            JOptionPane.showMessageDialog(this.frame.getContentPane(), LocalizationSupport.message("splmm_update_noBibTex"));
        }
    }

    private void help(MindMapNode node) {
        ListIterator iter = node.childrenUnfolded();
        while (iter.hasNext()) {
            node = (MindMapNode)iter.next();
            String link = node.getLink();
            if (link != null && !link.equals("")) {
                link = link.substring(link.lastIndexOf("\\") + 1);
                ListIterator<BibTex> it = this.list.listIterator();
                while (it.hasNext()) {
                    BibTex b = it.next();
                    String path = b.getPath().replaceAll(" ", "");
                    if (!path.contains(link = link.replaceAll(" ", ""))) continue;
                    this.setAttribute(node, b.getKey(), SciPloreUtils.SPLMM_REFKEY_NAME);
                    if (b.getTitle() == null || b.getTitle() == "") continue;
                    this.setAttribute(node, b.getTitle(), "splmm_reftitle");
                }
            }
            this.help(node);
        }
    }

    private void setAttribute(MindMapNode node, String value, String attributeKey) {
        Attribute pAttribute = new Attribute(attributeKey, value);
        if (node.getAttributeKeyList().size() == 0) {
            node.createAttributeTableModel();
        }
        if (this.HasSplmmAttribute(attributeKey, node)) {
            Attribute splmmAttribute = this.GetSplmmAttribute(attributeKey, node);
            splmmAttribute.setValue(value);
            this.controller.getModeController().nodeChanged(node);
            ++this.updatecounter;
        } else {
            node.getAttributes().addRowNoUndo(pAttribute);
            this.controller.getModeController().nodeChanged(node);
            ++this.updatecounter;
        }
        BookmarkMindMapNode.SetOptimalColumnWidth(node, value, attributeKey);
    }

    private Attribute GetSplmmAttribute(String attributeKey, MindMapNode node) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attributeKey)) continue;
            return a;
        }
        return null;
    }

    private boolean HasSplmmAttribute(String attributeKey, MindMapNode node) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attributeKey)) continue;
            return true;
        }
        return false;
    }

    private boolean IsNewAttribute(MindMapNode node, Attribute attribute) {
        Vector attributes = node.getAttributes().getAttributes();
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase(attribute.getName()) || !a.getValue().equalsIgnoreCase(attribute.getValue())) continue;
            return false;
        }
        return true;
    }
}

