/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.AddLinkXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.FreemindAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;
import freemind.modes.mindmapmode.actions.xml.ActorXml;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class SetLinkByTextFieldAction
extends FreemindAction
implements ActorXml {
    private final MindMapController controller;

    public SetLinkByTextFieldAction(MindMapController controller) {
        super("set_link_by_textfield", (String)null, controller);
        this.controller = controller;
        this.addActor(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String inputValue = JOptionPane.showInputDialog(this.controller.getView().getSelected(), this.controller.getText("edit_link_manually"), this.controller.getSelected().getLink());
        if (inputValue != null) {
            if (inputValue.equals("")) {
                inputValue = null;
            }
            this.setLink(this.controller.getSelected(), inputValue);
        }
    }

    public void setLink(MindMapNode node, String link) {
        this.controller.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.controller.getActionFactory().executeAction(this.getActionPair(node, link));
        this.controller.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    @Override
    public void act(XmlAction action) {
        if (action instanceof AddLinkXmlAction) {
            AddLinkXmlAction linkAction = (AddLinkXmlAction)action;
            NodeAdapter node = this.controller.getNodeFromID(linkAction.getNode());
            node.setLink(linkAction.getDestination());
            this.controller.nodeChanged(node);
        }
    }

    @Override
    public Class getDoActionClass() {
        return AddLinkXmlAction.class;
    }

    private ActionPair getActionPair(MindMapNode node, String link) {
        return new ActionPair((XmlAction)this.createAddLinkXmlAction(node, link), (XmlAction)this.createAddLinkXmlAction(node, node.getLink()));
    }

    private AddLinkXmlAction createAddLinkXmlAction(MindMapNode node, String link) {
        AddLinkXmlAction action = new AddLinkXmlAction();
        action.setNode(node.getObjectId(this.controller));
        action.setDestination(link);
        return action;
    }
}

