/*
 * Decompiled with CFR 0.152.
 */
package freemind.common;

import freemind.common.TextTranslator;
import freemind.controller.Controller;
import freemind.main.Resources;
import freemind.main.Tools;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class OptionalDontShowMeAgainDialog {
    public static final int ONLY_OK_SELECTION_IS_STORED = 0;
    public static final int BOTH_OK_AND_CANCEL_OPTIONS_ARE_STORED = 1;
    private final String mTitleId;
    private final String mMessageId;
    private final TextTranslator mTextTranslator;
    private final JFrame mParent;
    private int mResult = 2;
    private JDialog mDialog;
    private JCheckBox mDontShowAgainBox;
    private final DontShowPropertyHandler mDontShowPropertyHandler;
    private final int mMessageType;
    private final Component mComponent;

    public OptionalDontShowMeAgainDialog(JFrame pFrame, Component pComponent, String pMessageId, String pTitleId, TextTranslator pTextTranslator, DontShowPropertyHandler pDontShowPropertyHandler, int pMessageType) {
        this.mComponent = pComponent;
        this.mParent = pFrame;
        this.mMessageId = pMessageId;
        this.mTitleId = pTitleId;
        this.mTextTranslator = pTextTranslator;
        this.mDontShowPropertyHandler = pDontShowPropertyHandler;
        this.mMessageType = pMessageType;
    }

    public int getResult() {
        return this.mResult;
    }

    public OptionalDontShowMeAgainDialog show() {
        String property = this.mDontShowPropertyHandler.getProperty();
        if (Tools.safeEquals(property, "true")) {
            this.mResult = 0;
            return this;
        }
        if (Tools.safeEquals(property, "false")) {
            this.mResult = 2;
            return this;
        }
        this.mDialog = null;
        this.mDialog = new JDialog((Frame)this.mParent, this.mTextTranslator.getText(this.mTitleId));
        this.mDialog.setModal(true);
        this.mDialog.setDefaultCloseOperation(0);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                OptionalDontShowMeAgainDialog.this.close(2);
            }
        };
        AbstractAction okAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pE) {
                OptionalDontShowMeAgainDialog.this.close(0);
            }
        };
        Tools.addEscapeActionToDialog(this.mDialog, cancelAction);
        this.mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent pE) {
                OptionalDontShowMeAgainDialog.this.close(2);
            }
        });
        this.mDialog.getContentPane().setLayout(new GridBagLayout());
        this.mDialog.getContentPane().add((Component)new JLabel(this.mTextTranslator.getText(this.mMessageId)), new GridBagConstraints(1, 0, 1, 1, 10.0, 4.0, 17, 1, new Insets(5, 5, 0, 0), 0, 10));
        ImageIcon questionMark = new ImageIcon(Resources.getInstance().getResource("images/icons/help.png"));
        this.mDialog.getContentPane().add((Component)new JLabel(questionMark), new GridBagConstraints(0, 0, 1, 2, 1.0, 2.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        String boxString = this.mMessageType == 0 ? "OptionalDontShowMeAgainDialog.dontShowAgain" : "OptionalDontShowMeAgainDialog.rememberMyDescision";
        this.mDontShowAgainBox = new JCheckBox(this.mTextTranslator.getText(boxString));
        Tools.setLabelAndMnemonic(this.mDontShowAgainBox, null);
        this.mDialog.getContentPane().add((Component)this.mDontShowAgainBox, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        JButton okButton = new JButton(this.mTextTranslator.getText("OptionalDontShowMeAgainDialog.ok"));
        Tools.setLabelAndMnemonic(okButton, null);
        okButton.addActionListener(okAction);
        this.mDialog.getContentPane().add((Component)okButton, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        JButton cancelButton = new JButton(this.mTextTranslator.getText("OptionalDontShowMeAgainDialog.cancel"));
        Tools.setLabelAndMnemonic(cancelButton, null);
        cancelButton.addActionListener(cancelAction);
        this.mDialog.getContentPane().add((Component)cancelButton, new GridBagConstraints(3, 3, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.mDialog.getRootPane().setDefaultButton(okButton);
        this.mDialog.pack();
        Tools.setDialogLocationRelativeTo(this.mDialog, this.mComponent);
        this.mDialog.setVisible(true);
        return this;
    }

    private void close(int pResult) {
        this.mResult = pResult;
        if (this.mDontShowAgainBox.isSelected()) {
            if (this.mMessageType == 0) {
                if (this.mResult == 0) {
                    this.mDontShowPropertyHandler.setProperty("true");
                }
            } else {
                this.mDontShowPropertyHandler.setProperty(this.mResult == 0 ? "true" : "false");
            }
        } else {
            this.mDontShowPropertyHandler.setProperty("");
        }
        this.mDialog.setVisible(false);
        this.mDialog.dispose();
    }

    public static class StandardPropertyHandler
    implements DontShowPropertyHandler {
        private final Controller mController;
        private String mPropertyName;

        public StandardPropertyHandler(Controller pController, String pPropertyName) {
            this.mController = pController;
            this.mPropertyName = pPropertyName;
        }

        @Override
        public String getProperty() {
            return this.mController.getProperty(this.mPropertyName);
        }

        @Override
        public void setProperty(String pValue) {
            this.mController.setProperty(this.mPropertyName, pValue);
        }
    }

    public static interface DontShowPropertyHandler {
        public String getProperty();

        public void setProperty(String var1);
    }
}

