/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontHeader;
import de.intarsys.cwt.font.truetype.TTHorizontalHeader;
import de.intarsys.cwt.font.truetype.TTMetrics;
import de.intarsys.cwt.font.truetype.TTNameRecord;
import de.intarsys.cwt.font.truetype.TTNaming;
import de.intarsys.cwt.font.truetype.TTPostScriptInformation;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TTFontParser {
    private TTTable[] tables;

    public Map parseTable_cmap(TTTable tTTable) throws IOException {
        HashMap<String, TTTable> hashMap = new HashMap<String, TTTable>();
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        try {
            iRandomAccess.seek(0L);
            iRandomAccess.seekBy(2L);
            int n = this.readUShort(iRandomAccess);
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.readUShort(iRandomAccess);
                int n4 = this.readUShort(iRandomAccess);
                int n5 = this.readInt(iRandomAccess);
                TTTable tTTable2 = new TTTable(tTTable.getFont(), tTTable.getOffset() + (long)n5, -1L);
                String string = n3 + ":" + n4;
                hashMap.put(string, tTTable2);
                ++n2;
            }
            HashMap<String, TTTable> hashMap2 = hashMap;
            return hashMap2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public Map parseTable_cmap_subtable(TTTable tTTable) throws IOException {
        Map map = null;
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        try {
            iRandomAccess.seek(0L);
            int n = this.readUShort(iRandomAccess);
            switch (n) {
                case 0: {
                    map = this.readCMapFormat0(iRandomAccess);
                    break;
                }
                case 4: {
                    map = this.readCMapFormat4(iRandomAccess);
                    break;
                }
                case 6: {
                    map = this.readCMapFormat6(iRandomAccess);
                }
            }
            Map map2 = map;
            return map2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public TTFontHeader parseTable_head(TTTable tTTable) throws IOException {
        TTFontHeader tTFontHeader = new TTFontHeader();
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        try {
            iRandomAccess.seek(0L);
            iRandomAccess.seekBy(16L);
            tTFontHeader.setFlags(this.readUShort(iRandomAccess));
            tTFontHeader.setUnitsPerEm(this.readUShort(iRandomAccess));
            iRandomAccess.seekBy(16L);
            tTFontHeader.setXMin(this.readShort(iRandomAccess));
            tTFontHeader.setYMin(this.readShort(iRandomAccess));
            tTFontHeader.setXMax(this.readShort(iRandomAccess));
            tTFontHeader.setYMax(this.readShort(iRandomAccess));
            tTFontHeader.setMacStyle(this.readUShort(iRandomAccess));
            iRandomAccess.seekBy(4L);
            tTFontHeader.setShortLocationFormat(this.readShort(iRandomAccess) == 0);
            TTFontHeader tTFontHeader2 = tTFontHeader;
            return tTFontHeader2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public TTHorizontalHeader parseTable_hhea(TTTable tTTable) throws IOException {
        TTHorizontalHeader tTHorizontalHeader = new TTHorizontalHeader();
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        try {
            iRandomAccess.seek(0L);
            iRandomAccess.seekBy(4L);
            tTHorizontalHeader.setAscender(this.readShort(iRandomAccess));
            tTHorizontalHeader.setDescender(this.readShort(iRandomAccess));
            tTHorizontalHeader.setLineGap(this.readShort(iRandomAccess));
            tTHorizontalHeader.setAdvanceWidthMax(this.readUShort(iRandomAccess));
            tTHorizontalHeader.setMinLeftSideBearing(this.readShort(iRandomAccess));
            tTHorizontalHeader.setMinRightSideBearing(this.readShort(iRandomAccess));
            tTHorizontalHeader.setXMaxExtent(this.readShort(iRandomAccess));
            tTHorizontalHeader.setCaretSlopeRise(this.readShort(iRandomAccess));
            tTHorizontalHeader.setCaretSlopeRun(this.readShort(iRandomAccess));
            iRandomAccess.seekBy(12L);
            tTHorizontalHeader.setNumberOfHMetrics(this.readUShort(iRandomAccess));
            TTHorizontalHeader tTHorizontalHeader2 = tTHorizontalHeader;
            return tTHorizontalHeader2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public int[] parseTable_hmtx(TTTable tTTable, int n) throws IOException {
        int[] nArray = new int[n];
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        try {
            iRandomAccess.seek(0L);
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.readUShort(iRandomAccess);
                this.readShort(iRandomAccess);
                ++n2;
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public int[] parseTable_loca(TTTable tTTable, boolean bl) throws IOException {
        int n = 0;
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        try {
            int[] nArray;
            iRandomAccess.seek(0L);
            if (bl) {
                n = (int)iRandomAccess.getLength() / 2;
                nArray = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    nArray[n2] = this.readUShort(iRandomAccess) << 1;
                    ++n2;
                }
            } else {
                n = (int)iRandomAccess.getLength() / 4;
                nArray = new int[n];
                int n3 = 0;
                while (n3 < n) {
                    nArray[n3] = this.readInt(iRandomAccess);
                    ++n3;
                }
            }
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public TTNaming parseTable_name(TTTable tTTable) throws IOException {
        TTNaming tTNaming = new TTNaming();
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        try {
            iRandomAccess.seek(0L);
            iRandomAccess.seekBy(2L);
            int n = this.readUShort(iRandomAccess);
            int n2 = this.readUShort(iRandomAccess);
            int n3 = 0;
            while (n3 < n) {
                TTNameRecord tTNameRecord = this.readNameRecord(iRandomAccess, n2);
                if (tTNameRecord.getPlatformID() == 3 && tTNameRecord.getLanguageID() == 1033) {
                    tTNaming.add(tTNameRecord.getNameID(), tTNameRecord);
                }
                ++n3;
            }
            TTNaming tTNaming2 = tTNaming;
            return tTNaming2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public TTMetrics parseTable_os2(TTTable tTTable) throws IOException {
        TTMetrics tTMetrics = new TTMetrics();
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        try {
            iRandomAccess.seek(0L);
            iRandomAccess.seekBy(2L);
            tTMetrics.setXAvgCharWidth(this.readShort(iRandomAccess));
            tTMetrics.setUsWeightClass(this.readUShort(iRandomAccess));
            tTMetrics.setUsWidthClass(this.readUShort(iRandomAccess));
            tTMetrics.setFsType(this.readUShort(iRandomAccess));
            tTMetrics.setYSubscriptXSize(this.readShort(iRandomAccess));
            tTMetrics.setYSubscriptYSize(this.readShort(iRandomAccess));
            tTMetrics.setYSubscriptXOffset(this.readShort(iRandomAccess));
            tTMetrics.setYSubscriptYOffset(this.readShort(iRandomAccess));
            tTMetrics.setYSuperscriptXSize(this.readShort(iRandomAccess));
            tTMetrics.setYSuperscriptYSize(this.readShort(iRandomAccess));
            tTMetrics.setYSuperscriptXOffset(this.readShort(iRandomAccess));
            tTMetrics.setYSuperscriptYOffset(this.readShort(iRandomAccess));
            tTMetrics.setYStrikeoutSize(this.readShort(iRandomAccess));
            tTMetrics.setYStrikeoutPosition(this.readShort(iRandomAccess));
            tTMetrics.setSFamilyClass(this.readShort(iRandomAccess));
            tTMetrics.setPanose(this.readBytes(iRandomAccess, 10));
            iRandomAccess.seekBy(20L);
            tTMetrics.setFsSelection(this.readUShort(iRandomAccess));
            tTMetrics.setUsFirstCharIndex(this.readUShort(iRandomAccess));
            tTMetrics.setUsLastCharIndex(this.readUShort(iRandomAccess));
            tTMetrics.setSTypoAscender(this.readShort(iRandomAccess));
            tTMetrics.setSTypoDescender(this.readShort(iRandomAccess));
            tTMetrics.setSTypoLineGap(this.readShort(iRandomAccess));
            tTMetrics.setUsWinAscent(this.readUShort(iRandomAccess));
            tTMetrics.setUsWinDescent(this.readUShort(iRandomAccess));
            tTMetrics.setSxHeight(this.readShort(iRandomAccess));
            tTMetrics.setSCapHeight(this.readShort(iRandomAccess));
            tTMetrics.setUsDefaultChar(this.readUShort(iRandomAccess));
            tTMetrics.setUsMaxContext(this.readUShort(iRandomAccess));
            TTMetrics tTMetrics2 = tTMetrics;
            return tTMetrics2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public TTPostScriptInformation parseTable_post(TTTable tTTable) throws IOException {
        TTPostScriptInformation tTPostScriptInformation = new TTPostScriptInformation();
        IRandomAccess iRandomAccess = tTTable.getRandomAccess();
        try {
            iRandomAccess.seek(0L);
            tTPostScriptInformation.setVersion(this.readFixed(iRandomAccess));
            tTPostScriptInformation.setItalicAngle(this.readFixed(iRandomAccess));
            tTPostScriptInformation.setUnderlinePosition(this.readShort(iRandomAccess));
            tTPostScriptInformation.setUnderlineThickness(this.readShort(iRandomAccess));
            TTPostScriptInformation tTPostScriptInformation2 = tTPostScriptInformation;
            return tTPostScriptInformation2;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    public TTTable[] parseTables(TTFont tTFont) throws IOException {
        IRandomAccess iRandomAccess = null;
        try {
            iRandomAccess = tTFont.getLocator().getRandomAccess();
            this.readTables(tTFont, iRandomAccess);
            tTFont.setTables(this.tables);
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
        return this.tables;
    }

    public byte[] readBytes(IRandomAccess iRandomAccess, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = iRandomAccess.read(byArray);
        if (n2 < byArray.length) {
            return null;
        }
        return byArray;
    }

    protected Map readCMapFormat0(IRandomAccess iRandomAccess) throws IOException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        iRandomAccess.seekBy(4L);
        int n = 0;
        while (n < 256) {
            int n2 = iRandomAccess.read();
            hashMap.put(new Integer(n), new Integer(n2));
            ++n;
        }
        return hashMap;
    }

    protected Map readCMapFormat4(IRandomAccess iRandomAccess) throws IOException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = this.readUShort(iRandomAccess);
        iRandomAccess.seekBy(2L);
        int n2 = this.readUShort(iRandomAccess) / 2;
        iRandomAccess.seekBy(6L);
        int[] nArray = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = this.readUShort(iRandomAccess);
            ++n3;
        }
        iRandomAccess.seekBy(2L);
        int[] nArray2 = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = this.readUShort(iRandomAccess);
            ++n4;
        }
        int[] nArray3 = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            nArray3[n5] = this.readUShort(iRandomAccess);
            ++n5;
        }
        int[] nArray4 = new int[n2];
        int n6 = 0;
        while (n6 < n2) {
            nArray4[n6] = this.readUShort(iRandomAccess);
            ++n6;
        }
        n6 = n / 2 - 8 - n2 * 4;
        int[] nArray5 = new int[n6];
        int n7 = 0;
        while (n7 < n6) {
            nArray5[n7] = this.readUShort(iRandomAccess);
            ++n7;
        }
        int n8 = 0;
        while (n8 < n2) {
            int n9 = nArray2[n8];
            while (n9 <= nArray[n8] && n9 != 65535) {
                if (nArray4[n8] == 0) {
                    n7 = nArray3[n8] + n9 & 0xFFFF;
                } else {
                    int n10 = n9 - nArray2[n8] + nArray4[n8] / 2;
                    n7 = nArray5[n10 = n10 - n2 + n8];
                    if (n7 != 0) {
                        n7 = nArray3[n8] + n7 & 0xFFFF;
                    }
                }
                hashMap.put(new Integer(n9), new Integer(n7));
                ++n9;
            }
            ++n8;
        }
        return hashMap;
    }

    protected Map readCMapFormat6(IRandomAccess iRandomAccess) throws IOException {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        iRandomAccess.seekBy(4L);
        int n = this.readUShort(iRandomAccess);
        int n2 = this.readUShort(iRandomAccess);
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            int n5 = this.readUShort(iRandomAccess);
            hashMap.put(new Integer(n4), new Integer(n5));
            ++n4;
        }
        return hashMap;
    }

    public float readFixed(IRandomAccess iRandomAccess) throws IOException {
        int n = this.readInt(iRandomAccess);
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n *= -1;
        }
        float f = n >> 16;
        float f2 = n & 0xFFFF;
        while (f2 >= 1.0f) {
            f2 /= 10.0f;
        }
        if (bl) {
            return -1.0f * (f + f2);
        }
        return f + f2;
    }

    public int readInt(IRandomAccess iRandomAccess) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = iRandomAccess.read();
        if ((n4 | (n3 = iRandomAccess.read()) | (n2 = iRandomAccess.read()) | (n = iRandomAccess.read())) < 0) {
            throw new IOException("unexpected end of stream");
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + n;
    }

    protected TTNameRecord readNameRecord(IRandomAccess iRandomAccess, int n) throws IOException {
        TTNameRecord tTNameRecord = new TTNameRecord();
        tTNameRecord.setPlatformID(this.readUShort(iRandomAccess));
        tTNameRecord.setEncodingID(this.readUShort(iRandomAccess));
        tTNameRecord.setLanguageID(this.readUShort(iRandomAccess));
        tTNameRecord.setNameID(this.readUShort(iRandomAccess));
        tTNameRecord.setLength(this.readUShort(iRandomAccess));
        int n2 = this.readUShort(iRandomAccess);
        byte[] byArray = new byte[tTNameRecord.getLength()];
        iRandomAccess.mark();
        iRandomAccess.seek((long)(n + n2));
        iRandomAccess.read(byArray, 0, tTNameRecord.getLength());
        tTNameRecord.setValue(new String(byArray, "UTF-16BE"));
        iRandomAccess.reset();
        return tTNameRecord;
    }

    public short readShort(IRandomAccess iRandomAccess) throws IOException {
        int n;
        int n2 = iRandomAccess.read();
        if ((n2 | (n = iRandomAccess.read())) < 0) {
            throw new IOException("unexpected end of stream");
        }
        return (short)((n2 << 8) + n);
    }

    public TTTable readTable(TTFont tTFont, IRandomAccess iRandomAccess) throws IOException {
        byte[] byArray = this.readBytes(iRandomAccess, 4);
        int n = this.readInt(iRandomAccess);
        int n2 = this.readInt(iRandomAccess);
        int n3 = this.readInt(iRandomAccess);
        TTTable tTTable = new TTTable(tTFont, n2, n3);
        tTTable.setName(byArray);
        tTTable.setChecksum(n);
        return tTTable;
    }

    public void readTables(TTFont tTFont, IRandomAccess iRandomAccess) throws IOException {
        this.readInt(iRandomAccess);
        int n = this.readUShort(iRandomAccess);
        iRandomAccess.seekBy(6L);
        this.tables = new TTTable[n];
        int n2 = 0;
        while (n2 < n) {
            this.tables[n2] = this.readTable(tTFont, iRandomAccess);
            ++n2;
        }
    }

    public long readUInt(IRandomAccess iRandomAccess) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = iRandomAccess.read();
        if ((n4 | (n3 = iRandomAccess.read()) | (n2 = iRandomAccess.read()) | (n = iRandomAccess.read())) < 0) {
            throw new IOException("unexpected end of stream");
        }
        return ((long)n4 << 24) + (long)(n3 << 16) + (long)(n2 << 8) + (long)n;
    }

    public int readUShort(IRandomAccess iRandomAccess) throws IOException {
        int n;
        int n2 = iRandomAccess.read();
        if ((n2 | (n = iRandomAccess.read())) < 0) {
            throw new IOException("unexpected end of stream");
        }
        return (n2 << 8) + n;
    }
}

