/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import java.io.OutputStream;

public class FastByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;

    public FastByteArrayOutputStream() {
        this(32);
    }

    public FastByteArrayOutputStream(int n) {
        this.buf = new byte[n];
    }

    public byte[] getBytes() {
        return this.buf;
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public void write(byte[] byArray, int n, int n2) {
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n3)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.buf.length);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public void write(int n) {
        if (this.count >= this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, 1)];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
        }
        this.buf[this.count++] = (byte)n;
    }
}

