/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.reader;

import de.intarsys.tools.reader.IDirectTagHandler;
import de.intarsys.tools.reader.ILocationProvider;
import de.intarsys.tools.reader.UnEscapeReader;
import de.intarsys.tools.string.StringTools;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class DirectTagReader
extends FilterReader {
    public static final char ESCAPE_CHARACTER = '\\';
    public static final Map DefaultEscapeMap = new HashMap();
    private static final char[] defaultEndTag = "}".toCharArray();
    private static final char[] defaultStartTag = "${".toCharArray();
    private static ILocationProvider nullLocationProvider = new NullLocationProvider();
    private int bufferLength = 0;
    private char[] endTag = defaultEndTag;
    private IDirectTagHandler handler;
    private char[] readBuffer = new char[100];
    private char[] startTag = defaultStartTag;
    private StringBuilder tagBuffer = new StringBuilder();
    private UnEscapeReader unescapeReader;
    private boolean checkTag = true;
    private Object context;

    static {
        DefaultEscapeMap.put(new Character('\\'), new Character('\\'));
        DefaultEscapeMap.put(new Character('n'), new Character('\n'));
        DefaultEscapeMap.put(new Character('r'), new Character('\r'));
        DefaultEscapeMap.put(new Character('t'), new Character('\t'));
        DefaultEscapeMap.put(new Character('$'), new Character('$'));
        DefaultEscapeMap.put(new Character('}'), new Character('}'));
        DefaultEscapeMap.put(new Character('\n'), null);
        DefaultEscapeMap.put(new Character('\r'), null);
        DefaultEscapeMap.put(new Character('\t'), null);
        DefaultEscapeMap.put(new Character(' '), null);
    }

    public DirectTagReader(Reader reader, IDirectTagHandler iDirectTagHandler, Object object) {
        this(reader, iDirectTagHandler, object, true);
    }

    public DirectTagReader(Reader reader, IDirectTagHandler iDirectTagHandler, Object object, boolean bl) {
        super(reader);
        if (bl) {
            this.in = new UnEscapeReader(reader, '\\', DefaultEscapeMap);
            this.unescapeReader = (UnEscapeReader)this.in;
        }
        this.handler = iDirectTagHandler;
        this.context = object;
        if (reader instanceof ILocationProvider) {
            iDirectTagHandler.setLocationProvider((ILocationProvider)((Object)reader));
        } else {
            iDirectTagHandler.setLocationProvider(nullLocationProvider);
        }
    }

    protected int basicRead() throws IOException {
        if (this.bufferLength > 0) {
            return this.readBuffer[--this.bufferLength];
        }
        this.checkTag = true;
        return super.read();
    }

    protected IDirectTagHandler getHandler() {
        return this.handler;
    }

    public int read() throws IOException {
        int n = this.basicRead();
        if (this.checkTag && n == this.startTag[0] && (this.unescapeReader == null || !this.unescapeReader.isMapped())) {
            return this.scanTag();
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.read();
            if (n4 == -1) {
                if (n3 == 0) {
                    return -1;
                }
                return n3;
            }
            cArray[n + n3] = (char)n4;
            ++n3;
        }
        return n2;
    }

    protected int scanEndTag() throws IOException {
        int n = 0;
        int n2 = this.endTag[0];
        while (n2 == this.endTag[n]) {
            if (++n == this.endTag.length) {
                return -1;
            }
            n2 = this.basicRead();
        }
        if (n2 != -1) {
            this.unread(n2);
        }
        this.unread(this.endTag, 0, n);
        return this.basicRead();
    }

    protected int scanTag() throws IOException {
        int n = 0;
        int n2 = this.startTag[0];
        while (n2 == this.startTag[n]) {
            if (++n == this.startTag.length) {
                this.handler.startTag();
                return this.scanTagContent();
            }
            n2 = this.basicRead();
        }
        if (n2 != -1) {
            this.unread(n2);
        }
        this.unread(this.startTag, 0, n);
        return this.basicRead();
    }

    protected int scanTagContent() throws IOException {
        this.tagBuffer.setLength(0);
        int n = this.tagRead();
        while (n != -1) {
            this.tagBuffer.append((char)n);
            n = this.tagRead();
        }
        String string = this.tagBuffer.toString();
        String string2 = this.isSpecialTag(string) ? string : this.getHandler().process(string, this.context);
        if (!StringTools.isEmpty(string2)) {
            this.unread(string2.toCharArray(), 0, string2.length());
            this.checkTag = false;
        }
        return this.read();
    }

    protected boolean isSpecialTag(String string) {
        if (string.length() == this.startTag.length) {
            int n = 0;
            while (n < this.startTag.length) {
                if (string.charAt(n) != this.startTag[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public void setEndTag(String string) {
        if (this.endTag != null && this.unescapeReader != null) {
            this.unescapeReader.removeEscapedCharacter(this.endTag[0]);
        }
        this.endTag = string.toCharArray();
        if (this.unescapeReader != null) {
            this.unescapeReader.addEscapedCharacter(this.endTag[0], this.endTag[0]);
        }
    }

    public void setStartTag(String string) {
        if (this.startTag != null && this.unescapeReader != null) {
            this.unescapeReader.removeEscapedCharacter(this.startTag[0]);
        }
        this.startTag = string.toCharArray();
        if (this.unescapeReader != null) {
            this.unescapeReader.addEscapedCharacter(this.startTag[0], this.startTag[0]);
        }
    }

    protected int tagRead() throws IOException {
        int n = super.read();
        if (n == -1) {
            throw new IOException("end tag '" + new String(this.endTag) + "' missing");
        }
        if (!(n != this.endTag[0] || this.unescapeReader != null && this.unescapeReader.isMapped())) {
            return this.scanEndTag();
        }
        return n;
    }

    protected void unread(char[] cArray, int n, int n2) {
        if (this.readBuffer.length < this.bufferLength + n2) {
            char[] cArray2 = new char[(this.bufferLength + n2) * 2];
            System.arraycopy(this.readBuffer, 0, cArray2, 0, this.bufferLength);
            this.readBuffer = cArray2;
        }
        int n3 = n + n2 - 1;
        while (n3 >= n) {
            this.readBuffer[this.bufferLength++] = cArray[n3];
            --n3;
        }
    }

    protected void unread(int n) {
        if (this.readBuffer.length < this.bufferLength + 1) {
            char[] cArray = new char[(this.bufferLength + 1) * 2];
            System.arraycopy(this.readBuffer, 0, cArray, 0, this.bufferLength);
            this.readBuffer = cArray;
        }
        this.readBuffer[this.bufferLength++] = (char)n;
    }

    private static class NullLocationProvider
    implements ILocationProvider {
        private NullLocationProvider() {
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }

        public int getPosition() {
            return 0;
        }
    }
}

