/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import java.io.IOException;

public class RandomAccessByteArray
extends AbstractRandomAccess {
    private static final int RESIZE_BYTES = 32;
    private byte[] data;
    private int offset = 0;
    private int length;

    public RandomAccessByteArray(byte[] byArray) {
        if (byArray == null) {
            this.data = new byte[32];
            this.length = 0;
        } else {
            this.data = byArray;
            this.length = byArray.length;
        }
    }

    protected byte[] getData() {
        return this.data;
    }

    public void seek(long l) throws IOException {
        this.offset = (int)l;
        if (this.offset < 0) {
            this.offset = 0;
            throw new IOException("offset less than 0");
        }
    }

    public void seekBy(long l) throws IOException {
        this.offset = (int)((long)this.offset + l);
        if (this.offset < 0) {
            this.offset = 0;
            throw new IOException("offset less than 0");
        }
    }

    public int read() {
        if (this.offset < this.length) {
            return this.data[this.offset++] & 0xFF;
        }
        return -1;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLength() throws IOException {
        return this.length;
    }

    public int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) {
        int n3 = this.length - this.offset;
        if (n2 > n3 && (n2 = n3) == 0) {
            return -1;
        }
        System.arraycopy(this.data, this.offset, byArray, n, n2);
        this.offset += n2;
        return n2;
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setLength(long l) {
        if (l > (long)this.length) {
            if (l > (long)this.data.length) {
                byte[] byArray = l - (long)this.data.length < 32L ? new byte[this.data.length + 32] : new byte[(int)l];
                System.arraycopy(this.data, 0, byArray, 0, this.length);
                this.data = byArray;
            }
        } else if ((long)this.offset > l) {
            this.offset = (int)l;
        }
        this.length = (int)l;
    }

    public void write(int n) {
        int n2 = this.offset + 1;
        if (n2 > this.length) {
            this.setLength(n2);
        }
        this.data[this.offset++] = (byte)n;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        long l = this.offset + n2;
        if (l > (long)this.length) {
            this.setLength(l);
        }
        System.arraycopy(byArray, n, this.data, this.offset, n2);
        this.offset += n2;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        return byArray;
    }
}

