/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class AttachmentTools {
    protected static String createAttachmentName(String string, String string2, String string3) {
        String string4 = StringTools.getCommonPrefix(string, string3, true);
        int n = string.length() - string4.length();
        int n2 = string3.length() - string4.length();
        String string5 = string2;
        string5 = string5.substring(0, string5.length() - n);
        string5 = String.valueOf(string5) + string3.substring(string3.length() - n2);
        return string5;
    }

    public static List createAttachments(File file, File[] fileArray, String string) {
        if (StringTools.isEmpty(string)) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        if (file != null) {
            string2 = file.getName().toLowerCase();
            string3 = FileTools.getBaseName(string2);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray = string.toLowerCase().split(";");
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            String string4 = file2.getName().toLowerCase();
            if (!string4.equals(string2)) {
                String string5 = FileTools.getBaseName(string4);
                if (file == null || string5.equals(string2) || string5.equals(string3)) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (string4.endsWith(stringArray[n2])) {
                            arrayList.add(file2);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static List createAttachments(File file, String string) {
        File file2;
        File file3;
        if (file.isDirectory()) {
            file3 = file;
            file2 = null;
        } else {
            file3 = file.getParentFile();
            file2 = file;
        }
        if (file3 == null) {
            return null;
        }
        File[] fileArray = file3.listFiles();
        return AttachmentTools.createAttachments(file2, fileArray, string);
    }

    public static File moveAttachment(File file, File file2, File file3, boolean bl) {
        if (file3 == null || file2 == null) {
            return null;
        }
        String string = file.getName();
        String string2 = file3.getName();
        File file4 = file3.isDirectory() ? file3 : file3.getParentFile();
        try {
            File file5 = AttachmentTools.moveAttachment(string, file2, string2, file4, bl);
            return file5;
        }
        catch (Exception exception) {
            FileTools.Log.log(Level.WARNING, "failed to move attachment '" + file2 + "' attached to '" + file + "'");
            return file2;
        }
    }

    protected static File moveAttachment(String string, Object object, String string2, File file, boolean bl) throws IOException {
        if (object instanceof FileLocator) {
            object = ((FileLocator)object).getFile();
        }
        if (object instanceof File) {
            File file2 = (File)object;
            String string3 = file2.getName();
            String string4 = AttachmentTools.createAttachmentName(string, string2, string3);
            File file3 = new File(file, string4);
            if (bl) {
                FileTools.renameFile(file2, file3);
            } else {
                FileTools.copyFile(file2, file3);
            }
            return file3;
        }
        if (object instanceof ILocator) {
            ILocator iLocator = (ILocator)object;
            String string5 = iLocator.getTypedName();
            String string6 = AttachmentTools.createAttachmentName(string, string2, string5);
            File file4 = new File(file, string6);
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                inputStream = iLocator.getInputStream();
                fileOutputStream = new FileOutputStream(file4);
                StreamTools.copyStream(inputStream, fileOutputStream);
            }
            catch (Throwable throwable) {
                StreamTools.close(inputStream);
                StreamTools.close(fileOutputStream);
                throw throwable;
            }
            StreamTools.close(inputStream);
            StreamTools.close(fileOutputStream);
            if (bl) {
                iLocator.delete();
            }
            return file4;
        }
        return null;
    }

    public static List moveAttachments(File file, List list, File file2, boolean bl) {
        if (file2 == null || list == null) {
            return null;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = file.getName();
        String string2 = file2.getName();
        File file3 = file2.isDirectory() ? file2 : file2.getParentFile();
        for (Object e : list) {
            try {
                File file4 = AttachmentTools.moveAttachment(string, e, string2, file3, bl);
                arrayList.add(file4);
            }
            catch (Exception exception) {
                arrayList.add((File)e);
                FileTools.Log.log(Level.WARNING, "failed to move attachment '" + e + "' attached to '" + file + "'");
            }
        }
        return arrayList;
    }
}

