/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.concurrent;

import de.intarsys.tools.concurrent.ITaskListener;
import de.intarsys.tools.concurrent.ITaskListenerSupport;
import java.util.concurrent.ExecutionException;

public class TaskCallbackDispatcher
implements ITaskListenerSupport,
ITaskListener {
    private final Object owner;
    private ITaskListener[] listeners = new ITaskListener[2];

    public TaskCallbackDispatcher(Object object) {
        this.owner = object;
    }

    public void addTaskListener(ITaskListener iTaskListener) {
        if (iTaskListener == null) {
            throw new NullPointerException("listener may not be null");
        }
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.listeners[n2] == null) break;
            ++n2;
        }
        if (n2 >= n) {
            ITaskListener[] iTaskListenerArray = new ITaskListener[n + 4];
            System.arraycopy(this.listeners, 0, iTaskListenerArray, 0, n);
            this.listeners = iTaskListenerArray;
        }
        this.listeners[n2] = iTaskListener;
    }

    public synchronized void attach(ITaskListenerSupport iTaskListenerSupport) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            iTaskListenerSupport.addTaskListener(this.listeners[n2]);
            ++n2;
        }
    }

    public synchronized void clear() {
        this.listeners = new ITaskListener[4];
    }

    public synchronized void detach(ITaskListenerSupport iTaskListenerSupport) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            iTaskListenerSupport.removeTaskListener(this.listeners[n2]);
            ++n2;
        }
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized boolean isEmpty() {
        int n = 0;
        while (n < this.listeners.length) {
            if (this.listeners[n] != null) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void removeTaskListener(ITaskListener iTaskListener) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.listeners[n2] == iTaskListener) {
                this.listeners[n2] = null;
                break;
            }
            ++n2;
        }
    }

    public void taskCancelled(Object object) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskListener iTaskListener = this.listeners[n2];
            if (iTaskListener != null) {
                iTaskListener.taskCancelled(object);
            }
            ++n2;
        }
    }

    public void taskFailed(Object object, ExecutionException executionException) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskListener iTaskListener = this.listeners[n2];
            if (iTaskListener != null) {
                iTaskListener.taskFailed(object, executionException);
            }
            ++n2;
        }
    }

    public void taskFinished(Object object, Object object2) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskListener iTaskListener = this.listeners[n2];
            if (iTaskListener != null) {
                iTaskListener.taskFinished(object, object2);
            }
            ++n2;
        }
    }

    public void taskStarted(Object object) {
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            ITaskListener iTaskListener = this.listeners[n2];
            if (iTaskListener != null) {
                iTaskListener.taskStarted(object);
            }
            ++n2;
        }
    }
}

