/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.factory.AdapterPrefs;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.rewriter.Rewriter;
import org.python.pydev.shared_core.string.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionArgAdapter
extends AbstractNodeAdapter<argumentsType> {
    public FunctionArgAdapter(ModuleAdapter module, FunctionDefAdapter parent, argumentsType node, AdapterPrefs adapterPrefs) {
        super(module, parent, node, adapterPrefs);
        Assert.isNotNull((Object)module);
    }

    public boolean hasKwArg() {
        return ((argumentsType)this.getASTNode()).kwarg != null;
    }

    public boolean hasVarArg() {
        return ((argumentsType)this.getASTNode()).vararg != null;
    }

    public boolean hasArg() {
        return ((argumentsType)this.getASTNode()).args != null && ((argumentsType)this.getASTNode()).args.length > 0;
    }

    public List<String> getArgOnly() {
        ArrayList<String> args = new ArrayList<String>();
        exprType[] exprTypeArray = ((argumentsType)this.getASTNode()).args;
        int n = ((argumentsType)this.getASTNode()).args.length;
        int n2 = 0;
        while (n2 < n) {
            exprType arg = exprTypeArray[n2];
            args.add(this.nodeHelper.getName((SimpleNode)arg));
            ++n2;
        }
        return args;
    }

    public List<String> getSelfFilteredArgNames() {
        ArrayList<String> args = new ArrayList<String>();
        for (exprType arg : this.getSelfFilteredArgs()) {
            args.add(this.nodeHelper.getName((SimpleNode)arg));
        }
        return args;
    }

    public List<exprType> getSelfFilteredArgs() {
        ArrayList<exprType> args = new ArrayList<exprType>();
        if (((argumentsType)this.getASTNode()).args == null) {
            return args;
        }
        exprType[] exprTypeArray = ((argumentsType)this.getASTNode()).args;
        int n = ((argumentsType)this.getASTNode()).args.length;
        int n2 = 0;
        while (n2 < n) {
            exprType arg = exprTypeArray[n2];
            String argument = this.nodeHelper.getName((SimpleNode)arg);
            if (!this.nodeHelper.isSelf(argument)) {
                args.add((exprType)arg.createCopy());
            }
            ++n2;
        }
        return args;
    }

    public boolean isEmptyArgument() {
        return !this.hasArg() && !this.hasVarArg() && !this.hasKwArg();
    }

    public boolean hasOnlySelf() {
        return this.getSelfFilteredArgs().size() == 0 && !this.hasVarArg() && !this.hasKwArg();
    }

    public String getSignature() {
        argumentsType astNode = ((argumentsType)this.getASTNode()).createCopy();
        AdapterPrefs adapterPrefs = new AdapterPrefs(this.getModule().getEndLineDelimiter(), (IGrammarVersionProvider)this.getModule().nature);
        String ret = StringUtils.replaceNewLines((String)Rewriter.createSourceFromAST((SimpleNode)astNode, true, adapterPrefs), (String)"");
        return ret;
    }
}

