/*
 * Decompiled with CFR 0.152.
 */
package name.pachler.nio.file.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.impl.PathImpl;
import name.pachler.nio.file.impl.PathWatchEvent;
import name.pachler.nio.file.impl.PathWatchKey;
import name.pachler.nio.file.impl.PathWatchService;

class PollingPathWatchKey
extends PathWatchKey {
    private String[] fileNames;
    private long[] lastModifieds;
    private long[] lengths;

    PollingPathWatchKey(PathWatchService service, Path path, int flags) {
        super(service, path, flags);
    }

    String[] makeDirectoryEntryList() throws FileNotFoundException {
        PathImpl pathImpl = (PathImpl)this.getPath();
        File parentDirectory = pathImpl.getFile();
        File[] newFiles = parentDirectory.listFiles();
        if (newFiles == null) {
            throw new FileNotFoundException();
        }
        Object[] newFileNames = new String[newFiles.length];
        for (int i = 0; i < newFiles.length; ++i) {
            newFileNames[i] = newFiles[i].getName();
        }
        Arrays.sort(newFileNames);
        return newFileNames;
    }

    void readModtimesAndLengths(String[] entryList, long[] modtimes, long[] lengths, boolean deleteRemovedEntries) {
        PathImpl pathImpl = (PathImpl)this.getPath();
        File parentDirectory = pathImpl.getFile();
        for (int i = 0; i < entryList.length; ++i) {
            File file = new File(parentDirectory, entryList[i]);
            long modtime = file.lastModified();
            long length = file.length();
            if (modtime == 0L && deleteRemovedEntries) {
                entryList[i] = null;
                continue;
            }
            modtimes[i] = modtime;
            lengths[i] = length;
        }
    }

    public synchronized void setFlags(int flags) {
        int oldModifyFlag = this.getFlags() & 0x20;
        int newModifyFlag = flags & 0x20;
        super.setFlags(flags);
        if (oldModifyFlag > newModifyFlag) {
            this.lastModifieds = null;
            this.lengths = null;
        } else if (oldModifyFlag < newModifyFlag && this.fileNames != null) {
            this.lastModifieds = new long[this.fileNames.length];
            this.lengths = new long[this.fileNames.length];
            this.readModtimesAndLengths(this.fileNames, this.lastModifieds, this.lengths, false);
        }
    }

    boolean poll() throws FileNotFoundException {
        int flags = this.getFlags();
        int queuedEventsBefore = this.getNumQueuedEvents();
        String[] newFileNames = this.makeDirectoryEntryList();
        long[] newLastModifieds = null;
        long[] newLengths = null;
        if ((flags & 0x20) != 0) {
            newLastModifieds = new long[newFileNames.length];
            newLengths = new long[newFileNames.length];
            this.readModtimesAndLengths(newFileNames, newLastModifieds, newLengths, true);
        }
        if (this.lastModifieds == null || this.lengths == null) {
            this.lastModifieds = newLastModifieds;
            this.lengths = newLengths;
        }
        if (this.fileNames == null) {
            this.fileNames = newFileNames;
            return false;
        }
        int oldIndex = 0;
        int newIndex = 0;
        while (oldIndex < this.fileNames.length || newIndex < newFileNames.length) {
            PathWatchEvent e;
            PathImpl p;
            String oldName = null;
            String newName = null;
            int comparison = 0;
            if (oldIndex < this.fileNames.length) {
                oldName = this.fileNames[oldIndex];
                if (oldName == null) {
                    ++oldIndex;
                    continue;
                }
            } else {
                comparison = 1;
            }
            if (newIndex < newFileNames.length) {
                newName = newFileNames[newIndex];
                if (newName == null) {
                    ++newIndex;
                    continue;
                }
            } else {
                comparison = -1;
            }
            if (comparison == 0) {
                comparison = oldName.compareTo(newName);
            }
            if (comparison < 0) {
                if ((flags & 0x10) != 0) {
                    p = new PathImpl(new File(oldName));
                    e = new PathWatchEvent(StandardWatchEventKind.ENTRY_DELETE, p, 1);
                    this.addWatchEvent(e);
                }
                ++oldIndex;
                continue;
            }
            if (comparison > 0) {
                long newLength;
                if ((flags & 8) != 0) {
                    p = new PathImpl(new File(newName));
                    e = new PathWatchEvent(StandardWatchEventKind.ENTRY_CREATE, p, 1);
                    this.addWatchEvent(e);
                }
                if ((flags & 0x20) != 0 && (newLength = newLengths[newIndex]) > 0L) {
                    PathImpl p2 = new PathImpl(new File(newName));
                    PathWatchEvent e2 = new PathWatchEvent(StandardWatchEventKind.ENTRY_MODIFY, p2, 1);
                    this.addWatchEvent(e2);
                }
                ++newIndex;
                continue;
            }
            if ((flags & 0x20) != 0) {
                long lastModified = this.lastModifieds[oldIndex];
                long newLastModified = newLastModifieds[newIndex];
                long length = this.lengths[oldIndex];
                long newLength = newLengths[newIndex];
                if (lastModified != newLastModified || length != newLength) {
                    PathImpl p3 = new PathImpl(new File(newName));
                    PathWatchEvent e3 = new PathWatchEvent(StandardWatchEventKind.ENTRY_MODIFY, p3, 1);
                    this.addWatchEvent(e3);
                }
            }
            ++oldIndex;
            ++newIndex;
        }
        this.fileNames = newFileNames;
        this.lastModifieds = newLastModifieds;
        this.lengths = newLengths;
        int queuedEventsAfter = this.getNumQueuedEvents();
        return queuedEventsBefore < queuedEventsAfter;
    }
}

