/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.fastparser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.argumentsType;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.shared_core.string.DocIterator;
import org.python.pydev.shared_core.string.TextSelectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FastParser {
    private static final exprType[] EMTPY_EXPR_TYPE = new exprType[0];
    private static final decoratorsType[] EMTPY_DECORATORS_TYPE = new decoratorsType[0];
    private static final stmtType[] EMTPY_STMT_TYPE = new stmtType[0];
    private static final Pattern FUNCTION_PATTERN = Pattern.compile("(\\s+|^)(def\\s+)(\\w*)");
    private static final Pattern FUNCTION_PATTERN_CYTHON = Pattern.compile("(\\s+|^)(cdef\\s+)(.*)");
    private static final Pattern FUNCTION_PATTERN_CYTHON2 = Pattern.compile("(\\s+|^)(ctypedef\\s+)(.*)");
    private static final Pattern CLASS_PATTERN = Pattern.compile("(\\s+|^)(class\\s+)(\\w*)");
    private static final int PREFIX_GROUP = 2;
    private static final int NAME_GROUP = 3;
    private IDocument doc;
    private int currentLine;
    private boolean forward;
    private boolean stopOnFirstMatch;
    private boolean findGloballyAccessiblePath;
    private int firstCharCol = -1;
    private boolean cythonParse = false;

    private FastParser(IDocument doc, int currentLine, boolean forward, boolean stopOnFirstMatch) {
        this.doc = doc;
        this.currentLine = currentLine;
        this.forward = forward;
        this.stopOnFirstMatch = stopOnFirstMatch;
    }

    public static List<stmtType> parseClassesAndFunctions(IDocument doc) {
        return new FastParser(doc, 0, true, false).parse();
    }

    public static List<stmtType> parseCython(IDocument doc) {
        FastParser fastParser = new FastParser(doc, 0, true, false);
        fastParser.cythonParse = true;
        return fastParser.parse();
    }

    public static List<stmtType> parseToKnowGloballyAccessiblePath(IDocument doc, int currentLine) {
        FastParser parser = new FastParser(doc, currentLine, false, false);
        parser.findGloballyAccessiblePath = true;
        return parser.parse();
    }

    private static List<stmtType> parseClassesAndFunctions(IDocument doc, int currentLine, boolean forward, boolean stopOnFirstMatch) {
        return new FastParser(doc, currentLine, forward, stopOnFirstMatch).parse();
    }

    private List<stmtType> parse() {
        ArrayList<stmtType> body = new ArrayList<stmtType>();
        PySelection ps = new PySelection(this.doc);
        DocIterator it = new DocIterator(this.forward, (TextSelectionUtils)ps, this.currentLine, false);
        Matcher functionMatcher = FUNCTION_PATTERN.matcher("");
        ArrayList<Matcher> cythonMatchers = null;
        if (this.cythonParse) {
            cythonMatchers = new ArrayList<Matcher>();
            cythonMatchers.add(FUNCTION_PATTERN_CYTHON.matcher(""));
            cythonMatchers.add(FUNCTION_PATTERN_CYTHON2.matcher(""));
        }
        Matcher classMatcher = CLASS_PATTERN.matcher("");
        while (it.hasNext()) {
            NameTok nameTok;
            int lastReturnedLine;
            Matcher functionFound = null;
            String line = it.next();
            if (line.trim().length() == 0) continue;
            if (this.findGloballyAccessiblePath) {
                int currentFirstCharCol = PySelection.getFirstCharPosition((String)line);
                if (this.firstCharCol == -1) {
                    this.firstCharCol = currentFirstCharCol;
                } else if (this.firstCharCol <= currentFirstCharCol) continue;
            }
            functionMatcher.reset(line);
            if (functionMatcher.find()) {
                functionFound = functionMatcher;
            } else if (cythonMatchers != null) {
                for (Matcher matcher : cythonMatchers) {
                    matcher.reset(line);
                    if (!matcher.find()) continue;
                    functionFound = matcher;
                    break;
                }
            }
            if (functionFound != null) {
                lastReturnedLine = it.getLastReturnedLine();
                nameTok = this.createNameTok(functionFound, lastReturnedLine, 2, ps);
                if (nameTok == null) continue;
                FunctionDef functionDef = this.createFunctionDef(lastReturnedLine, nameTok, PySelection.getFirstCharPosition((String)line));
                if (!this.addStatement(body, functionDef)) {
                    return body;
                }
                if (!this.stopOnFirstMatch) continue;
                return body;
            }
            classMatcher.reset(line);
            if (!classMatcher.find() || (nameTok = this.createNameTok(classMatcher, lastReturnedLine = it.getLastReturnedLine(), 1, ps)) == null) continue;
            ClassDef classDef = this.createClassDef(lastReturnedLine, nameTok, PySelection.getFirstCharPosition((String)line));
            if (!this.addStatement(body, classDef)) {
                return body;
            }
            if (!this.stopOnFirstMatch) continue;
            return body;
        }
        return body;
    }

    private boolean addStatement(List<stmtType> body, stmtType stmt) {
        if (!this.findGloballyAccessiblePath) {
            body.add(stmt);
            return true;
        }
        if (body.size() > 0 && stmt.beginColumn == body.get((int)0).beginColumn) {
            return true;
        }
        body.add(0, stmt);
        return stmt.beginColumn != 1;
    }

    private FunctionDef createFunctionDef(int lastReturnedLine, NameTok nameTok, int matchedCol) {
        argumentsType args = new argumentsType(EMTPY_EXPR_TYPE, null, null, EMTPY_EXPR_TYPE, null, null, null, null, null, null);
        FunctionDef functionDef = new FunctionDef(nameTok, args, EMTPY_STMT_TYPE, EMTPY_DECORATORS_TYPE, null);
        functionDef.beginLine = lastReturnedLine + 1;
        functionDef.beginColumn = matchedCol + 1;
        return functionDef;
    }

    private ClassDef createClassDef(int lastReturnedLine, NameTok nameTok, int matchedCol) {
        ClassDef classDef = new ClassDef(nameTok, EMTPY_EXPR_TYPE, EMTPY_STMT_TYPE, null, null, null, null);
        classDef.beginLine = lastReturnedLine + 1;
        classDef.beginColumn = matchedCol + 1;
        return classDef;
    }

    public static stmtType firstClassOrFunction(IDocument doc, int currentLine, boolean forward, boolean isCython) {
        boolean stopOnFirstMatch = true;
        FastParser fastParser = new FastParser(doc, currentLine, forward, stopOnFirstMatch);
        fastParser.cythonParse = isCython;
        List<stmtType> found = fastParser.parse();
        if (found.size() > 0) {
            return found.get(0);
        }
        return null;
    }

    private NameTok createNameTok(Matcher matcher, int lastReturnedLine, int type, PySelection ps) {
        int col = matcher.start(3);
        int absoluteCursorOffset = ps.getAbsoluteCursorOffset(lastReturnedLine, col);
        if (ParsingUtils.getContentType((IDocument)ps.getDoc(), (int)absoluteCursorOffset) != "__dftl_partition_content_type") {
            return null;
        }
        NameTok nameTok = new NameTok(matcher.group(3), type);
        nameTok.beginLine = lastReturnedLine + 1;
        nameTok.beginColumn = col + 1;
        return nameTok;
    }
}

