/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.string;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.shared_core.cache.Cache;
import org.python.pydev.shared_core.cache.LRUCache;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.NoPeerAvailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    private static final Object md5CacheLock = new Object();
    private static final LRUCache<String, String> md5Cache = new LRUCache(1000);
    public static String BOM_UTF8 = new String(new char[]{'\u00ef', '\u00bb', '\u00bf'});
    public static String BOM_UNICODE = new String(new char[]{'\ufeff'});
    private static Cache<Integer, String> widthToSpaceString = new LRUCache<Integer, String>(8);

    public static Iterable<String> iterLines(final String string) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new IterLines(string);
            }
        };
    }

    public static Object join(String delimiter, String[] splitted, Class<? extends Object> returnType) {
        int len = splitted.length;
        switch (len) {
            case 0: {
                return "";
            }
            case 1: {
                return splitted[0];
            }
        }
        int delimiterLen = delimiter.length();
        int totalSize = delimiterLen * (len - 1);
        int i = 0;
        while (i < len) {
            totalSize += splitted[i].length();
            ++i;
        }
        char[] buf = new char[totalSize];
        int count = 0;
        String string = splitted[0];
        int strLen = string.length();
        string.getChars(0, strLen, buf, count);
        count += strLen;
        switch (delimiterLen) {
            case 0: {
                int i2 = 1;
                while (i2 < len) {
                    string = splitted[i2];
                    strLen = string.length();
                    string.getChars(0, strLen, buf, count);
                    count += strLen;
                    ++i2;
                }
                break;
            }
            case 1: {
                char delimiterChar = delimiter.charAt(0);
                int i3 = 1;
                while (i3 < len) {
                    buf[count] = delimiterChar;
                    string = splitted[i3];
                    strLen = string.length();
                    string.getChars(0, strLen, buf, ++count);
                    count += strLen;
                    ++i3;
                }
                break;
            }
            case 2: {
                char delimiterChar0 = delimiter.charAt(0);
                char delimiterChar1 = delimiter.charAt(1);
                int i4 = 1;
                while (i4 < len) {
                    buf[count] = delimiterChar0;
                    buf[count + 1] = delimiterChar1;
                    string = splitted[i4];
                    strLen = string.length();
                    string.getChars(0, strLen, buf, count += 2);
                    count += strLen;
                    ++i4;
                }
                break;
            }
            default: {
                int i5 = 1;
                while (i5 < len) {
                    strLen = delimiterLen;
                    delimiter.getChars(0, strLen, buf, count);
                    count += strLen;
                    string = splitted[i5];
                    strLen = string.length();
                    string.getChars(0, strLen, buf, count);
                    count += strLen;
                    ++i5;
                }
                break block4;
            }
        }
        if (returnType == null || returnType == String.class) {
            return new String(buf);
        }
        if (returnType == FastStringBuffer.class) {
            return new FastStringBuffer(buf);
        }
        if (returnType == char[].class) {
            return buf;
        }
        throw new RuntimeException("Don't know how to handle return type: " + returnType);
    }

    public static String join(String delimiter, String[] splitted, int startAtSegment, int endAtSegment) {
        String[] s = new String[endAtSegment - startAtSegment];
        int i = startAtSegment;
        int j = 0;
        while (i < splitted.length && i < endAtSegment) {
            s[j] = splitted[i];
            ++i;
            ++j;
        }
        return StringUtils.join(delimiter, s);
    }

    public static String join(String delimiter, Collection splitted) {
        int size = splitted.size();
        if (size == 0) {
            return "";
        }
        Object[] arr = new Object[size];
        return StringUtils.join(delimiter, splitted.toArray(arr));
    }

    public static String join(String delimiter, String[] splitted) {
        return (String)StringUtils.join(delimiter, splitted, null);
    }

    public static String join(String delimiter, Object ... splitted) {
        String[] newSplitted = new String[splitted.length];
        int i = 0;
        while (i < splitted.length) {
            Object s = splitted[i];
            newSplitted[i] = s == null ? "null" : s.toString();
            ++i;
        }
        return StringUtils.join(delimiter, newSplitted);
    }

    public static String format(String str, Object ... args) {
        int length = str.length();
        FastStringBuffer buffer = new FastStringBuffer(length + 16 * args.length);
        int j = 0;
        int i = 0;
        int start = 0;
        while (i < length) {
            char c = str.charAt(i);
            if (c == '%' && i + 1 < length) {
                if (i > start) {
                    buffer.append(str.substring(start, i));
                }
                char nextC = str.charAt(i + 1);
                switch (nextC) {
                    case 's': {
                        buffer.appendObject(args[j]);
                        ++j;
                        break;
                    }
                    case '%': {
                        buffer.append('%');
                        ++j;
                    }
                }
                start = ++i + 1;
            }
            ++i;
        }
        if (i > start) {
            buffer.append(str.substring(start, i));
        }
        return buffer.toString();
    }

    public static long parsePositiveLong(FastStringBuffer buf) {
        char[] array = buf.getInternalCharsArray();
        int len = buf.length();
        if (len == 0) {
            throw new NumberFormatException("Empty string received");
        }
        long result = 0L;
        int zeroAsInt = 48;
        int i = 0;
        while (i < len) {
            result *= 10L;
            int c = array[i] - zeroAsInt;
            if (c < 0 || c > 9) {
                throw new NumberFormatException("Error getting positive int from: " + buf);
            }
            result += (long)c;
            ++i;
        }
        return result;
    }

    public static int parsePositiveInt(FastStringBuffer buf) {
        char[] array = buf.getInternalCharsArray();
        int len = buf.length();
        if (len == 0) {
            throw new NumberFormatException("Empty string received");
        }
        int result = 0;
        int zeroAsInt = 48;
        int i = 0;
        while (i < len) {
            result *= 10;
            int c = array[i] - zeroAsInt;
            if (c < 0 || c > 9) {
                throw new NumberFormatException("Error getting positive int from: " + buf);
            }
            result += c;
            ++i;
        }
        return result;
    }

    public static int countLineBreaks(String replacementString) {
        int lineBreaks = 0;
        int ignoreNextNAt = -1;
        int len = replacementString.length();
        int i = 0;
        while (i < len) {
            char c = replacementString.charAt(i);
            if (c == '\r') {
                ++lineBreaks;
                ignoreNextNAt = i + 1;
            } else if (c == '\n' && ignoreNextNAt != i) {
                ++lineBreaks;
            }
            ++i;
        }
        return lineBreaks;
    }

    public static String md5(String str) {
        Object object = md5CacheLock;
        synchronized (object) {
            String obj = (String)md5Cache.getObj(str);
            if (obj != null) {
                return obj;
            }
            try {
                byte[] bytes = str.getBytes("UTF-8");
                MessageDigest md = MessageDigest.getInstance("MD5");
                String ret = new BigInteger(1, md.digest(bytes)).toString(36).toLowerCase();
                md5Cache.add(str, ret);
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static List<String> split(String string, char toSplit, int maxPartsToSplit) {
        Assert.isTrue((maxPartsToSplit > 0 ? 1 : 0) != 0);
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit) {
                if (last != i) {
                    if (ret.size() == maxPartsToSplit - 1) {
                        ret.add(string.substring(last, len));
                        return ret;
                    }
                    ret.add(string.substring(last, i));
                }
                while (c == toSplit && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (c != toSplit) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret;
    }

    public static List<String> split(String string, String toSplit) {
        if (toSplit.length() == 1) {
            return StringUtils.split(string, toSplit.charAt(0));
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (toSplit.length() == 0) {
            ret.add(string);
            return ret;
        }
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit.charAt(0) && StringUtils.matches(string, toSplit, i)) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                last = i + toSplit.length();
                i += toSplit.length() - 1;
            }
            ++i;
        }
        if (last < len) {
            ret.add(string.substring(last, len));
        }
        return ret;
    }

    private static boolean matches(String string, String toSplit, int i) {
        int toSplitLen;
        int length = string.length();
        if (length - i >= (toSplitLen = toSplit.length())) {
            int j = 0;
            while (j < toSplitLen) {
                if (string.charAt(i + j) != toSplit.charAt(j)) {
                    return false;
                }
                ++j;
            }
            return true;
        }
        return false;
    }

    public static List<String> split(String string, char toSplit) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (c == toSplit && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (c != toSplit) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        return ret;
    }

    public static List<String> splitInLines(String string) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        FastStringBuffer buf = new FastStringBuffer();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            buf.append(c);
            if (c == '\r') {
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                    buf.append('\n');
                }
                ret.add(buf.toString());
                buf.clear();
            }
            if (c == '\n') {
                ret.add(buf.toString());
                buf.clear();
            }
            ++i;
        }
        if (buf.length() != 0) {
            ret.add(buf.toString());
        }
        return ret;
    }

    public static List<String> splitInLines(String string, boolean addNewLines) {
        if (addNewLines) {
            return StringUtils.splitInLines(string);
        }
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        FastStringBuffer buf = new FastStringBuffer();
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            buf.append(c);
            if (c == '\r') {
                buf.deleteLast();
                if (i < len - 1 && string.charAt(i + 1) == '\n') {
                    ++i;
                }
                ret.add(buf.toString());
                buf.clear();
            }
            if (c == '\n') {
                buf.deleteLast();
                ret.add(buf.toString());
                buf.clear();
            }
            ++i;
        }
        if (buf.length() != 0) {
            ret.add(buf.toString());
        }
        return ret;
    }

    public static String removeBom(String contents) {
        if (contents.startsWith(BOM_UTF8)) {
            contents = contents.substring(BOM_UTF8.length());
        }
        return contents;
    }

    public static String createSpaceString(int width) {
        String existing = widthToSpaceString.getObj(width);
        if (existing != null) {
            return existing;
        }
        FastStringBuffer buf = new FastStringBuffer(width);
        buf.appendN(' ', width);
        String newStr = buf.toString();
        widthToSpaceString.add(width, newStr);
        return newStr;
    }

    public static String getWithClosedPeer(char c) {
        switch (c) {
            case '{': {
                return "{}";
            }
            case '(': {
                return "()";
            }
            case '[': {
                return "[]";
            }
            case '<': {
                return "<>";
            }
            case '\'': {
                return "''";
            }
            case '\"': {
                return "\"\"";
            }
        }
        throw new NoPeerAvailableException("Unable to find peer for :" + c);
    }

    public static boolean isClosingPeer(char lastChar) {
        return lastChar == ')' || lastChar == ']' || lastChar == '}' || lastChar == '>';
    }

    public static char getPeer(char c) {
        switch (c) {
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '>': {
                return '<';
            }
            case '<': {
                return '>';
            }
        }
        throw new NoPeerAvailableException("Unable to find peer for :" + c);
    }

    public static int countChars(char c, StringBuffer line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static int countChars(char c, FastStringBuffer line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static int countChars(char c, String line) {
        int ret = 0;
        int len = line.length();
        int i = 0;
        while (i < len) {
            if (line.charAt(i) == c) {
                ++ret;
            }
            ++i;
        }
        return ret;
    }

    public static String replaceNewLines(String message, String string) {
        message = message.replaceAll("\r\n", string);
        message = message.replaceAll("\r", string);
        message = message.replaceAll("\n", string);
        return message;
    }

    public static String replaceAll(String string, String replace, String with) {
        FastStringBuffer ret = new FastStringBuffer(string, 16);
        return ret.replaceAll(replace, with).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IterLines
    implements Iterator<String> {
        private final String string;
        private final int len;
        private int i;
        private boolean calculatedNext;
        private boolean hasNext;
        private String next;

        private IterLines(String string) {
            this.string = string;
            this.len = string.length();
        }

        @Override
        public boolean hasNext() {
            if (!this.calculatedNext) {
                this.calculatedNext = true;
                this.hasNext = this.calculateNext();
            }
            return this.hasNext;
        }

        private boolean calculateNext() {
            this.next = null;
            int start = this.i;
            while (this.i < this.len) {
                char c = this.string.charAt(this.i);
                if (c == '\r') {
                    if (this.i < this.len - 1 && this.string.charAt(this.i + 1) == '\n') {
                        ++this.i;
                    }
                    ++this.i;
                    this.next = this.string.substring(start, this.i);
                    return true;
                }
                if (c == '\n') {
                    ++this.i;
                    this.next = this.string.substring(start, this.i);
                    return true;
                }
                ++this.i;
            }
            if (start != this.i) {
                this.next = this.string.substring(start, this.i);
                ++this.i;
                return true;
            }
            return false;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String n = this.next;
            this.calculatedNext = false;
            this.next = null;
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

