/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_core.actions;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineUncommentAction {
    private TextSelectionUtils ps;
    private String commentPattern;
    private int spacesInStart;

    public LineUncommentAction(TextSelectionUtils ps, String commentPattern, int spacesInStart) {
        this.ps = ps;
        this.commentPattern = commentPattern;
        this.spacesInStart = spacesInStart;
    }

    public FastStringBuffer uncommentLines(String selectedText) {
        List<String> ret = StringUtils.splitInLines(selectedText);
        FastStringBuffer strbuf = new FastStringBuffer(selectedText.length() + ret.size() * 2);
        String spacesInStartComment = "";
        if (this.spacesInStart > 0) {
            spacesInStartComment = StringUtils.createSpaceString(this.spacesInStart);
        }
        String expectedStart = String.valueOf(this.commentPattern) + spacesInStartComment;
        boolean allStartWithSpaces = true;
        for (String string : ret) {
            if (string.startsWith(expectedStart)) continue;
            expectedStart = this.commentPattern;
            allStartWithSpaces = false;
            break;
        }
        if (allStartWithSpaces) {
            for (String line : ret) {
                strbuf.append(line.substring(expectedStart.length()));
            }
        } else {
            for (String line : ret) {
                if (line.startsWith(expectedStart)) {
                    strbuf.append(line.substring(expectedStart.length()));
                    continue;
                }
                strbuf.append(line);
            }
        }
        return strbuf;
    }

    public Tuple<Integer, Integer> execute() throws BadLocationException {
        this.ps.selectCompleteLine();
        String selectedText = this.ps.getSelectedText();
        FastStringBuffer strbuf = this.uncommentLines(selectedText);
        ITextSelection txtSel = this.ps.getTextSelection();
        int start = txtSel.getOffset();
        int len = txtSel.getLength();
        String replacement = strbuf.toString();
        this.ps.getDoc().replace(start, len, replacement);
        return new Tuple<Integer, Integer>(start, replacement.length());
    }
}

