/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.tooltips.presenter;

import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.python.pydev.core.tooltips.presenter.IInformationPresenterAsTooltip;
import org.python.pydev.core.tooltips.presenter.IInformationPresenterControlManager;
import org.python.pydev.core.tooltips.presenter.ITooltipInformationProvider;
import org.python.pydev.core.tooltips.presenter.InformationPresenterControlManager;
import org.python.pydev.core.uiutils.UIUtils;
import org.python.pydev.shared_ui.bindings.KeyBindingHelper;

public class ToolTipPresenterHandler {
    public static final String TIP_DATA = "TIP_DATA";
    private Shell tipShell;
    private Label tipLabelImage;
    private Label tipLabelText;
    private Widget tipWidget;
    private IInformationPresenterControlManager informationPresenterManager;
    private DefaultInformationControl.IInformationPresenter presenter;

    public ToolTipPresenterHandler(Shell parent) {
        this(parent, null);
    }

    public ToolTipPresenterHandler(Shell parent, DefaultInformationControl.IInformationPresenter presenter) {
        this(parent, presenter, null);
    }

    public ToolTipPresenterHandler(Shell parent, DefaultInformationControl.IInformationPresenter presenter, String tooltipAffordanceString) {
        this.presenter = presenter;
        this.informationPresenterManager = new InformationPresenterControlManager(presenter, tooltipAffordanceString);
    }

    private void disposeOfCurrentTipShell() {
        if (this.tipShell != null) {
            this.tipShell.dispose();
            this.tipShell = null;
        }
        this.tipWidget = null;
    }

    public void install(Control control) {
        this.informationPresenterManager.install(control);
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ToolTipPresenterHandler.this.disposeOfCurrentTipShell();
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                ToolTipPresenterHandler.this.disposeOfCurrentTipShell();
            }

            public void mouseHover(MouseEvent event) {
                ToolBar w;
                Point pt = new Point(event.x, event.y);
                Widget widget = event.widget;
                if (widget instanceof ToolBar) {
                    w = (ToolBar)widget;
                    widget = w.getItem(pt);
                }
                if (widget instanceof Table) {
                    w = (Table)widget;
                    widget = w.getItem(pt);
                }
                if (widget instanceof Tree) {
                    w = (Tree)widget;
                    widget = w.getItem(pt);
                }
                if (widget == null) {
                    ToolTipPresenterHandler.this.disposeOfCurrentTipShell();
                    return;
                }
                if (widget == ToolTipPresenterHandler.this.tipWidget) {
                    return;
                }
                ToolTipPresenterHandler.this.tipWidget = widget;
                Object data = widget.getData(ToolTipPresenterHandler.TIP_DATA);
                if (data == null) {
                    return;
                }
                final String text = data instanceof String ? (String)data : data.toString();
                if (text == null) {
                    return;
                }
                KeySequence activateEditorBinding = KeyBindingHelper.getCommandKeyBinding((String)"org.eclipse.ui.window.activateEditor");
                ToolTipPresenterHandler.this.informationPresenterManager.setActivateEditorBinding(activateEditorBinding);
                Shell activeShell = UIUtils.getActiveShell();
                ToolTipPresenterHandler.this.informationPresenterManager.setInitiallyActiveShell(activeShell);
                ToolTipPresenterHandler.this.createControls();
                final Point pos = new Point(pt.x + 10, pt.y);
                ITooltipInformationProvider provider = new ITooltipInformationProvider(){

                    public Object getInformation(Control fControl) {
                        return text;
                    }

                    public Point getPosition(Control fControl) {
                        return pos;
                    }
                };
                if (ToolTipPresenterHandler.this.presenter instanceof IInformationPresenterAsTooltip) {
                    IInformationPresenterAsTooltip iInformationPresenterAsTooltip = (IInformationPresenterAsTooltip)ToolTipPresenterHandler.this.presenter;
                    iInformationPresenterAsTooltip.setData(data);
                }
                ToolTipPresenterHandler.this.informationPresenterManager.setInformationProvider(provider);
                ToolTipPresenterHandler.this.informationPresenterManager.showInformation();
            }
        });
    }

    private void createControls() {
        Display display = UIUtils.getDisplay();
        if (this.tipShell != null) {
            return;
        }
        this.tipShell = new Shell(display, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.tipShell.setLayout((Layout)gridLayout);
        this.tipShell.setBackground(display.getSystemColor(29));
        this.tipLabelImage = new Label((Composite)this.tipShell, 0);
        this.tipLabelImage.setForeground(display.getSystemColor(28));
        this.tipLabelImage.setBackground(display.getSystemColor(29));
        this.tipLabelImage.setLayoutData((Object)new GridData(772));
        this.tipLabelText = new Label((Composite)this.tipShell, 0);
        this.tipLabelText.setForeground(display.getSystemColor(28));
        this.tipLabelText.setBackground(display.getSystemColor(29));
        this.tipLabelText.setLayoutData((Object)new GridData(772));
    }
}

