/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.path_watch;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.python.pydev.core.ListenerList;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.path_watch.DirectoryChangeListener;

class DirectoryWatcher {
    private static final long DEFAULT_POLL_FREQUENCY = 10000L;
    private final File[] directories;
    private ListenerList<DirectoryChangeListener> listeners = new ListenerList<DirectoryChangeListener>(DirectoryChangeListener.class);
    private Set<File> scannedFiles = new HashSet<File>();
    private Set<File> removals;
    private WatcherThread watcher;
    private boolean watchSubdirs;

    DirectoryWatcher(File directory, boolean watchSubtree) {
        if (directory == null) {
            throw new IllegalArgumentException("Null folder");
        }
        this.directories = new File[]{directory};
        this.watchSubdirs = watchSubtree;
    }

    synchronized void addListener(DirectoryChangeListener listener) {
        this.listeners.add(listener);
    }

    synchronized void removeListener(DirectoryChangeListener listener) {
        this.listeners.remove(listener);
    }

    void start() {
        this.start(10000L);
    }

    private synchronized void poll() {
        this.startPoll();
        this.scanDirectories();
        this.stopPoll();
    }

    private synchronized void start(long pollFrequency) {
        if (this.watcher != null) {
            throw new IllegalStateException("Thread already started");
        }
        this.watcher = new WatcherThread(pollFrequency);
        this.watcher.start();
    }

    synchronized void stop() {
        if (this.watcher == null) {
            throw new IllegalStateException("Unable to stop (thread not started)");
        }
        this.watcher.done();
        this.watcher = null;
    }

    synchronized void dispose() {
        if (this.watcher != null) {
            this.stop();
        }
        if (this.listeners != null) {
            DirectoryChangeListener[] directoryChangeListenerArray = this.listeners.getListeners();
            int n = directoryChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirectoryChangeListener listener = directoryChangeListenerArray[n2];
                this.removeListener(listener);
                ++n2;
            }
        }
    }

    private void startPoll() {
        this.removals = this.scannedFiles;
        this.scannedFiles = new HashSet<File>();
        DirectoryChangeListener[] directoryChangeListenerArray = this.listeners.getListeners();
        int n = directoryChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DirectoryChangeListener l = directoryChangeListenerArray[n2];
            l.startPoll();
            ++n2;
        }
    }

    private void scanDirectories() {
        int index = 0;
        while (index < this.directories.length) {
            File directory = this.directories[index];
            this.scanDirectoryRecursively(directory);
            ++index;
        }
    }

    private void scanDirectoryRecursively(File directory) {
        if (directory == null) {
            return;
        }
        File[] list = directory.listFiles();
        if (list == null) {
            return;
        }
        int i = 0;
        while (i < list.length) {
            File file = list[i];
            this.scannedFiles.add(file);
            this.removals.remove(file);
            DirectoryChangeListener[] directoryChangeListenerArray = this.listeners.getListeners();
            int n = directoryChangeListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                DirectoryChangeListener listener = directoryChangeListenerArray[n2];
                if (this.isInterested(listener, file)) {
                    this.processFile(file, listener);
                }
                ++n2;
            }
            if (this.watchSubdirs && file.isDirectory()) {
                this.scanDirectoryRecursively(file);
            }
            ++i;
        }
    }

    private void stopPoll() {
        this.notifyRemovals();
        this.removals = this.scannedFiles;
        DirectoryChangeListener[] directoryChangeListenerArray = this.listeners.getListeners();
        int n = directoryChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DirectoryChangeListener l = directoryChangeListenerArray[n2];
            l.stopPoll();
            ++n2;
        }
    }

    private boolean isInterested(DirectoryChangeListener listener, File file) {
        return listener.isInterested(file);
    }

    private void notifyRemovals() {
        Set<File> removed = this.removals;
        DirectoryChangeListener[] directoryChangeListenerArray = this.listeners.getListeners();
        int n = directoryChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DirectoryChangeListener listener = directoryChangeListenerArray[n2];
            for (File file : removed) {
                if (!this.isInterested(listener, file)) continue;
                listener.removed(file);
            }
            ++n2;
        }
    }

    private void processFile(File file, DirectoryChangeListener listener) {
        try {
            Long oldTimestamp = listener.getSeenFile(file);
            if (oldTimestamp == null) {
                listener.added(file);
            } else {
                long lastModified = file.lastModified();
                if (oldTimestamp != lastModified) {
                    listener.changed(file);
                }
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    private class WatcherThread
    extends Thread {
        private final long pollFrequency;
        private boolean done;

        private WatcherThread(long frequency) {
            super("Directory Watcher");
            this.done = false;
            this.pollFrequency = frequency;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            do {
                try {
                    DirectoryWatcher.this.poll();
                    WatcherThread watcherThread = this;
                    synchronized (watcherThread) {
                        this.wait(this.pollFrequency);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Throwable e) {
                    Log.log(e);
                    this.done = true;
                }
            } while (!this.done);
        }

        private synchronized void done() {
            this.done = true;
            this.notify();
        }
    }
}

