/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pep8;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.messages.IMessage;
import com.python.pydev.analysis.messages.Message;
import com.python.pydev.analysis.ui.AnalysisPreferencesPage;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.pydev.core.NullOutputStream;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.jython.IPythonInterpreter;
import org.python.pydev.jython.JythonPlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pep8Visitor {
    private static final String EXECUTE_PEP8 = "import sys\nargv = ['pep8.py', r'%s'%s]\nsys.argv=argv\n\nif pep8 == None:\n    add_to_pythonpath = '%s'\n    if add_to_pythonpath not in sys.path:\n        sys.path.append(add_to_pythonpath)\n    import pep8\n\noptions, args = pep8.process_options(argv[1:])\nchecker = pep8.Checker(options, '%s', lines)\n\ndef report_error(line_number, offset, text, check):\n    code = text[:4]\n    if pep8.ignore_code(checker.options, code) or code in checker.expected:\n        return\n    visitor.reportError(line_number, offset, text, check)\n    return original(line_number, offset, text, check)\n\n\noriginal = checker.report_error\nchecker.report_error = report_error\n\nchecker.check_all()\n\n";
    private final List<IMessage> messages = new ArrayList<IMessage>();
    private IAnalysisPreferences prefs;
    private IDocument document;
    private static volatile PyObject pep8;
    private static final Object lock;
    private String messageToIgnore;

    static {
        lock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IMessage> getMessages(SourceModule module, IDocument document, IProgressMonitor monitor, IAnalysisPreferences prefs) {
        block12: {
            try {
                if (prefs.getSeverityForType(15) < 1) {
                    return this.messages;
                }
                this.messageToIgnore = prefs.getRequiredMessageToIgnore(15);
                String[] pep8CommandLine = AnalysisPreferencesPage.getPep8CommandLine();
                FastStringBuffer args = new FastStringBuffer(pep8CommandLine.length * 20);
                String[] stringArray = pep8CommandLine;
                int n = pep8CommandLine.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    args.append(',').append("r'").append(string).append('\'');
                    ++n2;
                }
                String pep8Location = AnalysisPreferencesPage.getPep8Location();
                File pep8Loc = new File(pep8Location);
                if (!pep8Loc.exists()) {
                    Log.log((String)("Specified location for pep8.py does not exist (" + pep8Location + ")."));
                    return this.messages;
                }
                this.prefs = prefs;
                this.document = document;
                boolean useConsole = AnalysisPreferencesPage.useConsole();
                IPythonInterpreter interpreter = JythonPlugin.newPythonInterpreter((boolean)useConsole, (boolean)false);
                if (!useConsole) {
                    interpreter.setErr((OutputStream)NullOutputStream.singleton);
                    interpreter.setOut((OutputStream)NullOutputStream.singleton);
                }
                String file = StringUtils.replaceAllSlashes((String)module.getFile().getAbsolutePath());
                interpreter.set("visitor", (Object)this);
                List splitInLines = StringUtils.splitInLines((String)document.get());
                interpreter.set("lines", (Object)splitInLines);
                PyObject tempPep8 = pep8;
                if (tempPep8 != null) {
                    interpreter.set("pep8", (Object)tempPep8);
                } else {
                    interpreter.set("pep8", (Object)Py.None);
                }
                String formatted = org.python.pydev.shared_core.string.StringUtils.format((String)EXECUTE_PEP8, (Object[])new Object[]{file, args.toString(), StringUtils.replaceAllSlashes((String)pep8Loc.getParentFile().getAbsolutePath()), file});
                interpreter.exec(formatted);
                if (pep8 != null) break block12;
                Object object = lock;
                synchronized (object) {
                    if (pep8 == null) {
                        pep8 = interpreter.get("pep8");
                    }
                }
            }
            catch (Exception e) {
                Log.log((String)("Error analyzing: " + module), (Throwable)e);
            }
        }
        return this.messages;
    }

    public void reportError(int lineNumber, int offset, String text, Object check) {
        int startLine;
        String line;
        int len;
        try {
            len = this.document.getLineLength(lineNumber - 1);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        if (this.messageToIgnore != null && (line = PySelection.getLine((IDocument)this.document, (int)(startLine = lineNumber - 1))).indexOf(this.messageToIgnore) != -1) {
            return;
        }
        this.messages.add(new Message(15, text, lineNumber, lineNumber, offset + 1, len, this.prefs));
    }
}

