/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.additionalinfo.IInfo;
import java.io.Serializable;
import org.python.pydev.core.ObjectsPool;

public abstract class AbstractInfo
implements IInfo,
Serializable {
    private static final long serialVersionUID = 3L;
    public final String name;
    public final String path;
    public final String moduleDeclared;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractInfo(String name, String moduleDeclared, String path) {
        Object object = ObjectsPool.lock;
        synchronized (object) {
            this.name = ObjectsPool.internUnsynched((String)name);
            this.moduleDeclared = ObjectsPool.internUnsynched((String)moduleDeclared);
            this.path = ObjectsPool.internUnsynched((String)path);
        }
    }

    public AbstractInfo(String name, String moduleDeclared, String path, boolean doNotInternOnThisContstruct) {
        this.name = name;
        this.moduleDeclared = moduleDeclared;
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public String getDeclaringModuleName() {
        return this.moduleDeclared;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IInfo)) {
            return false;
        }
        IInfo otherInfo = (IInfo)obj;
        if (otherInfo.getType() != this.getType()) {
            return false;
        }
        if (!otherInfo.getDeclaringModuleName().equals(this.moduleDeclared)) {
            return false;
        }
        if (!otherInfo.getName().equals(this.name)) {
            return false;
        }
        String otherPath = otherInfo.getPath();
        String myPath = this.getPath();
        if (otherPath == null || myPath == null) {
            return otherPath == myPath;
        }
        return otherPath.equals(myPath);
    }

    public int hashCode() {
        return 7 * this.name.hashCode() + this.moduleDeclared.hashCode() * this.getType();
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.moduleDeclared + ") - Path:" + this.getPath();
    }

    public int compareTo(IInfo o) {
        int r = this.name.compareTo(o.getName());
        if (r != 0) {
            return r;
        }
        return this.moduleDeclared.compareTo(o.getDeclaringModuleName());
    }
}

